/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignField;

public abstract class JRAbstractBeanDataSourceProvider
implements JRDataSourceProvider {
    public static final String EXCEPTION_MESSAGE_KEY_NULL_BEAN_CLASS = "data.bean.constructor.argument.cannot.be.null";
    private Class<?> beanClass;

    public JRAbstractBeanDataSourceProvider(Class<?> beanClass) {
        if (beanClass == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NULL_BEAN_CLASS, new Object[]{"beanClass"});
        }
        this.beanClass = beanClass;
    }

    @Override
    public boolean supportsGetFieldsOperation() {
        return true;
    }

    @Override
    public JRField[] getFields(JasperReport report) throws JRException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.beanClass);
        }
        catch (IntrospectionException e2) {
            throw new JRException(e2);
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors != null) {
            ArrayList<JRDesignField> fields = new ArrayList<JRDesignField>(descriptors.length);
            for (int i2 = 0; i2 < descriptors.length; ++i2) {
                PropertyDescriptor descriptor = descriptors[i2];
                if (descriptor instanceof IndexedPropertyDescriptor || descriptor.getReadMethod() == null) continue;
                JRDesignField field = new JRDesignField();
                field.setValueClassName(JRAbstractBeanDataSourceProvider.normalizeClass(descriptor.getPropertyType()).getCanonicalName());
                field.setName(descriptor.getName());
                fields.add(field);
            }
            return fields.toArray(new JRField[fields.size()]);
        }
        return new JRField[0];
    }

    private static Class<?> normalizeClass(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazz == Byte.TYPE) {
                return Byte.class;
            }
            if (clazz == Character.TYPE) {
                return Character.class;
            }
            if (clazz == Short.TYPE) {
                return Short.class;
            }
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == Float.TYPE) {
                return Float.class;
            }
            if (clazz == Double.TYPE) {
                return Double.class;
            }
        }
        return clazz;
    }
}

