/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRAbstractTextDataSource;
import net.sf.jasperreports.engine.data.JsonData;
import net.sf.jasperreports.engine.util.JsonUtil;

public class JsonDataSource
extends JRAbstractTextDataSource
implements JsonData {
    public static final String EXCEPTION_MESSAGE_KEY_JSON_FIELD_VALUE_NOT_RETRIEVED = "data.json.field.value.not.retrieved";
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_ATTRIBUTE_SELECTION = "data.json.invalid.attribute.selection";
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_EXPRESSION = "data.json.invalid.expression";
    public static final String EXCEPTION_MESSAGE_KEY_NO_DATA = "data.json.no.data";
    private String selectExpression;
    private Iterator<JsonNode> jsonNodesIterator;
    private JsonNode currentJsonNode;
    private final String PROPERTY_SEPARATOR = ".";
    private final String ARRAY_LEFT = "[";
    private final String ARRAY_RIGHT = "]";
    private final String ATTRIBUTE_LEFT = "(";
    private final String ATTRIBUTE_RIGHT = ")";
    private JsonNode jsonTree;
    private ObjectMapper mapper = JsonUtil.createObjectMapper();

    public JsonDataSource(InputStream stream) throws JRException {
        this(stream, null);
    }

    public JsonDataSource(InputStream jsonStream, String selectExpression) throws JRException {
        this(JsonUtil.parseJson(jsonStream), selectExpression);
    }

    protected JsonDataSource(JsonNode jsonTree, String selectExpression) throws JRException {
        this.jsonTree = jsonTree;
        this.selectExpression = selectExpression;
        this.moveFirst();
    }

    public JsonDataSource(File file) throws FileNotFoundException, JRException {
        this(file, null);
    }

    public JsonDataSource(File file, String selectExpression) throws FileNotFoundException, JRException {
        this(JsonUtil.parseJson(file), selectExpression);
    }

    public JsonDataSource(JasperReportsContext jasperReportsContext, String location, String selectExpression) throws JRException {
        this(JsonUtil.parseJson(jasperReportsContext, location), selectExpression);
    }

    public JsonDataSource(String location, String selectExpression) throws JRException {
        this(DefaultJasperReportsContext.getInstance(), location, selectExpression);
    }

    @Override
    public void moveFirst() throws JRException {
        if (this.jsonTree == null || this.jsonTree.isMissingNode()) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_NO_DATA, (Object[])null);
        }
        this.currentJsonNode = null;
        JsonNode result = this.getJsonData(this.jsonTree, this.selectExpression);
        if (result != null && result.isObject()) {
            final ArrayList<JsonNode> list = new ArrayList<JsonNode>();
            list.add(result);
            this.jsonNodesIterator = new Iterator<JsonNode>(){
                private int count = -1;

                @Override
                public void remove() {
                    list.remove(this.count);
                }

                @Override
                public JsonNode next() {
                    ++this.count;
                    return (JsonNode)list.get(this.count);
                }

                @Override
                public boolean hasNext() {
                    return this.count < list.size() - 1;
                }
            };
        } else if (result != null && result.isArray()) {
            this.jsonNodesIterator = result.elements();
        }
    }

    @Override
    public boolean next() {
        if (this.jsonNodesIterator == null || !this.jsonNodesIterator.hasNext()) {
            return false;
        }
        this.currentJsonNode = this.jsonNodesIterator.next();
        return true;
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        if (this.currentJsonNode == null) {
            return null;
        }
        String expression = jrField.getDescription();
        if (!(expression != null && expression.length() != 0 || (expression = jrField.getName()) != null && expression.length() != 0)) {
            return null;
        }
        Object value = null;
        Class<?> valueClass = jrField.getValueClass();
        JsonNode selectedObject = this.getJsonData(this.currentJsonNode, expression);
        if (Object.class != valueClass) {
            boolean hasValue;
            boolean bl = hasValue = selectedObject != null && !selectedObject.isMissingNode() && !selectedObject.isNull();
            if (hasValue) {
                try {
                    if (valueClass.equals(String.class)) {
                        if (selectedObject.isArray()) {
                            value = selectedObject.toString();
                        }
                        value = selectedObject.asText();
                    }
                    if (valueClass.equals(Boolean.class)) {
                        value = selectedObject.booleanValue();
                    }
                    if (Number.class.isAssignableFrom(valueClass)) {
                        value = this.convertStringValue(selectedObject.asText(), valueClass);
                    }
                    if (Date.class.isAssignableFrom(valueClass)) {
                        value = this.convertStringValue(selectedObject.asText(), valueClass);
                    }
                    throw new JRException("data.common.cannot.convert.field.type", new Object[]{jrField.getName(), valueClass.getName()});
                }
                catch (Exception e2) {
                    throw new JRException(EXCEPTION_MESSAGE_KEY_JSON_FIELD_VALUE_NOT_RETRIEVED, new Object[]{jrField.getName(), valueClass.getName()}, e2);
                }
            }
        } else {
            value = selectedObject;
        }
        return value;
    }

    protected JsonNode getJsonData(JsonNode rootNode, String jsonExpression) throws JRException {
        if (jsonExpression == null || jsonExpression.length() == 0) {
            return rootNode;
        }
        JsonNode tempNode = rootNode;
        StringTokenizer tokenizer = new StringTokenizer(jsonExpression, ".");
        while (tokenizer.hasMoreTokens()) {
            String currentToken = tokenizer.nextToken();
            int currentTokenLength = currentToken.length();
            int indexOfLeftSquareBracket = currentToken.indexOf("[");
            if (indexOfLeftSquareBracket != -1) {
                if (currentToken.lastIndexOf("]") != currentTokenLength - 1) {
                    throw new JRException(EXCEPTION_MESSAGE_KEY_INVALID_EXPRESSION, new Object[]{jsonExpression, currentToken});
                }
                if (indexOfLeftSquareBracket > 0) {
                    String property = currentToken.substring(0, indexOfLeftSquareBracket);
                    tempNode = this.goDownPathWithAttribute(tempNode, property);
                    String arrayOperators = currentToken.substring(indexOfLeftSquareBracket);
                    StringTokenizer arrayOpsTokenizer = new StringTokenizer(arrayOperators, "]");
                    while (arrayOpsTokenizer.hasMoreTokens()) {
                        if (tempNode.isMissingNode() || !tempNode.isArray()) continue;
                        String currentArrayOperator = arrayOpsTokenizer.nextToken();
                        tempNode = tempNode.path(Integer.parseInt(currentArrayOperator.substring(1)));
                    }
                    continue;
                }
                String arrayOperators = currentToken.substring(indexOfLeftSquareBracket);
                StringTokenizer arrayOpsTokenizer = new StringTokenizer(arrayOperators, "]");
                while (arrayOpsTokenizer.hasMoreTokens()) {
                    if (tempNode.isMissingNode() || !tempNode.isArray()) continue;
                    String currentArrayOperator = arrayOpsTokenizer.nextToken();
                    tempNode = tempNode.path(Integer.parseInt(currentArrayOperator.substring(1)));
                }
                continue;
            }
            tempNode = this.goDownPathWithAttribute(tempNode, currentToken);
        }
        return tempNode;
    }

    protected JsonNode goDownPathWithAttribute(JsonNode rootNode, String pathWithAttributeExpression) throws JRException {
        int indexOfLeftRoundBracket = pathWithAttributeExpression.indexOf("(");
        if (indexOfLeftRoundBracket != -1) {
            if (pathWithAttributeExpression.indexOf(")") != pathWithAttributeExpression.length() - 1) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_INVALID_ATTRIBUTE_SELECTION, new Object[]{pathWithAttributeExpression});
            }
            if (rootNode != null && !rootNode.isMissingNode()) {
                String path = pathWithAttributeExpression.substring(0, indexOfLeftRoundBracket);
                String attributeExpression = pathWithAttributeExpression.substring(indexOfLeftRoundBracket + 1, pathWithAttributeExpression.length() - 1);
                ArrayNode result = null;
                if (rootNode.isObject()) {
                    if (!rootNode.path(path).isMissingNode()) {
                        if (rootNode.path(path).isObject()) {
                            if (this.isValidExpression(rootNode.path(path), attributeExpression)) {
                                result = rootNode.path(path);
                            }
                        } else if (rootNode.path(path).isArray()) {
                            result = this.mapper.createArrayNode();
                            for (JsonNode node : rootNode.path(path)) {
                                if (!this.isValidExpression(node, attributeExpression)) continue;
                                result.add(node);
                            }
                        }
                    }
                } else if (rootNode.isArray()) {
                    result = this.mapper.createArrayNode();
                    for (JsonNode node : rootNode) {
                        JsonNode deeperNode = node.path(path);
                        if (deeperNode.isMissingNode()) continue;
                        if (deeperNode.isArray()) {
                            for (JsonNode arrayNode : deeperNode) {
                                if (!this.isValidExpression(arrayNode, attributeExpression)) continue;
                                result.add(arrayNode);
                            }
                            continue;
                        }
                        if (!this.isValidExpression(deeperNode, attributeExpression)) continue;
                        result.add(deeperNode);
                    }
                }
                return result;
            }
        } else {
            return this.goDownPath(rootNode, pathWithAttributeExpression);
        }
        return rootNode;
    }

    protected JsonNode goDownPath(JsonNode rootNode, String simplePath) {
        if (rootNode != null && !rootNode.isMissingNode()) {
            JsonNode result = null;
            if (rootNode.isObject()) {
                result = rootNode.path(simplePath);
            } else if (rootNode.isArray()) {
                result = this.mapper.createArrayNode();
                for (JsonNode node : rootNode) {
                    JsonNode deeperNode = node.path(simplePath);
                    if (deeperNode.isMissingNode()) continue;
                    if (deeperNode.isArray()) {
                        for (JsonNode arrayNode : deeperNode) {
                            ((ArrayNode)result).add(arrayNode);
                        }
                        continue;
                    }
                    ((ArrayNode)result).add(deeperNode);
                }
            }
            return result;
        }
        return rootNode;
    }

    protected boolean isValidExpression(JsonNode operand, String attributeExpression) throws JRException {
        return JsonUtil.evaluateJsonExpression(operand, attributeExpression);
    }

    @Override
    public JsonDataSource subDataSource() throws JRException {
        return this.subDataSource(null);
    }

    @Override
    public JsonDataSource subDataSource(String selectExpression) throws JRException {
        if (this.currentJsonNode == null) {
            throw new JRException("data.common.xml.node.not.available", (Object[])null);
        }
        try {
            byte[] jsonNodeBytes = this.currentJsonNode.toString().getBytes("UTF-8");
            JsonDataSource subDataSource = new JsonDataSource(new ByteArrayInputStream(jsonNodeBytes), selectExpression);
            subDataSource.setTextAttributes(this);
            return subDataSource;
        }
        catch (UnsupportedEncodingException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    @Deprecated
    public void close() {
    }
}

