/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.ReturnValue;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRIncrementer;
import net.sf.jasperreports.engine.fill.JRIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRIncrementerFactoryCache;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class JRFillSubreportReturnValue
implements JRSubreportReturnValue {
    public static final String EXCEPTION_MESSAGE_KEY_INCREMENTER_CLASS_NOT_FOUND = "fill.subreport.return.value.incrementer.class.not.found";
    protected final String fromVariable;
    protected final String toVariable;
    protected final String incrementerFactoryClassName;
    protected final CalculationEnum calculation;
    private boolean derived;
    protected JRIncrementer incrementer;
    protected final BaseReportFiller filler;

    protected JRFillSubreportReturnValue(JRSubreportReturnValue returnValue, JRFillObjectFactory factory, BaseReportFiller filler) {
        factory.put(returnValue, this);
        this.fromVariable = returnValue.getSubreportVariable();
        this.toVariable = returnValue.getToVariable();
        this.incrementerFactoryClassName = returnValue.getIncrementerFactoryClassName();
        this.calculation = returnValue.getCalculationValue();
        this.filler = filler;
    }

    public JRFillSubreportReturnValue(ReturnValue returnValue, JRFillObjectFactory factory, JRBaseFiller filler) {
        factory.put(returnValue, this);
        this.fromVariable = returnValue.getFromVariable();
        this.toVariable = returnValue.getToVariable();
        this.incrementerFactoryClassName = returnValue.getIncrementerFactoryClassName();
        this.calculation = returnValue.getCalculation();
        this.filler = filler;
    }

    protected JRFillSubreportReturnValue(JRFillSubreportReturnValue fillReturnValue, JRFillCloneFactory factory) {
        this.fromVariable = fillReturnValue.fromVariable;
        this.toVariable = fillReturnValue.toVariable;
        this.incrementerFactoryClassName = fillReturnValue.incrementerFactoryClassName;
        this.calculation = fillReturnValue.calculation;
        this.derived = fillReturnValue.derived;
        this.incrementer = fillReturnValue.incrementer;
        this.filler = fillReturnValue.filler;
    }

    @Override
    public String getSubreportVariable() {
        return this.fromVariable;
    }

    @Override
    public String getToVariable() {
        return this.toVariable;
    }

    @Override
    public String getIncrementerFactoryClassName() {
        return this.incrementerFactoryClassName;
    }

    @Override
    public CalculationEnum getCalculationValue() {
        return this.calculation;
    }

    public JRIncrementer getIncrementer() {
        if (this.incrementer == null) {
            JRIncrementerFactory incrementerFactory;
            String incrementerFactoryClassName = this.getIncrementerFactoryClassName();
            if (incrementerFactoryClassName == null) {
                JRFillVariable toVariable = this.filler.getVariable(this.getToVariable());
                incrementerFactory = JRDefaultIncrementerFactory.getFactory(toVariable.getValueClass());
            } else {
                try {
                    Class<?> incrementerFactoryClass = JRClassLoader.loadClassForName(incrementerFactoryClassName);
                    incrementerFactory = JRIncrementerFactoryCache.getInstance(incrementerFactoryClass);
                }
                catch (ClassNotFoundException e2) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INCREMENTER_CLASS_NOT_FOUND, new Object[]{incrementerFactoryClassName}, e2);
                }
            }
            this.incrementer = incrementerFactory.getIncrementer(this.getCalculationValue().getValue());
        }
        return this.incrementer;
    }

    public boolean isDerived() {
        return this.derived;
    }

    public void setDerived(boolean derived) {
        this.derived = derived;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }
}

