/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.fill.JRHorizontalFiller;
import net.sf.jasperreports.engine.fill.JRVerticalFiller;
import net.sf.jasperreports.engine.fill.PartReportFiller;
import net.sf.jasperreports.engine.fill.ReportFiller;
import net.sf.jasperreports.engine.type.SectionTypeEnum;

public final class JRFiller {
    public static final String EXCEPTION_MESSAGE_KEY_THREAD_INTERRUPTED = "fill.common.filler.thread.interrupted";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_REPORT_SECTION_TYPE = "fill.common.filler.unknown.report.section.type";
    public static final String PROPERTY_DEFAULT_LOCALE = "net.sf.jasperreports.default.locale";
    public static final String PROPERTY_DEFAULT_TIMEZONE = "net.sf.jasperreports.default.timezone";

    public static JasperPrint fill(JasperReportsContext jasperReportsContext, JasperReport jasperReport, Map<String, Object> parameters, Connection conn) throws JRException {
        ReportFiller filler = JRFiller.createReportFiller(jasperReportsContext, jasperReport);
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = filler.fill(parameters, conn);
        }
        catch (JRFillInterruptedException e2) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_THREAD_INTERRUPTED, null, e2);
        }
        return jasperPrint;
    }

    public static JasperPrint fill(JasperReportsContext jasperReportsContext, JasperReport jasperReport, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        ReportFiller filler = JRFiller.createReportFiller(jasperReportsContext, jasperReport);
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = filler.fill(parameters, dataSource);
        }
        catch (JRFillInterruptedException e2) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_THREAD_INTERRUPTED, null, e2);
        }
        return jasperPrint;
    }

    public static JasperPrint fill(JasperReportsContext jasperReportsContext, JasperReport jasperReport, Map<String, Object> parameters) throws JRException {
        ReportFiller filler = JRFiller.createReportFiller(jasperReportsContext, jasperReport);
        try {
            JasperPrint jasperPrint = filler.fill(parameters);
            return jasperPrint;
        }
        catch (JRFillInterruptedException e2) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_THREAD_INTERRUPTED, null, e2);
        }
    }

    public static JRBaseFiller createFiller(JasperReportsContext jasperReportsContext, JasperReport jasperReport) throws JRException {
        return JRFiller.createBandReportFiller(jasperReportsContext, jasperReport);
    }

    protected static JRBaseFiller createBandReportFiller(JasperReportsContext jasperReportsContext, JasperReport jasperReport) throws JRException {
        JRBaseFiller filler = null;
        switch (jasperReport.getPrintOrderValue()) {
            case HORIZONTAL: {
                filler = new JRHorizontalFiller(jasperReportsContext, jasperReport);
                break;
            }
            case VERTICAL: {
                filler = new JRVerticalFiller(jasperReportsContext, jasperReport);
            }
        }
        return filler;
    }

    public static ReportFiller createReportFiller(JasperReportsContext jasperReportsContext, JasperReport jasperReport) throws JRException {
        BaseReportFiller filler;
        SectionTypeEnum sectionType = jasperReport.getSectionType();
        sectionType = sectionType == null ? SectionTypeEnum.BAND : sectionType;
        switch (sectionType) {
            case BAND: {
                filler = JRFiller.createBandReportFiller(jasperReportsContext, jasperReport);
                break;
            }
            case PART: {
                filler = new PartReportFiller(jasperReportsContext, jasperReport);
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_REPORT_SECTION_TYPE, new Object[]{jasperReport.getSectionType()});
            }
        }
        return filler;
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters, Connection conn) throws JRException {
        return JRFiller.fill((JasperReportsContext)DefaultJasperReportsContext.getInstance(), jasperReport, parameters, conn);
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
        return JRFiller.fill((JasperReportsContext)DefaultJasperReportsContext.getInstance(), jasperReport, parameters, dataSource);
    }

    public static JasperPrint fillReport(JasperReport jasperReport, Map<String, Object> parameters) throws JRException {
        return JRFiller.fill(DefaultJasperReportsContext.getInstance(), jasperReport, parameters);
    }

    public static JRBaseFiller createFiller(JasperReport jasperReport) throws JRException {
        return JRFiller.createFiller(DefaultJasperReportsContext.getInstance(), jasperReport);
    }

    private JRFiller() {
    }
}

