/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRJpaDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRJpaQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRJpaQueryExecuter.class);
    protected static final String CANONICAL_LANGUAGE = "EJBQL";
    private final Integer reportMaxCount;
    private EntityManager em = (EntityManager)this.getParameterValue("JPA_ENTITY_MANAGER");
    private Query query;

    public JRJpaQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) {
        super(jasperReportsContext, dataset, parameters);
        this.reportMaxCount = (Integer)this.getParameterValue("REPORT_MAX_COUNT");
        if (this.em == null) {
            log.warn("The supplied javax.persistence.EntityManager object is null.");
        }
        this.parseQuery();
    }

    public JRJpaQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) {
        this(DefaultJasperReportsContext.getInstance(), dataset, parameters);
    }

    @Override
    protected String getCanonicalQueryLanguage() {
        return CANONICAL_LANGUAGE;
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        JRDataSource datasource = null;
        String queryString = this.getQueryString();
        if (this.em != null && queryString != null && queryString.trim().length() > 0) {
            this.createQuery(queryString);
            datasource = this.createResultDatasource();
        }
        return datasource;
    }

    protected synchronized void createQuery(String queryString) {
        Map queryHintsMap;
        if (log.isDebugEnabled()) {
            log.debug("EJBQL query: " + queryString);
        }
        this.query = this.em.createQuery(queryString);
        List<String> parameterNames = this.getCollectedParameterNames();
        if (!parameterNames.isEmpty()) {
            HashSet<String> namesSet = new HashSet<String>();
            for (String parameterName : parameterNames) {
                if (!namesSet.add(parameterName)) continue;
                JRValueParameter parameter = this.getValueParameter(parameterName);
                String ejbParamName = this.getEjbqlParameterName(parameterName);
                Object paramValue = parameter.getValue();
                if (log.isDebugEnabled()) {
                    log.debug("Parameter " + ejbParamName + ": " + paramValue);
                }
                this.query.setParameter(ejbParamName, paramValue);
            }
        }
        if ((queryHintsMap = (Map)this.getParameterValue("JPA_QUERY_HINTS_MAP")) != null) {
            for (Map.Entry pairs : queryHintsMap.entrySet()) {
                if (log.isDebugEnabled()) {
                    log.debug("EJBQL query hint [" + (String)pairs.getKey() + "] set.");
                }
                this.query.setHint((String)pairs.getKey(), pairs.getValue());
            }
        }
        List<JRPropertiesUtil.PropertySuffix> properties = JRPropertiesUtil.getProperties(this.dataset, "net.sf.jasperreports.ejbql.query.hint.");
        for (JRPropertiesUtil.PropertySuffix property : properties) {
            String queryHint = property.getSuffix();
            if (queryHint.length() <= 0) continue;
            String value = property.getValue();
            if (log.isDebugEnabled()) {
                log.debug("EJBQL query hint [" + queryHint + "] set to: " + value);
            }
            this.query.setHint(queryHint, (Object)value);
        }
    }

    protected JRDataSource createResultDatasource() {
        JRJpaDataSource resDatasource;
        try {
            int pageSize = this.getPropertiesUtil().getIntegerProperty(this.dataset, "net.sf.jasperreports.ejbql.query.page.size", 0);
            resDatasource = new JRJpaDataSource(this, pageSize);
        }
        catch (NumberFormatException e2) {
            throw new JRRuntimeException("query.numeric.type.required", new Object[]{"net.sf.jasperreports.ejbql.query.page.size"}, e2);
        }
        return resDatasource;
    }

    @Override
    public synchronized void close() {
        this.query = null;
    }

    @Override
    public synchronized boolean cancelQuery() throws JRException {
        return false;
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return ':' + this.getEjbqlParameterName(parameterName);
    }

    protected String getEjbqlParameterName(String parameterName) {
        return JRStringUtil.getJavaIdentifier(parameterName);
    }

    public List<?> getResultList() {
        if (this.reportMaxCount != null) {
            this.query.setMaxResults(this.reportMaxCount.intValue());
        }
        return this.query.getResultList();
    }

    public List<?> getResultList(int firstIndex, int resultCount) {
        if (this.reportMaxCount != null && firstIndex + resultCount > this.reportMaxCount) {
            resultCount = this.reportMaxCount - firstIndex;
        }
        this.query.setFirstResult(firstIndex);
        this.query.setMaxResults(resultCount);
        return this.query.getResultList();
    }
}

