/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.type.ColorEnum;

public final class JRColorUtil {
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_COLOR = "util.color.invalid.color";
    public static final int COLOR_MASK = Integer.parseInt("FFFFFF", 16);
    private static final String RGB = "rgb";
    public static final String RGB_PREFIX = "rgb(";
    public static final String RGBA_PREFIX = "rgba(";
    public static final String RGBA_SUFFIX = ")";

    public static String getColorHexa(Color color) {
        String hexa = Integer.toHexString(color.getRGB() & COLOR_MASK).toUpperCase();
        return ("000000" + hexa).substring(hexa.length());
    }

    public static String getCssColor(Color color) {
        if (color.getAlpha() == 255) {
            return "#" + JRColorUtil.getColorHexa(color);
        }
        return RGBA_PREFIX + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + (float)color.getAlpha() / 255.0f + RGBA_SUFFIX;
    }

    public static Color getColor(String strColor, Color defaultColor) {
        Color color = null;
        if (strColor != null && (strColor = strColor.trim()).length() > 0) {
            char firstChar = strColor.charAt(0);
            if (firstChar == '#') {
                color = new Color(Integer.parseInt(strColor.substring(1), 16));
            } else if ('0' <= firstChar && firstChar <= '9') {
                color = new Color(Integer.parseInt(strColor));
            } else if (strColor.toLowerCase().startsWith(RGB) && strColor.endsWith(RGBA_SUFFIX)) {
                strColor = strColor.toLowerCase();
                boolean hasAlpha = false;
                String prefix = null;
                int numArrayLength = 0;
                if (strColor.startsWith(RGBA_PREFIX)) {
                    hasAlpha = true;
                    prefix = RGBA_PREFIX;
                    numArrayLength = 4;
                } else if (strColor.startsWith(RGB_PREFIX)) {
                    hasAlpha = false;
                    prefix = RGB_PREFIX;
                    numArrayLength = 3;
                } else {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INVALID_COLOR, new Object[]{strColor});
                }
                String numStr = strColor.substring(prefix.length(), strColor.length() - RGBA_SUFFIX.length());
                String[] numArray = numStr.split(",");
                if (numArray == null || numArray.length != numArrayLength) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INVALID_COLOR, new Object[]{strColor});
                }
                for (int i2 = 0; i2 < numArray.length; ++i2) {
                    numArray[i2] = numArray[i2].trim();
                    if (numArray[i2].length() != 0) continue;
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INVALID_COLOR, new Object[]{strColor});
                }
                int red = Integer.parseInt(numArray[0]);
                int green = Integer.parseInt(numArray[1]);
                int blue = Integer.parseInt(numArray[2]);
                if (hasAlpha) {
                    float alpha = Float.parseFloat(numArray[3]);
                    color = new Color(red, green, blue, (int)(alpha * 255.0f));
                } else {
                    color = new Color(red, green, blue);
                }
            } else {
                ColorEnum colorEnum = ColorEnum.getByName(strColor);
                color = colorEnum == null ? defaultColor : colorEnum.getColor();
            }
        }
        return color;
    }

    public static int getOpaqueArgb(Color color, Color defaultColor) {
        Color result = color == null ? defaultColor : color;
        return result == null ? 0 : result.getRGB() & 0xFFFFFFFF;
    }

    private JRColorUtil() {
    }
}

