/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public final class JRStringUtil {
    protected static final String JAVA_IDENTIFIER_PREFIX = "j";

    public static String replaceCRwithLF(String text) {
        if (text != null) {
            int length = text.length();
            char[] chars = text.toCharArray();
            int r2 = 0;
            boolean dirty = false;
            for (int i2 = 0; i2 < length; ++i2) {
                char ch = chars[i2];
                if (ch == '\r') {
                    dirty = true;
                    if (i2 + 1 < length && chars[i2 + 1] == '\n') {
                        ++r2;
                        continue;
                    }
                    chars[i2 - r2] = 10;
                    continue;
                }
                chars[i2 - r2] = ch;
            }
            return dirty ? new String(chars, 0, length - r2) : text;
        }
        return null;
    }

    public static String xmlEncode(String text) {
        return JRStringUtil.xmlEncode(text, null);
    }

    public static String xmlEncode(String text, String invalidCharReplacement) {
        if (text == null || text.length() == 0) {
            return text;
        }
        int length = text.length();
        StringBuffer ret = new StringBuffer(length * 12 / 10);
        int last = 0;
        block7: for (int i2 = 0; i2 < length; ++i2) {
            char c2 = text.charAt(i2);
            if (Character.isISOControl(c2) && c2 != '\t' && c2 != '\r' && c2 != '\n') {
                last = JRStringUtil.appendText(text, ret, i2, last);
                if (invalidCharReplacement == null) {
                    ret.append(c2);
                    continue;
                }
                if (invalidCharReplacement.length() == 0) continue;
                ret.append(invalidCharReplacement);
                continue;
            }
            switch (c2) {
                case '&': {
                    last = JRStringUtil.appendText(text, ret, i2, last);
                    ret.append("&amp;");
                    continue block7;
                }
                case '>': {
                    last = JRStringUtil.appendText(text, ret, i2, last);
                    ret.append("&gt;");
                    continue block7;
                }
                case '<': {
                    last = JRStringUtil.appendText(text, ret, i2, last);
                    ret.append("&lt;");
                    continue block7;
                }
                case '\"': {
                    last = JRStringUtil.appendText(text, ret, i2, last);
                    ret.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    last = JRStringUtil.appendText(text, ret, i2, last);
                    ret.append("&apos;");
                    continue block7;
                }
            }
        }
        JRStringUtil.appendText(text, ret, length, last);
        return ret.toString();
    }

    public static String encodeXmlAttribute(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        int length = text.length();
        StringBuffer ret = new StringBuffer(length * 12 / 10);
        int last = 0;
        block10: for (int i2 = 0; i2 < length; ++i2) {
            char c2 = text.charAt(i2);
            switch (c2) {
                case '&': {
                    last = JRStringUtil.appendText(text, ret, i2, last);
                    ret.append("&amp;");
                    continue block10;
                }
                case '>': {
                    last = JRStringUtil.appendText(text, ret, i2, last);
                    ret.append("&gt;");
                    continue block10;
                }
                case '<': {
                    last = JRStringUtil.appendText(text, ret, i2, last);
                    ret.append("&lt;");
                    continue block10;
                }
                case '\"': {
                    last = JRStringUtil.appendText(text, ret, i2, last);
                    ret.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    last = JRStringUtil.appendText(text, ret, i2, last);
                    ret.append("&apos;");
                    continue block10;
                }
                case '\t': {
                    last = JRStringUtil.appendText(text, ret, i2, last);
                    ret.append("&#x9;");
                    continue block10;
                }
                case '\r': {
                    last = JRStringUtil.appendText(text, ret, i2, last);
                    ret.append("&#xD;");
                    continue block10;
                }
                case '\n': {
                    last = JRStringUtil.appendText(text, ret, i2, last);
                    ret.append("&#xA;");
                    continue block10;
                }
            }
        }
        if (last == 0) {
            return text;
        }
        JRStringUtil.appendText(text, ret, length, last);
        return ret.toString();
    }

    private static int appendText(String text, StringBuffer ret, int current, int old) {
        if (old < current) {
            ret.append(text.substring(old, current));
        }
        return current + 1;
    }

    public static String htmlEncode(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        int length = text.length();
        StringBuffer ret = new StringBuffer(length * 12 / 10);
        boolean isEncodeSpace = true;
        int last = 0;
        block8: for (int i2 = 0; i2 < length; ++i2) {
            char c2 = text.charAt(i2);
            switch (c2) {
                case ' ': {
                    if (isEncodeSpace) {
                        if (last < i2) {
                            ret.append(text.substring(last, i2));
                        }
                        last = i2 + 1;
                        ret.append("&nbsp;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    isEncodeSpace = true;
                    continue block8;
                }
                case '&': {
                    if (last < i2) {
                        ret.append(text.substring(last, i2));
                    }
                    last = i2 + 1;
                    ret.append("&amp;");
                    isEncodeSpace = false;
                    continue block8;
                }
                case '>': {
                    if (last < i2) {
                        ret.append(text.substring(last, i2));
                    }
                    last = i2 + 1;
                    ret.append("&gt;");
                    isEncodeSpace = false;
                    continue block8;
                }
                case '<': {
                    if (last < i2) {
                        ret.append(text.substring(last, i2));
                    }
                    last = i2 + 1;
                    ret.append("&lt;");
                    isEncodeSpace = false;
                    continue block8;
                }
                case '\"': {
                    if (last < i2) {
                        ret.append(text.substring(last, i2));
                    }
                    last = i2 + 1;
                    ret.append("&quot;");
                    isEncodeSpace = false;
                    continue block8;
                }
                case '\n': {
                    if (last < i2) {
                        ret.append(text.substring(last, i2));
                    }
                    last = i2 + 1;
                    ret.append("<br/>");
                    isEncodeSpace = false;
                    continue block8;
                }
                default: {
                    isEncodeSpace = false;
                }
            }
        }
        if (last < length) {
            ret.append(text.substring(last));
        }
        return ret.toString();
    }

    public static String getJavaIdentifier(String name) {
        if (JRStringUtil.isValidJavaIdentifier(name)) {
            return name;
        }
        StringBuffer buffer = new StringBuffer(name.length() + 5);
        char[] literalChars = new char[name.length()];
        name.getChars(0, literalChars.length, literalChars, 0);
        for (int i2 = 0; i2 < literalChars.length; ++i2) {
            if (i2 == 0 && !Character.isJavaIdentifierStart(literalChars[i2])) {
                buffer.append(JAVA_IDENTIFIER_PREFIX);
                buffer.append((int)literalChars[i2]);
                continue;
            }
            if (i2 != 0 && !Character.isJavaIdentifierPart(literalChars[i2])) {
                buffer.append((int)literalChars[i2]);
                continue;
            }
            buffer.append(literalChars[i2]);
        }
        return buffer.toString();
    }

    private static boolean isValidJavaIdentifier(String literal) {
        boolean result = true;
        char[] literalChars = new char[literal.length()];
        literal.getChars(0, literalChars.length, literalChars, 0);
        for (int i2 = 0; i2 < literalChars.length; ++i2) {
            if (i2 == 0 && !Character.isJavaIdentifierStart(literalChars[i2])) {
                result = false;
                break;
            }
            if (i2 == 0 || Character.isJavaIdentifierPart(literalChars[i2])) continue;
            result = false;
            break;
        }
        return result;
    }

    public static String escapeJavaStringLiteral(String text) {
        if (text == null) {
            return text;
        }
        StringBuffer sbuffer = new StringBuffer();
        StringTokenizer tkzer = new StringTokenizer(text, "\\\"\n\r\t", true);
        while (tkzer.hasMoreTokens()) {
            String token = tkzer.nextToken();
            if ("\\".equals(token)) {
                sbuffer.append("\\\\");
                continue;
            }
            if ("\"".equals(token)) {
                sbuffer.append("\\\"");
                continue;
            }
            if ("\n".equals(token)) {
                sbuffer.append("\\n");
                continue;
            }
            if ("\r".equals(token)) {
                sbuffer.append("\\r");
                continue;
            }
            if ("\t".equals(token)) {
                sbuffer.append("\\t");
                continue;
            }
            sbuffer.append(token);
        }
        return sbuffer.toString();
    }

    public static String escapeJavaScript(String input) {
        if (input == null) {
            return input;
        }
        StringBuilder filtered = new StringBuilder(input.length());
        char prevChar = '\u0000';
        for (int i2 = 0; i2 < input.length(); ++i2) {
            char c2 = input.charAt(i2);
            if (c2 == '\"') {
                filtered.append("\\\"");
            } else if (c2 == '\'') {
                filtered.append("\\'");
            } else if (c2 == '\\') {
                filtered.append("\\\\");
            } else if (c2 == '/') {
                filtered.append("\\/");
            } else if (c2 == '\t') {
                filtered.append("\\t");
            } else if (c2 == '\n') {
                if (prevChar != '\r') {
                    filtered.append("\\n");
                }
            } else if (c2 == '\r') {
                filtered.append("\\n");
            } else if (c2 == '\f') {
                filtered.append("\\f");
            } else {
                filtered.append(c2);
            }
            prevChar = c2;
        }
        return filtered.toString();
    }

    public static String escapeString4JavaScript(String input) {
        if (input == null) {
            return input;
        }
        StringBuilder filtered = new StringBuilder(input.length());
        char prevChar = '\u0000';
        for (int i2 = 0; i2 < input.length(); ++i2) {
            char c2 = input.charAt(i2);
            if (c2 == '\"') {
                filtered.append("\\\"");
            } else if (c2 == '\\') {
                filtered.append("\\\\");
            } else if (c2 == '/') {
                filtered.append("\\/");
            } else if (c2 == '\t') {
                filtered.append("\\t");
            } else if (c2 == '\n') {
                if (prevChar != '\r') {
                    filtered.append("\\n");
                }
            } else if (c2 == '\r') {
                filtered.append("\\n");
            } else if (c2 == '\f') {
                filtered.append("\\f");
            } else {
                filtered.append(c2);
            }
            prevChar = c2;
        }
        return filtered.toString();
    }

    public static List<Integer> getTabIndexes(String text) {
        int index;
        ArrayList<Integer> tabIndexes = null;
        if (text != null && (index = text.indexOf(9)) >= 0) {
            tabIndexes = new ArrayList<Integer>();
            do {
                tabIndexes.add(index);
            } while ((index = text.indexOf(9, index + 1)) >= 0);
        }
        return tabIndexes;
    }

    public static List<String> split(String[] srcArray, String delimiterRegExp) {
        ArrayList<String> tokens = null;
        if (srcArray != null) {
            tokens = new ArrayList<String>();
            for (int i2 = 0; i2 < srcArray.length; ++i2) {
                if (srcArray[i2] == null) {
                    tokens.add(null);
                    continue;
                }
                String[] currentTokensArray = srcArray[i2].split(delimiterRegExp);
                for (int j2 = 0; j2 < currentTokensArray.length; ++j2) {
                    tokens.add(currentTokensArray[j2].trim());
                }
            }
        }
        return tokens;
    }

    public static String getString(Object value) {
        return value == null ? null : value.toString();
    }

    public static String escapeJSONString(String text) {
        if (text == null) {
            return null;
        }
        char[] escapedChars = JsonStringEncoder.getInstance().quoteAsString(text);
        if (text.contentEquals(CharBuffer.wrap(escapedChars))) {
            return text;
        }
        return String.valueOf(escapedChars);
    }

    private JRStringUtil() {
    }
}

