/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.Comparator;

public class VersionComparator
implements Comparator<String> {
    public static final String LOWEST_VERSION = "0";

    @Override
    public int compare(String currentVersion, String oldVersion) {
        if (oldVersion == null) {
            throw new IllegalArgumentException("Reference version can't be null.");
        }
        if (currentVersion == null || currentVersion.startsWith(oldVersion)) {
            return 1;
        }
        String[] oldVersionChunks = oldVersion.split("\\.");
        String[] currentVersionChunks = currentVersion.split("\\.");
        int count = Math.min(oldVersionChunks.length, currentVersionChunks.length);
        int old = 0;
        int current = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            try {
                old = Integer.valueOf(oldVersionChunks[i2]);
                current = Integer.valueOf(currentVersionChunks[i2]);
                if (current == old) continue;
                return current - old;
            }
            catch (NumberFormatException e2) {
                if (currentVersionChunks[i2].compareTo(oldVersionChunks[i2]) == 0) continue;
                return currentVersionChunks[i2].compareTo(oldVersionChunks[i2]);
            }
        }
        return currentVersionChunks.length - oldVersionChunks.length;
    }
}

