/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.export.WriterExporterOutput;

public class SimpleWriterExporterOutput
implements WriterExporterOutput {
    private final String encoding;
    private Writer writer;
    private StringBuffer sbuffer;
    private boolean toClose;

    public SimpleWriterExporterOutput(StringBuffer sbuffer) {
        this.encoding = "UTF-8";
        this.sbuffer = sbuffer;
        if (sbuffer != null) {
            this.writer = new StringWriter();
            this.toClose = true;
        }
    }

    public SimpleWriterExporterOutput(Writer writer) {
        this.encoding = "UTF-8";
        this.writer = writer;
        this.toClose = false;
    }

    public SimpleWriterExporterOutput(OutputStream outputStream) {
        this(outputStream, "UTF-8");
    }

    public SimpleWriterExporterOutput(OutputStream outputStream, String encoding) {
        this.encoding = encoding;
        if (outputStream != null) {
            try {
                this.writer = new OutputStreamWriter(outputStream, encoding);
            }
            catch (IOException e2) {
                throw new JRRuntimeException(e2);
            }
        }
        this.toClose = false;
    }

    public SimpleWriterExporterOutput(File file) {
        this(file, "UTF-8");
    }

    public SimpleWriterExporterOutput(File file, String encoding) {
        this.encoding = encoding;
        if (file != null) {
            try {
                FileOutputStream os = new FileOutputStream(file);
                this.writer = new OutputStreamWriter((OutputStream)os, encoding);
            }
            catch (IOException e2) {
                throw new JRRuntimeException(e2);
            }
        }
        this.toClose = true;
    }

    public SimpleWriterExporterOutput(String fileName) {
        this(fileName == null ? null : new File(fileName));
    }

    public SimpleWriterExporterOutput(String fileName, String encoding) {
        this(fileName == null ? null : new File(fileName), encoding);
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void close() {
        if (this.toClose && this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.sbuffer != null) {
                this.sbuffer.append(this.writer.toString());
            }
        }
    }
}

