/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap;

import antlr.ANTLRException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.olap.mapping.Axis;
import net.sf.jasperreports.olap.mapping.AxisPosition;
import net.sf.jasperreports.olap.mapping.DataMapping;
import net.sf.jasperreports.olap.mapping.Mapping;
import net.sf.jasperreports.olap.mapping.MappingLexer;
import net.sf.jasperreports.olap.mapping.MappingMetadata;
import net.sf.jasperreports.olap.mapping.MappingParser;
import net.sf.jasperreports.olap.mapping.Member;
import net.sf.jasperreports.olap.mapping.MemberDepth;
import net.sf.jasperreports.olap.mapping.MemberMapping;
import net.sf.jasperreports.olap.mapping.MemberProperty;
import net.sf.jasperreports.olap.mapping.Tuple;
import net.sf.jasperreports.olap.mapping.TuplePosition;
import net.sf.jasperreports.olap.result.JROlapCell;
import net.sf.jasperreports.olap.result.JROlapHierarchy;
import net.sf.jasperreports.olap.result.JROlapHierarchyLevel;
import net.sf.jasperreports.olap.result.JROlapMember;
import net.sf.jasperreports.olap.result.JROlapMemberTuple;
import net.sf.jasperreports.olap.result.JROlapResult;
import net.sf.jasperreports.olap.result.JROlapResultAxis;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JROlapDataSource
implements JRDataSource,
MappingMetadata {
    private static final Log log = LogFactory.getLog(JROlapDataSource.class);
    public static final String EXCEPTION_MESSAGE_KEY_OLAP_AXIS_NOT_FOUND_IN_RESULT = "data.olap.axis.not.found.in.result";
    public static final String EXCEPTION_MESSAGE_KEY_OLAP_CANNOT_CONVERT_FIELD_TYPE = "data.olap.cannot.convert.field.type";
    public static final String EXCEPTION_MESSAGE_KEY_OLAP_CANNOT_CONVERT_STRING_VALUE_TYPE = "data.olap.cannot.convert.string.value.type";
    public static final String EXCEPTION_MESSAGE_KEY_OLAP_DIMENSION_NOT_FOUND = "data.olap.dimension.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_OLAP_FIELD_VALUE_NOT_RETRIEVED = "data.olap.field.value.not.retrieved";
    public static final String EXCEPTION_MESSAGE_KEY_OLAP_INTERNAL_ERROR = "data.olap.internal.error";
    public static final String EXCEPTION_MESSAGE_KEY_OLAP_INVALID_FIELD_MAPPING = "data.olap.invalid.field.mapping";
    public static final String EXCEPTION_MESSAGE_KEY_OLAP_LEVEL_NOT_FOUND = "data.olap.level.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_OLAP_TUPLE_NOT_FOUND = "data.olap.tuple.not.found";
    protected final JROlapResult olapResult;
    protected JROlapResultAxis[] axes;
    protected final JROlapHierarchy[][] queryHierarchies;
    protected final int hierarchiesCount;
    protected Map<Object, FieldMatcher> fieldMatchers;
    protected int[][] fieldsMaxDepths;
    protected boolean[] iteratePositions;
    protected boolean iterate;
    protected boolean dataField;
    protected Map<Object, Object> fieldValues;
    protected int[] axisPositions;
    protected boolean first;
    protected int[][] maxDepths;
    private DateFormat dateFormat = new SimpleDateFormat();
    private boolean noTuples;

    public JROlapDataSource(JRDataset dataset, JROlapResult result) {
        this.olapResult = result;
        this.axes = result.getAxes();
        this.queryHierarchies = new JROlapHierarchy[this.axes.length][];
        this.fieldsMaxDepths = new int[this.axes.length][];
        this.maxDepths = new int[this.axes.length][];
        int hCount = 0;
        this.noTuples = false;
        for (int i2 = 0; i2 < this.axes.length; ++i2) {
            this.noTuples = this.noTuples || this.axes[i2].getTupleCount() == 0;
            this.queryHierarchies[i2] = this.axes[i2].getHierarchiesOnAxis();
            hCount += this.queryHierarchies[i2].length;
            this.fieldsMaxDepths[i2] = new int[this.queryHierarchies[i2].length];
            this.maxDepths[i2] = new int[this.queryHierarchies[i2].length];
        }
        this.hierarchiesCount = hCount;
        this.axisPositions = new int[this.axes.length];
        if (!this.noTuples) {
            this.init(dataset);
        }
    }

    @Override
    public boolean next() throws JRException {
        boolean next;
        boolean matchMaxLevel;
        if (this.noTuples) {
            return false;
        }
        block0: do {
            if (this.iterate) {
                next = this.nextPositions();
            } else {
                next = this.first;
                this.first = false;
            }
            if (!next) break;
            this.resetMaxDepths();
            for (Map.Entry<Object, FieldMatcher> entry : this.fieldMatchers.entrySet()) {
                Object fieldName = entry.getKey();
                FieldMatcher matcher = entry.getValue();
                if (!matcher.matches()) continue;
                Object value = matcher.value();
                this.fieldValues.put(fieldName, value);
            }
            matchMaxLevel = true;
            for (int i2 = 0; i2 < this.axes.length; ++i2) {
                if (!this.iteratePositions[i2]) continue;
                for (int j2 = 0; j2 < this.fieldsMaxDepths[i2].length; ++j2) {
                    if (this.maxDepths[i2][j2] >= this.fieldsMaxDepths[i2][j2]) continue;
                    matchMaxLevel = false;
                    continue block0;
                }
            }
        } while (!matchMaxLevel);
        return next;
    }

    private void resetMaxDepths() {
        for (int i2 = 0; i2 < this.axes.length; ++i2) {
            if (!this.iteratePositions[i2]) continue;
            for (int j2 = 0; j2 < this.maxDepths[i2].length; ++j2) {
                this.maxDepths[i2][j2] = 0;
            }
        }
    }

    protected boolean nextPositions() {
        int i2;
        for (i2 = 0; i2 < this.axes.length; ++i2) {
            if (!this.iteratePositions[i2]) continue;
            int n2 = i2;
            this.axisPositions[n2] = this.axisPositions[n2] + 1;
            if (this.axisPositions[i2] < this.axes[i2].getTupleCount()) break;
            this.axisPositions[i2] = 0;
        }
        boolean next = i2 < this.axes.length;
        return next;
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        Class<?> valueClass = jrField.getValueClass();
        Object value = this.fieldValues.get(jrField.getName());
        try {
            if (valueClass.equals(mondrian.olap.Member.class)) {
                if (!(value instanceof mondrian.olap.Member)) {
                    throw new JRException(EXCEPTION_MESSAGE_KEY_OLAP_CANNOT_CONVERT_FIELD_TYPE, new Object[]{jrField.getName(), value.getClass(), valueClass.getName()});
                }
                return value;
            }
            String fieldValue = (String)value;
            if (fieldValue == null) {
                return null;
            }
            if (Number.class.isAssignableFrom(valueClass)) {
                fieldValue = fieldValue.trim();
            }
            if (fieldValue.length() == 0) {
                fieldValue = "0";
            }
            if (valueClass.equals(String.class)) {
                return fieldValue;
            }
            if (valueClass.equals(Boolean.class)) {
                return fieldValue.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
            }
            if (valueClass.equals(Byte.class)) {
                return new Byte(fieldValue);
            }
            if (valueClass.equals(Integer.class)) {
                return Integer.valueOf(fieldValue);
            }
            if (valueClass.equals(Long.class)) {
                return new Long(fieldValue);
            }
            if (valueClass.equals(Short.class)) {
                return new Short(fieldValue);
            }
            if (valueClass.equals(Double.class)) {
                return new Double(fieldValue);
            }
            if (valueClass.equals(Float.class)) {
                return new Float(fieldValue);
            }
            if (valueClass.equals(BigDecimal.class)) {
                return new BigDecimal(fieldValue);
            }
            if (valueClass.equals(Date.class)) {
                return this.dateFormat.parse(fieldValue);
            }
            if (valueClass.equals(Timestamp.class)) {
                return new Timestamp(this.dateFormat.parse(fieldValue).getTime());
            }
            if (valueClass.equals(Time.class)) {
                return new Time(this.dateFormat.parse(fieldValue).getTime());
            }
            if (valueClass.equals(Number.class)) {
                return new Double(fieldValue);
            }
            throw new JRException(EXCEPTION_MESSAGE_KEY_OLAP_CANNOT_CONVERT_STRING_VALUE_TYPE, new Object[]{jrField.getName(), fieldValue, this.fieldValues.get(jrField.getName()).getClass(), valueClass.getName()});
        }
        catch (Exception e2) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_OLAP_FIELD_VALUE_NOT_RETRIEVED, new Object[]{jrField.getName(), valueClass.getName()}, e2);
        }
    }

    private void init(JRDataset dataset) {
        this.iteratePositions = new boolean[this.axes.length];
        this.fieldMatchers = new HashMap<Object, FieldMatcher>();
        this.dataField = false;
        JRField[] fields = dataset.getFields();
        if (fields != null) {
            for (int i2 = 0; i2 < fields.length; ++i2) {
                Mapping mapping;
                JRField field = fields[i2];
                String fieldMapping = this.getFieldMapping(field);
                if (log.isDebugEnabled()) {
                    log.debug("Mapping field: " + field.getName() + " - description: " + fieldMapping);
                }
                MappingLexer lexer = new MappingLexer(new StringReader(fieldMapping));
                MappingParser parser = new MappingParser(lexer);
                parser.setMappingMetadata(this);
                try {
                    mapping = parser.mapping();
                }
                catch (ANTLRException e2) {
                    log.error("Error parsing field mapping", e2);
                    throw new JRRuntimeException(e2);
                }
                if (mapping == null) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_OLAP_INVALID_FIELD_MAPPING, new Object[]{fieldMapping});
                }
                this.processMappingMembers(mapping);
                FieldMatcher fieldMatcher = this.createFieldMatcher(field, mapping);
                this.fieldMatchers.put(field.getName(), fieldMatcher);
            }
        }
        if (!this.dataField) {
            Arrays.fill(this.iteratePositions, true);
        }
        this.initIterate();
    }

    private void processMappingMembers(Mapping mapping) {
        Iterator it = mapping.memberMappings();
        while (it.hasNext()) {
            Member member = (Member)it.next();
            this.processMemberInfo(member);
        }
    }

    private FieldMatcher createFieldMatcher(JRField field, Mapping mapping) {
        FieldMatcher fieldMatcher;
        if (mapping instanceof MemberMapping) {
            fieldMatcher = new MemberFieldMatcher((MemberMapping)mapping);
        } else if (mapping instanceof DataMapping) {
            this.dataField = true;
            fieldMatcher = new DataFieldMatcher(field, (DataMapping)mapping);
        } else {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_OLAP_INTERNAL_ERROR, (Object[])null);
        }
        return fieldMatcher;
    }

    protected String getFieldMapping(JRField field) {
        return field.getDescription();
    }

    private void initIterate() {
        int firstPos;
        for (firstPos = 0; firstPos < this.axes.length && !this.iteratePositions[firstPos]; ++firstPos) {
        }
        if (firstPos < this.axes.length) {
            this.iterate = true;
            this.axisPositions[firstPos] = -1;
        } else {
            this.iterate = false;
            this.first = true;
        }
        this.fieldValues = new HashMap<Object, Object>();
    }

    protected void processMemberInfo(Member member) {
        int idx;
        int axis;
        int depth;
        MemberDepth memberDepth = member.getDepth();
        if (memberDepth != null && (depth = memberDepth.getDepth()) > this.fieldsMaxDepths[axis = member.getAxis().getIdx()][idx = member.getPosition().getIdx()]) {
            this.fieldsMaxDepths[axis][idx] = depth;
        }
    }

    @Override
    public int getDimensionIndex(Axis axis, String dimension) {
        JROlapHierarchy[] hierarchies = this.axes[axis.getIdx()].getHierarchiesOnAxis();
        int dimensionIndex = -1;
        for (int i2 = 0; dimensionIndex == -1 && i2 < hierarchies.length; ++i2) {
            JROlapHierarchy hierarchy = hierarchies[i2];
            if (!this.matchesDimensionName(hierarchy, dimension)) continue;
            dimensionIndex = i2;
        }
        if (dimensionIndex == -1) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_OLAP_DIMENSION_NOT_FOUND, new Object[]{dimension, axis.getIdx()});
        }
        return dimensionIndex;
    }

    protected boolean matchesDimensionName(JROlapHierarchy hierarchy, String dimensionName) {
        if (dimensionName.equals(hierarchy.getDimensionName()) || dimensionName.equals(hierarchy.getHierarchyUniqueName())) {
            return true;
        }
        String hierName = "[" + dimensionName + "]";
        return hierName.equals(hierarchy.getHierarchyUniqueName());
    }

    @Override
    public int getLevelDepth(TuplePosition pos, String levelName) {
        JROlapHierarchy hierarchy = this.axes[pos.getAxis().getIdx()].getHierarchiesOnAxis()[pos.getIdx()];
        JROlapHierarchyLevel[] levels = hierarchy.getLevels();
        int levelIndex = -1;
        for (int i2 = 0; i2 < levels.length; ++i2) {
            JROlapHierarchyLevel level = levels[i2];
            if (level == null || !level.getName().equals(levelName)) continue;
            levelIndex = level.getDepth();
            break;
        }
        if (levelIndex == -1) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_OLAP_LEVEL_NOT_FOUND, new Object[]{levelName, pos.getIdx(), hierarchy.getDimensionName(), pos.getAxis().getIdx()});
        }
        return levelIndex;
    }

    protected void setMatchMemberDepth(Member memberInfo, JROlapMember member) {
        int pos;
        int memberDepth = member.getDepth();
        int axis = memberInfo.getAxis().getIdx();
        if (this.maxDepths[axis][pos = memberInfo.getPosition().getIdx()] < memberDepth) {
            this.maxDepths[axis][pos] = memberDepth;
        }
    }

    @Override
    public int getTuplePosition(int axisIndex, Tuple tuple) {
        if (axisIndex > this.axes.length) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_OLAP_AXIS_NOT_FOUND_IN_RESULT, new Object[]{axisIndex});
        }
        String[] memberUniqueNames = tuple.getMemberUniqueNames();
        JROlapResultAxis axis = this.axes[axisIndex];
        int tupleCount = axis.getTupleCount();
        int pos = -1;
        for (int i2 = 0; i2 < tupleCount; ++i2) {
            JROlapMemberTuple memberTuple = axis.getTuple(i2);
            JROlapMember[] resMembers = memberTuple.getMembers();
            if (resMembers.length != memberUniqueNames.length) continue;
            boolean eq = true;
            for (int j2 = 0; eq && j2 < resMembers.length; ++j2) {
                if (memberUniqueNames[j2].equals(resMembers[j2].getUniqueName())) continue;
                eq = false;
            }
            if (!eq) continue;
            pos = i2;
            break;
        }
        if (pos == -1) {
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            for (int i3 = 0; i3 < memberUniqueNames.length; ++i3) {
                if (i3 > 0) {
                    sb.append(',');
                }
                sb.append(memberUniqueNames[i3]);
            }
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_OLAP_TUPLE_NOT_FOUND, new Object[]{sb, axisIndex});
        }
        return pos;
    }

    protected class DataFieldMatcher
    extends FieldMatcher {
        public static final String EXCEPTION_MESSAGE_KEY_OLAP_CELL_CALCULATION_ERROR = "data.olap.cell.calculation.error";
        public static final String EXCEPTION_MESSAGE_KEY_OLAP_INCORRECT_DATA_MAPPING = "data.olap.incorrect.data.mapping";
        private final boolean formatted;
        private final int[] dataPositions;
        private final Member[] members;
        private int[] positions;

        public DataFieldMatcher(JRField field, DataMapping mapping) {
            this.formatted = mapping.isFormatted() && String.class.equals(field.getValueClass());
            List mappingPositions = mapping.getPositions();
            if (mappingPositions == null) {
                this.dataPositions = null;
                this.positions = JROlapDataSource.this.axisPositions;
            } else {
                if (mappingPositions.size() != JROlapDataSource.this.axes.length) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_OLAP_INCORRECT_DATA_MAPPING, (Object[])null);
                }
                this.dataPositions = new int[JROlapDataSource.this.axes.length];
                int c2 = 0;
                for (AxisPosition position : mappingPositions) {
                    int pos;
                    if (position.isSpecified()) {
                        pos = position.getPosition();
                    } else {
                        pos = -1;
                        JROlapDataSource.this.iteratePositions[c2] = true;
                    }
                    this.dataPositions[c2] = pos;
                    ++c2;
                }
            }
            List filter = mapping.getFilter();
            if (filter == null || filter.isEmpty()) {
                this.members = null;
            } else {
                this.members = new Member[filter.size()];
                filter.toArray(this.members);
            }
        }

        @Override
        public boolean matches() {
            if (this.dataPositions != null) {
                this.setPositions();
            }
            boolean matches = true;
            if (this.members != null) {
                for (int i2 = 0; i2 < this.members.length; ++i2) {
                    Member memberInfo = this.members[i2];
                    JROlapMember member = this.member(memberInfo, this.positions);
                    JROlapDataSource.this.setMatchMemberDepth(memberInfo, member);
                    if (memberInfo.matches(member)) continue;
                    matches = false;
                    break;
                }
            }
            return matches;
        }

        @Override
        public Object value() {
            JROlapCell cell = JROlapDataSource.this.olapResult.getCell(this.positions);
            if (cell != null && cell.isError()) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_OLAP_CELL_CALCULATION_ERROR, (Object[])null);
            }
            String value = cell == null || cell.isNull() ? null : (this.formatted ? cell.getFormattedValue() : cell.getValue().toString());
            return value;
        }

        void setPositions() {
            this.positions = new int[JROlapDataSource.this.axes.length];
            for (int i2 = 0; i2 < JROlapDataSource.this.axes.length; ++i2) {
                int dataPosition = this.dataPositions[i2];
                this.positions[i2] = dataPosition == -1 ? JROlapDataSource.this.axisPositions[i2] : dataPosition;
            }
        }
    }

    protected class MemberFieldMatcher
    extends FieldMatcher {
        final Member memberInfo;
        final MemberProperty property;
        JROlapMember member;

        MemberFieldMatcher(MemberMapping mapping) {
            this.memberInfo = mapping.getMember();
            this.property = mapping.getProperty();
        }

        @Override
        public boolean matches() {
            this.member = this.member(this.memberInfo, JROlapDataSource.this.axisPositions);
            JROlapDataSource.this.setMatchMemberDepth(this.memberInfo, this.member);
            this.member = this.memberInfo.ancestorMatch(this.member);
            return this.member != null;
        }

        @Override
        public Object value() {
            if (this.memberInfo.getDepth() == null) {
                return this.member.getMember();
            }
            Object value = this.property != null ? this.member.getPropertyValue(this.property.getName()) : this.member.getName();
            return value.toString();
        }
    }

    protected abstract class FieldMatcher {
        protected FieldMatcher() {
        }

        public abstract boolean matches();

        public abstract Object value();

        public final JROlapMember member(Member memberInfo, int[] positions) {
            int axisIdx = memberInfo.getAxis().getIdx();
            JROlapResultAxis axis = JROlapDataSource.this.axes[axisIdx];
            JROlapMemberTuple tuple = axis.getTuple(positions[axisIdx]);
            JROlapMember[] members = tuple.getMembers();
            int pos = memberInfo.getPosition().getIdx();
            return members[pos];
        }
    }
}

