/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.olap.Olap4jDataSource;
import net.sf.jasperreports.olap.mondrian.JRMondrianResult;
import net.sf.jasperreports.olap.result.JROlapResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.layout.RectangularCellSetFormatter;

public class Olap4jMondrianQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(Olap4jMondrianQueryExecuter.class);
    public static final String EXCEPTION_MESSAGE_KEY_CONNECTION_ERROR = "query.mondrian.connection.error";
    public static final String EXCEPTION_MESSAGE_KEY_EXECUTE_QUERY_ERROR = "query.mondrian.execute.query.error";
    public static final String OLAP4J_DRIVER = "olap4jDriver";
    public static final String OLAP4J_URL_PREFIX = "urlPrefix";
    public static final String OLAP4J_JDBC_DRIVERS = "JdbcDrivers";
    public static final String OLAP4J_JDBC_URL = "Jdbc";
    public static final String OLAP4J_JDBC_CATALOG = "Catalog";
    public static final String OLAP4J_JDBC_USER = "JdbcUser";
    public static final String OLAP4J_JDBC_PASSWORD = "JdbcPassword";
    public static final String OLAP4J_MONDRIAN_DRIVER_CLASS = "mondrian.olap4j.MondrianOlap4jDriver";
    public static final String OLAP4J_MONDRIAN_URL_PREFIX = "jdbc:mondrian:";
    private Connection rConnection;
    private JRMondrianResult monResult;

    public Olap4jMondrianQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
        this.parseQuery();
    }

    @Override
    protected String getCanonicalQueryLanguage() {
        return "OLAP4J";
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        String password;
        Olap4jDataSource dataSource = null;
        Properties connectProps = new Properties();
        connectProps.put(OLAP4J_JDBC_DRIVERS, this.getParameterValue(OLAP4J_JDBC_DRIVERS));
        connectProps.put(OLAP4J_JDBC_URL, this.getParameterValue("JdbcUrl"));
        connectProps.put(OLAP4J_JDBC_CATALOG, this.getParameterValue(OLAP4J_JDBC_CATALOG));
        String user = (String)this.getParameterValue(OLAP4J_JDBC_USER);
        if (user != null) {
            connectProps.put(OLAP4J_JDBC_USER, user);
        }
        if ((password = (String)this.getParameterValue(OLAP4J_JDBC_PASSWORD)) != null) {
            connectProps.put(OLAP4J_JDBC_PASSWORD, password);
        }
        connectProps.put(OLAP4J_DRIVER, OLAP4J_MONDRIAN_DRIVER_CLASS);
        connectProps.put(OLAP4J_URL_PREFIX, OLAP4J_MONDRIAN_URL_PREFIX);
        this.rConnection = null;
        try {
            Class.forName(OLAP4J_MONDRIAN_DRIVER_CLASS);
            this.rConnection = DriverManager.getConnection(OLAP4J_MONDRIAN_URL_PREFIX, connectProps);
        }
        catch (Throwable t2) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_CONNECTION_ERROR, new Object[]{OLAP4J_MONDRIAN_DRIVER_CLASS}, t2);
        }
        OlapConnection connection = (OlapConnection)this.rConnection;
        String queryStr = this.getQueryString();
        if (connection != null && queryStr != null) {
            if (log.isDebugEnabled()) {
                log.debug("MDX query: " + queryStr);
            }
            CellSet result = null;
            try {
                OlapStatement statement = connection.createStatement();
                result = statement.executeOlapQuery(this.getQueryString());
            }
            catch (OlapException e2) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_EXECUTE_QUERY_ERROR, new Object[]{this.getQueryString()}, e2);
            }
            if (log.isDebugEnabled()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                RectangularCellSetFormatter formatter = new RectangularCellSetFormatter(true);
                formatter.format(result, new PrintWriter(bos, true));
                log.debug("Result:\n" + ((Object)bos).toString());
            }
            dataSource = new Olap4jDataSource(this.dataset, result);
        }
        return dataSource;
    }

    @Override
    public boolean cancelQuery() throws JRException {
        return false;
    }

    public JROlapResult getResult() {
        return this.monResult;
    }

    @Override
    public void close() {
    }
}

