/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim;

import java.awt.geom.Point2D;
import org.apache.batik.anim.InterpolatingAnimation;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.anim.values.AnimatableAngleValue;
import org.apache.batik.anim.values.AnimatableMotionPointValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimatableElement;
import org.apache.batik.ext.awt.geom.Cubic;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.ext.awt.geom.ExtendedPathIterator;
import org.apache.batik.ext.awt.geom.PathLength;

public class MotionAnimation
extends InterpolatingAnimation {
    protected ExtendedGeneralPath path;
    protected PathLength pathLength;
    protected float[] keyPoints;
    protected boolean rotateAuto;
    protected boolean rotateAutoReverse;
    protected float rotateAngle;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MotionAnimation(TimedElement timedElement, AnimatableElement animatableElement, int n2, float[] fArray, float[] fArray2, boolean bl, boolean bl2, AnimatableValue[] animatableValueArray, AnimatableValue animatableValue, AnimatableValue animatableValue2, AnimatableValue animatableValue3, ExtendedGeneralPath extendedGeneralPath, float[] fArray3, boolean bl3, boolean bl4, float f2, short s2) {
        super(timedElement, animatableElement, n2, fArray, fArray2, bl, bl2);
        int n3;
        int n4;
        this.rotateAuto = bl3;
        this.rotateAutoReverse = bl4;
        this.rotateAngle = AnimatableAngleValue.rad(f2, s2);
        if (extendedGeneralPath == null) {
            AnimatableMotionPointValue animatableMotionPointValue;
            extendedGeneralPath = new ExtendedGeneralPath();
            if (animatableValueArray == null || animatableValueArray.length == 0) {
                if (animatableValue != null) {
                    AnimatableMotionPointValue animatableMotionPointValue2;
                    animatableMotionPointValue = (AnimatableMotionPointValue)animatableValue;
                    float f3 = animatableMotionPointValue.getX();
                    float f4 = animatableMotionPointValue.getY();
                    extendedGeneralPath.moveTo(f3, f4);
                    if (animatableValue2 != null) {
                        animatableMotionPointValue2 = (AnimatableMotionPointValue)animatableValue2;
                        extendedGeneralPath.lineTo(animatableMotionPointValue2.getX(), animatableMotionPointValue2.getY());
                    } else {
                        if (animatableValue3 == null) throw timedElement.createException("values.to.by.path.missing", new Object[]{null});
                        animatableMotionPointValue2 = (AnimatableMotionPointValue)animatableValue3;
                        extendedGeneralPath.lineTo(f3 + animatableMotionPointValue2.getX(), f4 + animatableMotionPointValue2.getY());
                    }
                } else if (animatableValue2 != null) {
                    animatableMotionPointValue = (AnimatableMotionPointValue)animatableElement.getUnderlyingValue();
                    AnimatableMotionPointValue animatableMotionPointValue3 = (AnimatableMotionPointValue)animatableValue2;
                    extendedGeneralPath.moveTo(animatableMotionPointValue.getX(), animatableMotionPointValue.getY());
                    extendedGeneralPath.lineTo(animatableMotionPointValue3.getX(), animatableMotionPointValue3.getY());
                    this.cumulative = false;
                } else {
                    if (animatableValue3 == null) throw timedElement.createException("values.to.by.path.missing", new Object[]{null});
                    animatableMotionPointValue = (AnimatableMotionPointValue)animatableValue3;
                    extendedGeneralPath.moveTo(0.0f, 0.0f);
                    extendedGeneralPath.lineTo(animatableMotionPointValue.getX(), animatableMotionPointValue.getY());
                    this.additive = true;
                }
            } else {
                animatableMotionPointValue = (AnimatableMotionPointValue)animatableValueArray[0];
                extendedGeneralPath.moveTo(animatableMotionPointValue.getX(), animatableMotionPointValue.getY());
                for (int i2 = 1; i2 < animatableValueArray.length; ++i2) {
                    animatableMotionPointValue = (AnimatableMotionPointValue)animatableValueArray[i2];
                    extendedGeneralPath.lineTo(animatableMotionPointValue.getX(), animatableMotionPointValue.getY());
                }
            }
        }
        this.path = extendedGeneralPath;
        this.pathLength = new PathLength(extendedGeneralPath);
        int n5 = 0;
        ExtendedPathIterator extendedPathIterator = extendedGeneralPath.getExtendedPathIterator();
        while (!extendedPathIterator.isDone()) {
            int n6 = extendedPathIterator.currentSegment();
            if (n6 != 0) {
                ++n5;
            }
            extendedPathIterator.next();
        }
        int n7 = fArray3 == null ? n5 + 1 : fArray3.length;
        float f5 = this.pathLength.lengthOfPath();
        if (this.keyTimes != null && n2 != 2) {
            if (this.keyTimes.length != n7) {
                throw timedElement.createException("attribute.malformed", new Object[]{null, "keyTimes"});
            }
        } else if (n2 == 1 || n2 == 3) {
            this.keyTimes = new float[n7];
            for (n4 = 0; n4 < n7; ++n4) {
                this.keyTimes[n4] = (float)n4 / (float)(n7 - 1);
            }
        } else if (n2 == 0) {
            this.keyTimes = new float[n7];
            for (n4 = 0; n4 < n7; ++n4) {
                this.keyTimes[n4] = (float)n4 / (float)n7;
            }
        } else {
            extendedPathIterator = extendedGeneralPath.getExtendedPathIterator();
            this.keyTimes = new float[n7];
            n4 = 0;
            for (n3 = 0; n3 < n7 - 1; ++n3) {
                while (extendedPathIterator.currentSegment() == 0) {
                    ++n4;
                    extendedPathIterator.next();
                }
                this.keyTimes[n3] = this.pathLength.getLengthAtSegment(n4) / f5;
                ++n4;
                extendedPathIterator.next();
            }
            this.keyTimes[n7 - 1] = 1.0f;
        }
        if (fArray3 != null) {
            if (fArray3.length != this.keyTimes.length) {
                throw timedElement.createException("attribute.malformed", new Object[]{null, "keyPoints"});
            }
        } else {
            extendedPathIterator = extendedGeneralPath.getExtendedPathIterator();
            fArray3 = new float[n7];
            n4 = 0;
            for (n3 = 0; n3 < n7 - 1; ++n3) {
                while (extendedPathIterator.currentSegment() == 0) {
                    ++n4;
                    extendedPathIterator.next();
                }
                fArray3[n3] = this.pathLength.getLengthAtSegment(n4) / f5;
                ++n4;
                extendedPathIterator.next();
            }
            fArray3[n7 - 1] = 1.0f;
        }
        this.keyPoints = fArray3;
    }

    protected void sampledAtUnitTime(float f2, int n2) {
        AnimatableMotionPointValue animatableMotionPointValue;
        AnimatableMotionPointValue animatableMotionPointValue2;
        float f3;
        float f4 = 0.0f;
        if (f2 != 1.0f) {
            float f5;
            int n3;
            for (n3 = 0; n3 < this.keyTimes.length - 1 && f2 >= this.keyTimes[n3 + 1]; ++n3) {
            }
            if (n3 == this.keyTimes.length - 1 && this.calcMode == 0) {
                n3 = this.keyTimes.length - 2;
                f4 = 1.0f;
            } else if (this.calcMode == 1 || this.calcMode == 2 || this.calcMode == 3) {
                f4 = f2 == 0.0f ? 0.0f : (f2 - this.keyTimes[n3]) / (this.keyTimes[n3 + 1] - this.keyTimes[n3]);
                if (this.calcMode == 3 && f2 != 0.0f) {
                    float f6;
                    Point2D.Double double_;
                    double d2;
                    Cubic cubic = this.keySplineCubics[n3];
                    float f7 = 0.001f;
                    f5 = 0.0f;
                    float f8 = 1.0f;
                    while (!(Math.abs((d2 = (double_ = cubic.eval(f6 = (f5 + f8) / 2.0f)).getX()) - (double)f4) < (double)f7)) {
                        if (d2 < (double)f4) {
                            f5 = f6;
                            continue;
                        }
                        f8 = f6;
                    }
                    f4 = (float)double_.getY();
                }
            }
            f3 = this.keyPoints[n3];
            if (f4 != 0.0f) {
                f3 += f4 * (this.keyPoints[n3 + 1] - this.keyPoints[n3]);
            }
            Point2D point2D = this.pathLength.pointAtLength(f3 *= this.pathLength.lengthOfPath());
            if (this.rotateAuto) {
                f5 = this.pathLength.angleAtLength(f3);
                if (this.rotateAutoReverse) {
                    f5 = (float)((double)f5 + Math.PI);
                }
            } else {
                f5 = this.rotateAngle;
            }
            animatableMotionPointValue2 = new AnimatableMotionPointValue(null, (float)point2D.getX(), (float)point2D.getY(), f5);
        } else {
            Point2D point2D = this.pathLength.pointAtLength(this.pathLength.lengthOfPath());
            if (this.rotateAuto) {
                f3 = this.pathLength.angleAtLength(this.pathLength.lengthOfPath());
                if (this.rotateAutoReverse) {
                    f3 = (float)((double)f3 + Math.PI);
                }
            } else {
                f3 = this.rotateAngle;
            }
            animatableMotionPointValue2 = new AnimatableMotionPointValue(null, (float)point2D.getX(), (float)point2D.getY(), f3);
        }
        if (this.cumulative) {
            Point2D point2D = this.pathLength.pointAtLength(this.pathLength.lengthOfPath());
            if (this.rotateAuto) {
                f3 = this.pathLength.angleAtLength(this.pathLength.lengthOfPath());
                if (this.rotateAutoReverse) {
                    f3 = (float)((double)f3 + Math.PI);
                }
            } else {
                f3 = this.rotateAngle;
            }
            animatableMotionPointValue = new AnimatableMotionPointValue(null, (float)point2D.getX(), (float)point2D.getY(), f3);
        } else {
            animatableMotionPointValue = null;
        }
        this.value = ((AnimatableValue)animatableMotionPointValue2).interpolate(this.value, null, f4, animatableMotionPointValue, n2);
        if (this.value.hasChanged()) {
            this.markDirty();
        }
    }
}

