/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableColorValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatablePaintValue
extends AnimatableColorValue {
    public static final int PAINT_NONE = 0;
    public static final int PAINT_CURRENT_COLOR = 1;
    public static final int PAINT_COLOR = 2;
    public static final int PAINT_URI = 3;
    public static final int PAINT_URI_NONE = 4;
    public static final int PAINT_URI_CURRENT_COLOR = 5;
    public static final int PAINT_URI_COLOR = 6;
    public static final int PAINT_INHERIT = 7;
    protected int paintType;
    protected String uri;

    protected AnimatablePaintValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    protected AnimatablePaintValue(AnimationTarget animationTarget, float f2, float f3, float f4) {
        super(animationTarget, f2, f3, f4);
    }

    public static AnimatablePaintValue createNonePaintValue(AnimationTarget animationTarget) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget);
        animatablePaintValue.paintType = 0;
        return animatablePaintValue;
    }

    public static AnimatablePaintValue createCurrentColorPaintValue(AnimationTarget animationTarget) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget);
        animatablePaintValue.paintType = 1;
        return animatablePaintValue;
    }

    public static AnimatablePaintValue createColorPaintValue(AnimationTarget animationTarget, float f2, float f3, float f4) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget, f2, f3, f4);
        animatablePaintValue.paintType = 2;
        return animatablePaintValue;
    }

    public static AnimatablePaintValue createURIPaintValue(AnimationTarget animationTarget, String string) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget);
        animatablePaintValue.uri = string;
        animatablePaintValue.paintType = 3;
        return animatablePaintValue;
    }

    public static AnimatablePaintValue createURINonePaintValue(AnimationTarget animationTarget, String string) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget);
        animatablePaintValue.uri = string;
        animatablePaintValue.paintType = 4;
        return animatablePaintValue;
    }

    public static AnimatablePaintValue createURICurrentColorPaintValue(AnimationTarget animationTarget, String string) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget);
        animatablePaintValue.uri = string;
        animatablePaintValue.paintType = 5;
        return animatablePaintValue;
    }

    public static AnimatablePaintValue createURIColorPaintValue(AnimationTarget animationTarget, String string, float f2, float f3, float f4) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget, f2, f3, f4);
        animatablePaintValue.uri = string;
        animatablePaintValue.paintType = 6;
        return animatablePaintValue;
    }

    public static AnimatablePaintValue createInheritPaintValue(AnimationTarget animationTarget) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget);
        animatablePaintValue.paintType = 7;
        return animatablePaintValue;
    }

    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f2, AnimatableValue animatableValue3, int n2) {
        float f3;
        float f4;
        float f5;
        Object object;
        int n3;
        AnimatablePaintValue animatablePaintValue = animatableValue == null ? new AnimatablePaintValue(this.target) : (AnimatablePaintValue)animatableValue;
        if (this.paintType == 2) {
            n3 = 1;
            if (animatableValue2 != null) {
                object = (AnimatablePaintValue)animatableValue2;
                int n4 = n3 = ((AnimatablePaintValue)object).paintType == 2 ? 1 : 0;
            }
            if (animatableValue3 != null) {
                object = (AnimatablePaintValue)animatableValue3;
                int n5 = n3 = n3 != 0 && ((AnimatablePaintValue)object).paintType == 2 ? 1 : 0;
            }
            if (n3 != 0) {
                animatablePaintValue.paintType = 2;
                return super.interpolate(animatablePaintValue, animatableValue2, f2, animatableValue3, n2);
            }
        }
        if (animatableValue2 != null && (double)f2 >= 0.5) {
            AnimatablePaintValue animatablePaintValue2 = (AnimatablePaintValue)animatableValue2;
            n3 = animatablePaintValue2.paintType;
            object = animatablePaintValue2.uri;
            f5 = animatablePaintValue2.red;
            f4 = animatablePaintValue2.green;
            f3 = animatablePaintValue2.blue;
        } else {
            n3 = this.paintType;
            object = this.uri;
            f5 = this.red;
            f4 = this.green;
            f3 = this.blue;
        }
        if (animatablePaintValue.paintType != n3 || animatablePaintValue.uri == null || !animatablePaintValue.uri.equals(object) || animatablePaintValue.red != f5 || animatablePaintValue.green != f4 || animatablePaintValue.blue != f3) {
            animatablePaintValue.paintType = n3;
            animatablePaintValue.uri = object;
            animatablePaintValue.red = f5;
            animatablePaintValue.green = f4;
            animatablePaintValue.blue = f3;
            animatablePaintValue.hasChanged = true;
        }
        return animatablePaintValue;
    }

    public int getPaintType() {
        return this.paintType;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean canPace() {
        return false;
    }

    public float distanceTo(AnimatableValue animatableValue) {
        return 0.0f;
    }

    public AnimatableValue getZeroValue() {
        return AnimatablePaintValue.createColorPaintValue(this.target, 0.0f, 0.0f, 0.0f);
    }

    public String getCssText() {
        switch (this.paintType) {
            case 0: {
                return "none";
            }
            case 1: {
                return "currentColor";
            }
            case 2: {
                return super.getCssText();
            }
            case 3: {
                return "url(" + this.uri + ")";
            }
            case 4: {
                return "url(" + this.uri + ") none";
            }
            case 5: {
                return "url(" + this.uri + ") currentColor";
            }
            case 6: {
                return "url(" + this.uri + ") " + super.getCssText();
            }
        }
        return "inherit";
    }
}

