/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.batik.apps.svgbrowser.DOMDocumentTreeController;
import org.apache.batik.apps.svgbrowser.DOMViewer;
import org.apache.batik.dom.util.DOMUtilities;
import org.w3c.dom.Node;

public class DOMDocumentTree
extends JTree
implements Autoscroll {
    protected EventListenerList eventListeners = new EventListenerList();
    protected Insets autoscrollInsets = new Insets(20, 20, 20, 20);
    protected Insets scrollUnits = new Insets(25, 25, 25, 25);
    protected DOMDocumentTreeController controller;
    static /* synthetic */ Class class$org$apache$batik$apps$svgbrowser$DOMDocumentTree$TransferData;
    static /* synthetic */ Class class$javax$swing$JViewport;
    static /* synthetic */ Class class$org$apache$batik$apps$svgbrowser$DOMDocumentTree$DOMDocumentTreeListener;

    public DOMDocumentTree(TreeNode treeNode, DOMDocumentTreeController dOMDocumentTreeController) {
        super(treeNode);
        this.controller = dOMDocumentTreeController;
        new TreeDragSource(this, 3);
        new DropTarget(this, new TreeDropTargetListener(this));
    }

    public void autoscroll(Point point) {
        JViewport jViewport = (JViewport)SwingUtilities.getAncestorOfClass(class$javax$swing$JViewport == null ? (class$javax$swing$JViewport = DOMDocumentTree.class$("javax.swing.JViewport")) : class$javax$swing$JViewport, this);
        if (jViewport == null) {
            return;
        }
        Point point2 = jViewport.getViewPosition();
        int n2 = jViewport.getExtentSize().height;
        int n3 = jViewport.getExtentSize().width;
        if (point.y - point2.y < this.autoscrollInsets.top) {
            jViewport.setViewPosition(new Point(point2.x, Math.max(point2.y - this.scrollUnits.top, 0)));
            this.fireOnAutoscroll(new DOMDocumentTreeEvent(this));
        } else if (point2.y + n2 - point.y < this.autoscrollInsets.bottom) {
            jViewport.setViewPosition(new Point(point2.x, Math.min(point2.y + this.scrollUnits.bottom, this.getHeight() - n2)));
            this.fireOnAutoscroll(new DOMDocumentTreeEvent(this));
        } else if (point.x - point2.x < this.autoscrollInsets.left) {
            jViewport.setViewPosition(new Point(Math.max(point2.x - this.scrollUnits.left, 0), point2.y));
            this.fireOnAutoscroll(new DOMDocumentTreeEvent(this));
        } else if (point2.x + n3 - point.x < this.autoscrollInsets.right) {
            jViewport.setViewPosition(new Point(Math.min(point2.x + this.scrollUnits.right, this.getWidth() - n3), point2.y));
            this.fireOnAutoscroll(new DOMDocumentTreeEvent(this));
        }
    }

    public Insets getAutoscrollInsets() {
        int n2 = this.getHeight();
        int n3 = this.getWidth();
        return new Insets(n2, n3, n2, n3);
    }

    public void addListener(DOMDocumentTreeListener dOMDocumentTreeListener) {
        this.eventListeners.add(class$org$apache$batik$apps$svgbrowser$DOMDocumentTree$DOMDocumentTreeListener == null ? (class$org$apache$batik$apps$svgbrowser$DOMDocumentTree$DOMDocumentTreeListener = DOMDocumentTree.class$("org.apache.batik.apps.svgbrowser.DOMDocumentTree$DOMDocumentTreeListener")) : class$org$apache$batik$apps$svgbrowser$DOMDocumentTree$DOMDocumentTreeListener, dOMDocumentTreeListener);
    }

    public void fireDropCompleted(DOMDocumentTreeEvent dOMDocumentTreeEvent) {
        Object[] objectArray = this.eventListeners.getListenerList();
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            if (objectArray[i2] != (class$org$apache$batik$apps$svgbrowser$DOMDocumentTree$DOMDocumentTreeListener == null ? DOMDocumentTree.class$("org.apache.batik.apps.svgbrowser.DOMDocumentTree$DOMDocumentTreeListener") : class$org$apache$batik$apps$svgbrowser$DOMDocumentTree$DOMDocumentTreeListener)) continue;
            ((DOMDocumentTreeListener)objectArray[i2 + 1]).dropCompleted(dOMDocumentTreeEvent);
        }
    }

    public void fireOnAutoscroll(DOMDocumentTreeEvent dOMDocumentTreeEvent) {
        Object[] objectArray = this.eventListeners.getListenerList();
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            if (objectArray[i2] != (class$org$apache$batik$apps$svgbrowser$DOMDocumentTree$DOMDocumentTreeListener == null ? DOMDocumentTree.class$("org.apache.batik.apps.svgbrowser.DOMDocumentTree$DOMDocumentTreeListener") : class$org$apache$batik$apps$svgbrowser$DOMDocumentTree$DOMDocumentTreeListener)) continue;
            ((DOMDocumentTreeListener)objectArray[i2 + 1]).onAutoscroll(dOMDocumentTreeEvent);
        }
    }

    protected Node getDomNodeFromTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return null;
        }
        if (defaultMutableTreeNode.getUserObject() instanceof DOMViewer.NodeInfo) {
            return ((DOMViewer.NodeInfo)defaultMutableTreeNode.getUserObject()).getNode();
        }
        return null;
    }

    protected ArrayList getNodeListForParent(ArrayList arrayList, Node node) {
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = (Node)arrayList.get(i2);
            if (!DOMUtilities.canAppend(node2, node)) continue;
            arrayList2.add(node2);
        }
        return arrayList2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DropCompletedInfo {
        protected Node parent;
        protected ArrayList children;
        protected Node sibling;

        public DropCompletedInfo(Node node, Node node2, ArrayList arrayList) {
            this.parent = node;
            this.sibling = node2;
            this.children = arrayList;
        }

        public ArrayList getChildren() {
            return this.children;
        }

        public Node getParent() {
            return this.parent;
        }

        public Node getSibling() {
            return this.sibling;
        }
    }

    public static class DOMDocumentTreeAdapter
    implements DOMDocumentTreeListener {
        public void dropCompleted(DOMDocumentTreeEvent dOMDocumentTreeEvent) {
        }

        public void onAutoscroll(DOMDocumentTreeEvent dOMDocumentTreeEvent) {
        }
    }

    public static interface DOMDocumentTreeListener
    extends EventListener {
        public void dropCompleted(DOMDocumentTreeEvent var1);

        public void onAutoscroll(DOMDocumentTreeEvent var1);
    }

    public static class DOMDocumentTreeEvent
    extends EventObject {
        public DOMDocumentTreeEvent(Object object) {
            super(object);
        }
    }

    public static class TransferData {
        protected ArrayList nodeList;

        public TransferData(ArrayList arrayList) {
            this.nodeList = arrayList;
        }

        public ArrayList getNodeList() {
            return this.nodeList;
        }

        public String getNodesAsXML() {
            String string = "";
            Iterator iterator = this.nodeList.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                string = string + DOMUtilities.getXML(node);
            }
            return string;
        }
    }

    public static class TransferableTreeNode
    implements Transferable {
        protected static final DataFlavor NODE_FLAVOR = new DataFlavor(class$org$apache$batik$apps$svgbrowser$DOMDocumentTree$TransferData == null ? (class$org$apache$batik$apps$svgbrowser$DOMDocumentTree$TransferData = DOMDocumentTree.class$("org.apache.batik.apps.svgbrowser.DOMDocumentTree$TransferData")) : class$org$apache$batik$apps$svgbrowser$DOMDocumentTree$TransferData, "TransferData");
        protected static final DataFlavor[] FLAVORS = new DataFlavor[]{NODE_FLAVOR, DataFlavor.stringFlavor};
        protected TransferData data;

        public TransferableTreeNode(TransferData transferData) {
            this.data = transferData;
        }

        public synchronized DataFlavor[] getTransferDataFlavors() {
            return FLAVORS;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (int i2 = 0; i2 < FLAVORS.length; ++i2) {
                if (!dataFlavor.equals(FLAVORS[i2])) continue;
                return true;
            }
            return false;
        }

        public synchronized Object getTransferData(DataFlavor dataFlavor) {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                return null;
            }
            if (dataFlavor.equals(NODE_FLAVOR)) {
                return this.data;
            }
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                return this.data.getNodesAsXML();
            }
            return null;
        }
    }

    public class TreeDropTargetListener
    implements DropTargetListener {
        private static final int BEFORE = 1;
        private static final int AFTER = 2;
        private static final int CURRENT = 3;
        private TransferData transferData;
        private Component originalGlassPane;
        private int visualTipOffset = 5;
        private int visualTipThickness = 2;
        private int positionIndicator;
        private Point startPoint;
        private Point endPoint;
        protected JPanel visualTipGlassPane = new JPanel(this){
            private final /* synthetic */ TreeDropTargetListener this$1;
            {
                this.this$1 = treeDropTargetListener;
            }

            public void paint(Graphics graphics) {
                graphics.setColor(UIManager.getColor("Tree.selectionBackground"));
                if (TreeDropTargetListener.access$000(this.this$1) == null || TreeDropTargetListener.access$100(this.this$1) == null) {
                    return;
                }
                int n2 = TreeDropTargetListener.access$000((TreeDropTargetListener)this.this$1).x;
                int n3 = TreeDropTargetListener.access$100((TreeDropTargetListener)this.this$1).x;
                int n4 = TreeDropTargetListener.access$000((TreeDropTargetListener)this.this$1).y;
                int n5 = -TreeDropTargetListener.access$200(this.this$1) / 2;
                for (int i2 = n5 += TreeDropTargetListener.access$200(this.this$1) % 2 == 0 ? 1 : 0; i2 <= TreeDropTargetListener.access$200(this.this$1) / 2; ++i2) {
                    graphics.drawLine(n2 + 2, n4 + i2, n3 - 2, n4 + i2);
                }
            }
        };
        private Timer expandControlTimer;
        private int expandTimeout = 1500;
        private TreePath dragOverTreePath;
        private TreePath treePathToExpand;

        public TreeDropTargetListener(DOMDocumentTree dOMDocumentTree2) {
            this.addOnAutoscrollListener(dOMDocumentTree2);
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            JTree jTree = (JTree)dropTargetDragEvent.getDropTargetContext().getComponent();
            JRootPane jRootPane = jTree.getRootPane();
            this.originalGlassPane = jRootPane.getGlassPane();
            jRootPane.setGlassPane(this.visualTipGlassPane);
            this.visualTipGlassPane.setOpaque(false);
            this.visualTipGlassPane.setVisible(true);
            this.updateVisualTipLine(jTree, null);
            try {
                Transferable transferable = new DropTargetDropEvent(dropTargetDragEvent.getDropTargetContext(), dropTargetDragEvent.getLocation(), 0, 0).getTransferable();
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
                    if (!transferable.isDataFlavorSupported(dataFlavorArray[i2])) continue;
                    this.transferData = (TransferData)transferable.getTransferData(dataFlavorArray[i2]);
                    return;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            JTree jTree = (JTree)dropTargetDragEvent.getDropTargetContext().getComponent();
            TreeNode treeNode = this.getNode(dropTargetDragEvent);
            if (treeNode != null) {
                this.updatePositionIndicator(dropTargetDragEvent);
                Point point = dropTargetDragEvent.getLocation();
                TreePath treePath = jTree.getPathForLocation(point.x, point.y);
                TreePath treePath2 = this.getParentPathForPosition(treePath);
                TreeNode treeNode2 = this.getNodeForPath(treePath2);
                TreePath treePath3 = this.getSiblingPathForPosition(treePath);
                TreeNode treeNode3 = this.getNodeForPath(treePath3);
                Node node = DOMDocumentTree.this.getDomNodeFromTreeNode((DefaultMutableTreeNode)treeNode2);
                Node node2 = DOMDocumentTree.this.getDomNodeFromTreeNode((DefaultMutableTreeNode)treeNode3);
                if (DOMUtilities.canAppendAny(this.transferData.getNodeList(), node) && !this.transferData.getNodeList().contains(node2)) {
                    dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                    this.updateVisualTipLine(jTree, treePath);
                    this.dragOverTreePath = treePath;
                    if (!jTree.isExpanded(treePath)) {
                        this.scheduleExpand(treePath, jTree);
                    }
                } else {
                    dropTargetDragEvent.rejectDrag();
                }
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Point point = dropTargetDropEvent.getLocation();
            DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
            JTree jTree = (JTree)dropTargetContext.getComponent();
            this.setOriginalGlassPane(jTree);
            this.dragOverTreePath = null;
            TreePath treePath = jTree.getPathForLocation(point.x, point.y);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getNodeForPath(this.getParentPathForPosition(treePath));
            Node node = DOMDocumentTree.this.getDomNodeFromTreeNode(defaultMutableTreeNode);
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.getNodeForPath(this.getSiblingPathForPosition(treePath));
            Node node2 = DOMDocumentTree.this.getDomNodeFromTreeNode(defaultMutableTreeNode2);
            if (this.transferData != null) {
                ArrayList arrayList = DOMDocumentTree.this.getNodeListForParent(this.transferData.getNodeList(), node);
                DOMDocumentTree.this.fireDropCompleted(new DOMDocumentTreeEvent(new DropCompletedInfo(node, node2, arrayList)));
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            dropTargetDropEvent.rejectDrop();
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            this.setOriginalGlassPane((JTree)dropTargetEvent.getDropTargetContext().getComponent());
            this.dragOverTreePath = null;
        }

        private void updatePositionIndicator(DropTargetDragEvent dropTargetDragEvent) {
            Point point = dropTargetDragEvent.getLocation();
            DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
            JTree jTree = (JTree)dropTargetContext.getComponent();
            TreePath treePath = jTree.getPathForLocation(point.x, point.y);
            Rectangle rectangle = jTree.getPathBounds(treePath);
            this.positionIndicator = point.y <= rectangle.y + this.visualTipOffset ? 1 : (point.y >= rectangle.y + rectangle.height - this.visualTipOffset ? 2 : 3);
        }

        private TreePath getParentPathForPosition(TreePath treePath) {
            if (treePath == null) {
                return null;
            }
            TreePath treePath2 = null;
            if (this.positionIndicator == 2) {
                treePath2 = treePath.getParentPath();
            } else if (this.positionIndicator == 1) {
                treePath2 = treePath.getParentPath();
            } else if (this.positionIndicator == 3) {
                treePath2 = treePath;
            }
            return treePath2;
        }

        private TreePath getSiblingPathForPosition(TreePath treePath) {
            TreePath treePath2 = this.getParentPathForPosition(treePath);
            TreePath treePath3 = null;
            if (this.positionIndicator == 2) {
                TreeNode treeNode = this.getNodeForPath(treePath2);
                TreeNode treeNode2 = this.getNodeForPath(treePath);
                if (treePath2 != null && treeNode != null && treeNode2 != null) {
                    int n2 = treeNode.getIndex(treeNode2) + 1;
                    if (treeNode.getChildCount() > n2) {
                        treePath3 = treePath2.pathByAddingChild(treeNode.getChildAt(n2));
                    }
                }
            } else if (this.positionIndicator == 1) {
                treePath3 = treePath;
            } else if (this.positionIndicator == 3) {
                treePath3 = null;
            }
            return treePath3;
        }

        private TreeNode getNodeForPath(TreePath treePath) {
            if (treePath == null || treePath.getLastPathComponent() == null) {
                return null;
            }
            return (TreeNode)treePath.getLastPathComponent();
        }

        private TreeNode getNode(DropTargetDragEvent dropTargetDragEvent) {
            Point point = dropTargetDragEvent.getLocation();
            DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
            JTree jTree = (JTree)dropTargetContext.getComponent();
            TreePath treePath = jTree.getPathForLocation(point.x, point.y);
            if (treePath == null || treePath.getLastPathComponent() == null) {
                return null;
            }
            return (TreeNode)treePath.getLastPathComponent();
        }

        private void updateVisualTipLine(JTree jTree, TreePath treePath) {
            if (treePath == null) {
                this.startPoint = null;
                this.endPoint = null;
            } else {
                Rectangle rectangle = jTree.getPathBounds(treePath);
                if (this.positionIndicator == 1) {
                    this.startPoint = rectangle.getLocation();
                    this.endPoint = new Point(this.startPoint.x + rectangle.width, this.startPoint.y);
                } else if (this.positionIndicator == 2) {
                    this.startPoint = new Point(rectangle.x, rectangle.y + rectangle.height);
                    this.endPoint = new Point(this.startPoint.x + rectangle.width, this.startPoint.y);
                    this.positionIndicator = 2;
                } else if (this.positionIndicator == 3) {
                    this.startPoint = null;
                    this.endPoint = null;
                }
                if (this.startPoint != null && this.endPoint != null) {
                    this.startPoint = SwingUtilities.convertPoint(jTree, this.startPoint, this.visualTipGlassPane);
                    this.endPoint = SwingUtilities.convertPoint(jTree, this.endPoint, this.visualTipGlassPane);
                }
            }
            this.visualTipGlassPane.getRootPane().repaint();
        }

        private void addOnAutoscrollListener(DOMDocumentTree dOMDocumentTree) {
            dOMDocumentTree.addListener(new DOMDocumentTreeAdapter(this){
                private final /* synthetic */ TreeDropTargetListener this$1;
                {
                    this.this$1 = treeDropTargetListener;
                }

                public void onAutoscroll(DOMDocumentTreeEvent dOMDocumentTreeEvent) {
                    TreeDropTargetListener.access$002(this.this$1, null);
                    TreeDropTargetListener.access$102(this.this$1, null);
                }
            });
        }

        private void setOriginalGlassPane(JTree jTree) {
            JRootPane jRootPane = jTree.getRootPane();
            jRootPane.setGlassPane(this.originalGlassPane);
            this.originalGlassPane.setVisible(false);
            jRootPane.repaint();
        }

        private void scheduleExpand(TreePath treePath, JTree jTree) {
            if (treePath != this.treePathToExpand) {
                this.getExpandTreeTimer(jTree).stop();
                this.treePathToExpand = treePath;
                this.getExpandTreeTimer(jTree).start();
            }
        }

        private Timer getExpandTreeTimer(JTree jTree) {
            if (this.expandControlTimer == null) {
                this.expandControlTimer = new Timer(this.expandTimeout, new ActionListener(this, jTree){
                    private final /* synthetic */ JTree val$tree;
                    private final /* synthetic */ TreeDropTargetListener this$1;
                    {
                        this.this$1 = treeDropTargetListener;
                        this.val$tree = jTree;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (TreeDropTargetListener.access$300(this.this$1) != null && TreeDropTargetListener.access$300(this.this$1) == TreeDropTargetListener.access$400(this.this$1)) {
                            this.val$tree.expandPath(TreeDropTargetListener.access$300(this.this$1));
                        }
                        TreeDropTargetListener.access$500(this.this$1, this.val$tree).stop();
                    }
                });
            }
            return this.expandControlTimer;
        }

        static /* synthetic */ Point access$000(TreeDropTargetListener treeDropTargetListener) {
            return treeDropTargetListener.startPoint;
        }

        static /* synthetic */ Point access$100(TreeDropTargetListener treeDropTargetListener) {
            return treeDropTargetListener.endPoint;
        }

        static /* synthetic */ int access$200(TreeDropTargetListener treeDropTargetListener) {
            return treeDropTargetListener.visualTipThickness;
        }

        static /* synthetic */ Point access$002(TreeDropTargetListener treeDropTargetListener, Point point) {
            treeDropTargetListener.startPoint = point;
            return treeDropTargetListener.startPoint;
        }

        static /* synthetic */ Point access$102(TreeDropTargetListener treeDropTargetListener, Point point) {
            treeDropTargetListener.endPoint = point;
            return treeDropTargetListener.endPoint;
        }

        static /* synthetic */ TreePath access$300(TreeDropTargetListener treeDropTargetListener) {
            return treeDropTargetListener.treePathToExpand;
        }

        static /* synthetic */ TreePath access$400(TreeDropTargetListener treeDropTargetListener) {
            return treeDropTargetListener.dragOverTreePath;
        }

        static /* synthetic */ Timer access$500(TreeDropTargetListener treeDropTargetListener, JTree jTree) {
            return treeDropTargetListener.getExpandTreeTimer(jTree);
        }
    }

    public class TreeDragSource
    implements DragSourceListener,
    DragGestureListener {
        protected DragSource source;
        protected DragGestureRecognizer recognizer;
        protected TransferableTreeNode transferable;
        protected DOMDocumentTree sourceTree;

        public TreeDragSource(DOMDocumentTree dOMDocumentTree2, int n2) {
            this.sourceTree = dOMDocumentTree2;
            this.source = new DragSource();
            this.recognizer = this.source.createDefaultDragGestureRecognizer(this.sourceTree, n2, this);
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (!DOMDocumentTree.this.controller.isDNDSupported()) {
                return;
            }
            TreePath[] treePathArray = this.sourceTree.getSelectionPaths();
            if (treePathArray == null) {
                return;
            }
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                Node node;
                TreePath treePath = treePathArray[i2];
                if (treePath.getPathCount() <= 1 || (node = DOMDocumentTree.this.getDomNodeFromTreeNode(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent())) == null) continue;
                arrayList.add(node);
            }
            if (arrayList.isEmpty()) {
                return;
            }
            this.transferable = new TransferableTreeNode(new TransferData(arrayList));
            this.source.startDrag(dragGestureEvent, null, this.transferable, this);
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }
    }
}

