/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.batik.apps.svgbrowser.JSVGViewerFrame;

public class LocalHistory {
    protected JSVGViewerFrame svgFrame;
    protected JMenu menu;
    protected int index;
    protected List visitedURIs = new ArrayList();
    protected int currentURI = -1;
    protected ButtonGroup group = new ButtonGroup();
    protected ActionListener actionListener = new RadioListener();
    protected int state;
    protected static final int STABLE_STATE = 0;
    protected static final int BACK_PENDING_STATE = 1;
    protected static final int FORWARD_PENDING_STATE = 2;
    protected static final int RELOAD_PENDING_STATE = 3;

    public LocalHistory(JMenuBar jMenuBar, JSVGViewerFrame jSVGViewerFrame) {
        this.svgFrame = jSVGViewerFrame;
        int n2 = jMenuBar.getMenuCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            JMenu jMenu = jMenuBar.getMenu(i2);
            int n3 = jMenu.getItemCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                String string;
                JMenuItem jMenuItem = jMenu.getItem(i3);
                if (jMenuItem == null || !"@@@".equals(string = jMenuItem.getText())) continue;
                this.menu = jMenu;
                this.index = i3;
                jMenu.remove(i3);
                return;
            }
        }
        throw new IllegalArgumentException("No '@@@' marker found");
    }

    public void back() {
        this.update();
        this.state = 1;
        this.currentURI -= 2;
        this.svgFrame.showSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public boolean canGoBack() {
        return this.currentURI > 0;
    }

    public void forward() {
        this.update();
        this.state = 2;
        this.svgFrame.showSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public boolean canGoForward() {
        return this.currentURI < this.visitedURIs.size() - 1;
    }

    public void reload() {
        this.update();
        this.state = 3;
        --this.currentURI;
        this.svgFrame.showSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public void update(String string) {
        Object object;
        JMenuItem jMenuItem;
        int n2;
        if (this.currentURI < -1) {
            throw new IllegalStateException("Unexpected currentURI:" + this.currentURI);
        }
        this.state = 0;
        if (++this.currentURI < this.visitedURIs.size()) {
            if (!this.visitedURIs.get(this.currentURI).equals(string)) {
                int n3 = this.menu.getItemCount();
                for (n2 = n3 - 1; n2 >= this.index + this.currentURI + 1; --n2) {
                    jMenuItem = this.menu.getItem(n2);
                    this.group.remove(jMenuItem);
                    this.menu.remove(n2);
                }
                this.visitedURIs = this.visitedURIs.subList(0, this.currentURI + 1);
            }
            object = this.menu.getItem(this.index + this.currentURI);
            this.group.remove((AbstractButton)object);
            this.menu.remove(this.index + this.currentURI);
            this.visitedURIs.set(this.currentURI, string);
        } else {
            if (this.visitedURIs.size() >= 15) {
                this.visitedURIs.remove(0);
                object = this.menu.getItem(this.index);
                this.group.remove((AbstractButton)object);
                this.menu.remove(this.index);
                --this.currentURI;
            }
            this.visitedURIs.add(string);
        }
        object = string;
        n2 = string.lastIndexOf(47);
        if (n2 == -1) {
            n2 = string.lastIndexOf(92);
        }
        if (n2 != -1) {
            object = string.substring(n2 + 1);
        }
        jMenuItem = new JRadioButtonMenuItem((String)object);
        jMenuItem.setToolTipText(string);
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this.actionListener);
        this.group.add(jMenuItem);
        jMenuItem.setSelected(true);
        this.menu.insert(jMenuItem, this.index + this.currentURI);
    }

    protected void update() {
        switch (this.state) {
            case 1: {
                this.currentURI += 2;
                break;
            }
            case 3: {
                ++this.currentURI;
                break;
            }
        }
    }

    protected class RadioListener
    implements ActionListener {
        protected RadioListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            LocalHistory.this.currentURI = this.getItemIndex((JMenuItem)actionEvent.getSource()) - 1;
            LocalHistory.this.svgFrame.showSVGDocument(string);
        }

        public int getItemIndex(JMenuItem jMenuItem) {
            int n2 = LocalHistory.this.menu.getItemCount();
            for (int i2 = LocalHistory.this.index; i2 < n2; ++i2) {
                if (LocalHistory.this.menu.getItem(i2) != jMenuItem) continue;
                return i2 - LocalHistory.this.index;
            }
            throw new IllegalArgumentException("MenuItem is not from my menu!");
        }
    }
}

