/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgpp;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;

public class Main {
    public static final String BUNDLE_CLASSNAME = "org.apache.batik.apps.svgpp.resources.Messages";
    protected static LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.apps.svgpp.resources.Messages", (class$org$apache$batik$apps$svgpp$Main == null ? (class$org$apache$batik$apps$svgpp$Main = Main.class$("org.apache.batik.apps.svgpp.Main")) : class$org$apache$batik$apps$svgpp$Main).getClassLoader());
    protected String[] arguments;
    protected int index;
    protected Map handlers = new HashMap();
    protected Transcoder transcoder;
    static /* synthetic */ Class class$org$apache$batik$apps$svgpp$Main;

    public static void main(String[] stringArray) {
        new Main(stringArray).run();
    }

    public Main(String[] stringArray) {
        this.handlers.put("-doctype", new DoctypeHandler());
        this.handlers.put("-doc-width", new DocWidthHandler());
        this.handlers.put("-newline", new NewlineHandler());
        this.handlers.put("-public-id", new PublicIdHandler());
        this.handlers.put("-no-format", new NoFormatHandler());
        this.handlers.put("-system-id", new SystemIdHandler());
        this.handlers.put("-tab-width", new TabWidthHandler());
        this.handlers.put("-xml-decl", new XMLDeclHandler());
        this.transcoder = new SVGTranscoder();
        this.arguments = stringArray;
    }

    public void run() {
        if (this.arguments.length == 0) {
            this.printUsage();
            return;
        }
        try {
            Object object;
            while ((object = (OptionHandler)this.handlers.get(this.arguments[this.index])) != null) {
                object.handleOption();
            }
            object = new TranscoderInput(new FileReader(this.arguments[this.index++]));
            TranscoderOutput transcoderOutput = this.index < this.arguments.length ? new TranscoderOutput(new FileWriter(this.arguments[this.index])) : new TranscoderOutput(new OutputStreamWriter(System.out));
            this.transcoder.transcode((TranscoderInput)object, transcoderOutput);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printUsage();
        }
    }

    protected void printUsage() {
        this.printHeader();
        System.out.println(localizableSupport.formatMessage("syntax", null));
        System.out.println();
        System.out.println(localizableSupport.formatMessage("options", null));
        Iterator iterator = this.handlers.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            System.out.println(((OptionHandler)this.handlers.get(string)).getDescription());
        }
    }

    protected void printHeader() {
        System.out.println(localizableSupport.formatMessage("header", null));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class DocWidthHandler
    implements OptionHandler {
        protected DocWidthHandler() {
        }

        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_DOCUMENT_WIDTH, new Integer(Main.this.arguments[Main.this.index++]));
        }

        public String getDescription() {
            return localizableSupport.formatMessage("doc-width.description", null);
        }
    }

    protected class TabWidthHandler
    implements OptionHandler {
        protected TabWidthHandler() {
        }

        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_TABULATION_WIDTH, new Integer(Main.this.arguments[Main.this.index++]));
        }

        public String getDescription() {
            return localizableSupport.formatMessage("tab-width.description", null);
        }
    }

    protected class XMLDeclHandler
    implements OptionHandler {
        protected XMLDeclHandler() {
        }

        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            String string = Main.this.arguments[Main.this.index++];
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_XML_DECLARATION, string);
        }

        public String getDescription() {
            return localizableSupport.formatMessage("xml-decl.description", null);
        }
    }

    protected class SystemIdHandler
    implements OptionHandler {
        protected SystemIdHandler() {
        }

        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            String string = Main.this.arguments[Main.this.index++];
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_SYSTEM_ID, string);
        }

        public String getDescription() {
            return localizableSupport.formatMessage("system-id.description", null);
        }
    }

    protected class PublicIdHandler
    implements OptionHandler {
        protected PublicIdHandler() {
        }

        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            String string = Main.this.arguments[Main.this.index++];
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_PUBLIC_ID, string);
        }

        public String getDescription() {
            return localizableSupport.formatMessage("public-id.description", null);
        }
    }

    protected class NoFormatHandler
    implements OptionHandler {
        protected NoFormatHandler() {
        }

        public void handleOption() {
            ++Main.this.index;
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_FORMAT, Boolean.FALSE);
        }

        public String getDescription() {
            return localizableSupport.formatMessage("no-format.description", null);
        }
    }

    protected class NewlineHandler
    implements OptionHandler {
        protected final Map values = new HashMap(6);

        protected NewlineHandler() {
            this.values.put("cr", SVGTranscoder.VALUE_NEWLINE_CR);
            this.values.put("cr-lf", SVGTranscoder.VALUE_NEWLINE_CR_LF);
            this.values.put("lf", SVGTranscoder.VALUE_NEWLINE_LF);
        }

        public void handleOption() {
            Object v2;
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            if ((v2 = this.values.get(Main.this.arguments[Main.this.index++])) == null) {
                throw new IllegalArgumentException();
            }
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_NEWLINE, v2);
        }

        public String getDescription() {
            return localizableSupport.formatMessage("newline.description", null);
        }
    }

    protected class DoctypeHandler
    implements OptionHandler {
        protected final Map values = new HashMap(6);

        protected DoctypeHandler() {
            this.values.put("remove", SVGTranscoder.VALUE_DOCTYPE_REMOVE);
            this.values.put("change", SVGTranscoder.VALUE_DOCTYPE_CHANGE);
        }

        public void handleOption() {
            Object v2;
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            if ((v2 = this.values.get(Main.this.arguments[Main.this.index++])) == null) {
                throw new IllegalArgumentException();
            }
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_DOCTYPE, v2);
        }

        public String getDescription() {
            return localizableSupport.formatMessage("doctype.description", null);
        }
    }

    protected static interface OptionHandler {
        public void handleOption();

        public String getDescription();
    }
}

