/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.MarkerBridge;
import org.apache.batik.bridge.PaintBridge;
import org.apache.batik.bridge.SVGColorProfileElementBridge;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.ICCColor;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.Marker;
import org.apache.batik.gvt.MarkerShapePainter;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;
import org.apache.batik.util.CSSConstants;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;

public abstract class PaintServer
implements SVGConstants,
CSSConstants,
ErrorConstants {
    protected PaintServer() {
    }

    public static ShapePainter convertMarkers(Element element, ShapeNode shapeNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 36);
        Marker marker = PaintServer.convertMarker(element, value, bridgeContext);
        value = CSSUtilities.getComputedStyle(element, 35);
        Marker marker2 = PaintServer.convertMarker(element, value, bridgeContext);
        value = CSSUtilities.getComputedStyle(element, 34);
        Marker marker3 = PaintServer.convertMarker(element, value, bridgeContext);
        if (marker != null || marker2 != null || marker3 != null) {
            MarkerShapePainter markerShapePainter = new MarkerShapePainter(shapeNode.getShape());
            markerShapePainter.setStartMarker(marker);
            markerShapePainter.setMiddleMarker(marker2);
            markerShapePainter.setEndMarker(marker3);
            return markerShapePainter;
        }
        return null;
    }

    public static Marker convertMarker(Element element, Value value, BridgeContext bridgeContext) {
        if (value.getPrimitiveType() == 21) {
            return null;
        }
        String string = value.getStringValue();
        Element element2 = bridgeContext.getReferencedElement(element, string);
        Bridge bridge = bridgeContext.getBridge(element2);
        if (bridge == null || !(bridge instanceof MarkerBridge)) {
            throw new BridgeException(bridgeContext, element, "css.uri.badTarget", new Object[]{string});
        }
        return ((MarkerBridge)bridge).createMarker(bridgeContext, element2, element);
    }

    public static ShapePainter convertFillAndStroke(Element element, ShapeNode shapeNode, BridgeContext bridgeContext) {
        Shape shape = shapeNode.getShape();
        if (shape == null) {
            return null;
        }
        Paint paint = PaintServer.convertFillPaint(element, shapeNode, bridgeContext);
        FillShapePainter fillShapePainter = new FillShapePainter(shape);
        fillShapePainter.setPaint(paint);
        Stroke stroke = PaintServer.convertStroke(element);
        if (stroke == null) {
            return fillShapePainter;
        }
        Paint paint2 = PaintServer.convertStrokePaint(element, shapeNode, bridgeContext);
        StrokeShapePainter strokeShapePainter = new StrokeShapePainter(shape);
        strokeShapePainter.setStroke(stroke);
        strokeShapePainter.setPaint(paint2);
        CompositeShapePainter compositeShapePainter = new CompositeShapePainter(shape);
        compositeShapePainter.addShapePainter(fillShapePainter);
        compositeShapePainter.addShapePainter(strokeShapePainter);
        return compositeShapePainter;
    }

    public static ShapePainter convertStrokePainter(Element element, ShapeNode shapeNode, BridgeContext bridgeContext) {
        Shape shape = shapeNode.getShape();
        if (shape == null) {
            return null;
        }
        Stroke stroke = PaintServer.convertStroke(element);
        if (stroke == null) {
            return null;
        }
        Paint paint = PaintServer.convertStrokePaint(element, shapeNode, bridgeContext);
        StrokeShapePainter strokeShapePainter = new StrokeShapePainter(shape);
        strokeShapePainter.setStroke(stroke);
        strokeShapePainter.setPaint(paint);
        return strokeShapePainter;
    }

    public static Paint convertStrokePaint(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 51);
        float f2 = PaintServer.convertOpacity(value);
        value = CSSUtilities.getComputedStyle(element, 45);
        return PaintServer.convertPaint(element, graphicsNode, value, f2, bridgeContext);
    }

    public static Paint convertFillPaint(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 16);
        float f2 = PaintServer.convertOpacity(value);
        value = CSSUtilities.getComputedStyle(element, 15);
        return PaintServer.convertPaint(element, graphicsNode, value, f2, bridgeContext);
    }

    public static Paint convertPaint(Element element, GraphicsNode graphicsNode, Value value, float f2, BridgeContext bridgeContext) {
        if (value.getCssValueType() == 1) {
            switch (value.getPrimitiveType()) {
                case 21: {
                    return null;
                }
                case 25: {
                    return PaintServer.convertColor(value, f2);
                }
                case 20: {
                    return PaintServer.convertURIPaint(element, graphicsNode, value, f2, bridgeContext);
                }
            }
            throw new IllegalArgumentException("Paint argument is not an appropriate CSS value");
        }
        Value value2 = value.item(0);
        switch (value2.getPrimitiveType()) {
            case 25: {
                return PaintServer.convertRGBICCColor(element, value2, (ICCColor)value.item(1), f2, bridgeContext);
            }
            case 20: {
                Paint paint = PaintServer.silentConvertURIPaint(element, graphicsNode, value2, f2, bridgeContext);
                if (paint != null) {
                    return paint;
                }
                value2 = value.item(1);
                switch (value2.getPrimitiveType()) {
                    case 21: {
                        return null;
                    }
                    case 25: {
                        if (value.getLength() == 2) {
                            return PaintServer.convertColor(value2, f2);
                        }
                        return PaintServer.convertRGBICCColor(element, value2, (ICCColor)value.item(2), f2, bridgeContext);
                    }
                }
                throw new IllegalArgumentException("Paint argument is not an appropriate CSS value");
            }
        }
        throw new IllegalArgumentException("Paint argument is not an appropriate CSS value");
    }

    public static Paint silentConvertURIPaint(Element element, GraphicsNode graphicsNode, Value value, float f2, BridgeContext bridgeContext) {
        Paint paint = null;
        try {
            paint = PaintServer.convertURIPaint(element, graphicsNode, value, f2, bridgeContext);
        }
        catch (BridgeException bridgeException) {
            // empty catch block
        }
        return paint;
    }

    public static Paint convertURIPaint(Element element, GraphicsNode graphicsNode, Value value, float f2, BridgeContext bridgeContext) {
        String string = value.getStringValue();
        Element element2 = bridgeContext.getReferencedElement(element, string);
        Bridge bridge = bridgeContext.getBridge(element2);
        if (bridge == null || !(bridge instanceof PaintBridge)) {
            throw new BridgeException(bridgeContext, element, "css.uri.badTarget", new Object[]{string});
        }
        return ((PaintBridge)bridge).createPaint(bridgeContext, element2, element, graphicsNode, f2);
    }

    public static Color convertRGBICCColor(Element element, Value value, ICCColor iCCColor, float f2, BridgeContext bridgeContext) {
        Color color = null;
        if (iCCColor != null) {
            color = PaintServer.convertICCColor(element, iCCColor, f2, bridgeContext);
        }
        if (color == null) {
            color = PaintServer.convertColor(value, f2);
        }
        return color;
    }

    public static Color convertICCColor(Element element, ICCColor iCCColor, float f2, BridgeContext bridgeContext) {
        String string = iCCColor.getColorProfile();
        if (string == null) {
            return null;
        }
        SVGColorProfileElementBridge sVGColorProfileElementBridge = (SVGColorProfileElementBridge)bridgeContext.getBridge("http://www.w3.org/2000/svg", "color-profile");
        if (sVGColorProfileElementBridge == null) {
            return null;
        }
        ICCColorSpaceExt iCCColorSpaceExt = sVGColorProfileElementBridge.createICCColorSpaceExt(bridgeContext, element, string);
        if (iCCColorSpaceExt == null) {
            return null;
        }
        int n2 = iCCColor.getNumberOfColors();
        float[] fArray = new float[n2];
        if (n2 == 0) {
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = iCCColor.getColor(i2);
        }
        float[] fArray2 = iCCColorSpaceExt.intendedToRGB(fArray);
        return new Color(fArray2[0], fArray2[1], fArray2[2], f2);
    }

    public static Color convertColor(Value value, float f2) {
        int n2 = PaintServer.resolveColorComponent(value.getRed());
        int n3 = PaintServer.resolveColorComponent(value.getGreen());
        int n4 = PaintServer.resolveColorComponent(value.getBlue());
        return new Color(n2, n3, n4, Math.round(f2 * 255.0f));
    }

    public static Stroke convertStroke(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 52);
        float f2 = value.getFloatValue();
        if (f2 == 0.0f) {
            return null;
        }
        value = CSSUtilities.getComputedStyle(element, 48);
        int n2 = PaintServer.convertStrokeLinecap(value);
        value = CSSUtilities.getComputedStyle(element, 49);
        int n3 = PaintServer.convertStrokeLinejoin(value);
        value = CSSUtilities.getComputedStyle(element, 50);
        float f3 = PaintServer.convertStrokeMiterlimit(value);
        value = CSSUtilities.getComputedStyle(element, 46);
        float[] fArray = PaintServer.convertStrokeDasharray(value);
        float f4 = 0.0f;
        if (fArray != null && (f4 = (value = CSSUtilities.getComputedStyle(element, 47)).getFloatValue()) < 0.0f) {
            float f5 = 0.0f;
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                f5 += fArray[i2];
            }
            if (fArray.length % 2 != 0) {
                f5 *= 2.0f;
            }
            if (f5 == 0.0f) {
                f4 = 0.0f;
            } else {
                while (f4 < 0.0f) {
                    f4 += f5;
                }
            }
        }
        return new BasicStroke(f2, n2, n3, f3, fArray, f4);
    }

    public static float[] convertStrokeDasharray(Value value) {
        float[] fArray = null;
        if (value.getCssValueType() == 2) {
            int n2 = value.getLength();
            fArray = new float[n2];
            float f2 = 0.0f;
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                fArray[i2] = value.item(i2).getFloatValue();
                f2 += fArray[i2];
            }
            if (f2 == 0.0f) {
                fArray = null;
            }
        }
        return fArray;
    }

    public static float convertStrokeMiterlimit(Value value) {
        float f2 = value.getFloatValue();
        return f2 < 1.0f ? 1.0f : f2;
    }

    public static int convertStrokeLinecap(Value value) {
        String string = value.getStringValue();
        switch (string.charAt(0)) {
            case 'b': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 's': {
                return 2;
            }
        }
        throw new IllegalArgumentException("Linecap argument is not an appropriate CSS value");
    }

    public static int convertStrokeLinejoin(Value value) {
        String string = value.getStringValue();
        switch (string.charAt(0)) {
            case 'm': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 'b': {
                return 2;
            }
        }
        throw new IllegalArgumentException("Linejoin argument is not an appropriate CSS value");
    }

    public static int resolveColorComponent(Value value) {
        switch (value.getPrimitiveType()) {
            case 2: {
                float f2 = value.getFloatValue();
                f2 = f2 > 100.0f ? 100.0f : (f2 < 0.0f ? 0.0f : f2);
                return Math.round(255.0f * f2 / 100.0f);
            }
            case 1: {
                float f3 = value.getFloatValue();
                f3 = f3 > 255.0f ? 255.0f : (f3 < 0.0f ? 0.0f : f3);
                return Math.round(f3);
            }
        }
        throw new IllegalArgumentException("Color component argument is not an appropriate CSS value");
    }

    public static float convertOpacity(Value value) {
        float f2 = value.getFloatValue();
        return f2 < 0.0f ? 0.0f : (f2 > 1.0f ? 1.0f : f2);
    }
}

