/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.ArrayList;
import org.apache.batik.anim.AbstractAnimation;
import org.apache.batik.anim.SimpleAnimation;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGAnimationElementBridge;
import org.apache.batik.dom.anim.AnimationTarget;

public class SVGAnimateElementBridge
extends SVGAnimationElementBridge {
    public String getLocalName() {
        return "animate";
    }

    public Bridge getInstance() {
        return new SVGAnimateElementBridge();
    }

    protected AbstractAnimation createAnimation(AnimationTarget animationTarget) {
        AnimatableValue animatableValue = this.parseAnimatableValue("from");
        AnimatableValue animatableValue2 = this.parseAnimatableValue("to");
        AnimatableValue animatableValue3 = this.parseAnimatableValue("by");
        return new SimpleAnimation(this.timedElement, this, this.parseCalcMode(), this.parseKeyTimes(), this.parseKeySplines(), this.parseAdditive(), this.parseAccumulate(), this.parseValues(), animatableValue, animatableValue2, animatableValue3);
    }

    protected int parseCalcMode() {
        if (this.animationType == 1 && !this.targetElement.isPropertyAdditive(this.attributeLocalName) || this.animationType == 0 && !this.targetElement.isAttributeAdditive(this.attributeNamespaceURI, this.attributeLocalName)) {
            return 0;
        }
        String string = this.element.getAttributeNS(null, "calcMode");
        if (string.length() == 0) {
            return this.getDefaultCalcMode();
        }
        if (string.equals("linear")) {
            return 1;
        }
        if (string.equals("discrete")) {
            return 0;
        }
        if (string.equals("paced")) {
            return 2;
        }
        if (string.equals("spline")) {
            return 3;
        }
        throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"calcMode", string});
    }

    protected boolean parseAdditive() {
        String string = this.element.getAttributeNS(null, "additive");
        if (string.length() == 0 || string.equals("replace")) {
            return false;
        }
        if (string.equals("sum")) {
            return true;
        }
        throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"additive", string});
    }

    protected boolean parseAccumulate() {
        String string = this.element.getAttributeNS(null, "accumulate");
        if (string.length() == 0 || string.equals("none")) {
            return false;
        }
        if (string.equals("sum")) {
            return true;
        }
        throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"accumulate", string});
    }

    protected AnimatableValue[] parseValues() {
        Object object;
        boolean bl = this.animationType == 1;
        String string = this.element.getAttributeNS(null, "values");
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        ArrayList<AnimatableValue[]> arrayList = new ArrayList<AnimatableValue[]>(7);
        int n3 = 0;
        int n4 = 0;
        block0: while (n3 < n2) {
            int n5;
            while (string.charAt(n3) == ' ') {
                if (++n3 != n2) continue;
                break block0;
            }
            n4 = n3++;
            if (n3 != n2) {
                char c2 = string.charAt(n3);
                while (c2 != ';' && ++n3 != n2) {
                    c2 = string.charAt(n3);
                }
            }
            if (!this.checkValueType((AnimatableValue)(object = this.eng.parseAnimatableValue(this.element, this.animationTarget, this.attributeNamespaceURI, this.attributeLocalName, bl, string.substring(n4, n5 = n3++))))) {
                throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"values", string});
            }
            arrayList.add((AnimatableValue[])object);
        }
        object = new AnimatableValue[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    protected float[] parseKeyTimes() {
        String string = this.element.getAttributeNS(null, "keyTimes");
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>(7);
        int n3 = 0;
        int n4 = 0;
        block2: while (n3 < n2) {
            while (string.charAt(n3) == ' ') {
                if (++n3 != n2) continue;
                break block2;
            }
            n4 = n3++;
            if (n3 != n2) {
                char c2 = string.charAt(n3);
                while (c2 != ' ' && c2 != ';' && ++n3 != n2) {
                    c2 = string.charAt(n3);
                }
            }
            int n5 = n3++;
            try {
                float f2 = Float.parseFloat(string.substring(n4, n5));
                arrayList.add(new Float(f2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(this.ctx, this.element, numberFormatException, "attribute.malformed", new Object[]{"keyTimes", string});
            }
        }
        n2 = arrayList.size();
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = ((Float)arrayList.get(i2)).floatValue();
        }
        return fArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected float[] parseKeySplines() {
        String string = this.element.getAttributeNS(null, "keySplines");
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>(7);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        block2: while (n4 < n2) {
            int n6;
            while (string.charAt(n4) == ' ') {
                if (++n4 != n2) continue;
                break block2;
            }
            n5 = n4++;
            if (n4 != n2) {
                char c2 = string.charAt(n4);
                while (c2 != ' ' && c2 != ',' && c2 != ';' && ++n4 != n2) {
                    c2 = string.charAt(n4);
                }
                n6 = n4++;
                if (c2 == ' ') {
                    while (n4 != n2 && (c2 = string.charAt(n4++)) == ' ') {
                    }
                    if (c2 != ';' && c2 != ',') {
                        --n4;
                    }
                }
                if (c2 == ';') {
                    if (n3 != 3) throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"keySplines", string});
                    n3 = 0;
                } else {
                    ++n3;
                }
            } else {
                n6 = n4++;
            }
            try {
                float f2 = Float.parseFloat(string.substring(n5, n6));
                arrayList.add(new Float(f2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(this.ctx, this.element, numberFormatException, "attribute.malformed", new Object[]{"keySplines", string});
            }
        }
        n2 = arrayList.size();
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = ((Float)arrayList.get(i2)).floatValue();
        }
        return fArray;
    }

    protected int getDefaultCalcMode() {
        return 1;
    }

    protected boolean canAnimateType(int n2) {
        return true;
    }
}

