/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.TurbulenceRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeTurbulenceElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    public String getLocalName() {
        return "feTurbulence";
    }

    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map map) {
        Filter filter2 = SVGFeTurbulenceElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = rectangle2D;
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        float[] fArray = SVGFeTurbulenceElementBridge.convertBaseFrenquency(element, bridgeContext);
        int n2 = SVGFeTurbulenceElementBridge.convertInteger(element, "numOctaves", 1, bridgeContext);
        int n3 = SVGFeTurbulenceElementBridge.convertInteger(element, "seed", 0, bridgeContext);
        boolean bl = SVGFeTurbulenceElementBridge.convertStitchTiles(element, bridgeContext);
        boolean bl2 = SVGFeTurbulenceElementBridge.convertType(element, bridgeContext);
        TurbulenceRable8Bit turbulenceRable8Bit = new TurbulenceRable8Bit(rectangle2D3);
        turbulenceRable8Bit.setBaseFrequencyX(fArray[0]);
        turbulenceRable8Bit.setBaseFrequencyY(fArray[1]);
        turbulenceRable8Bit.setNumOctaves(n2);
        turbulenceRable8Bit.setSeed(n3);
        turbulenceRable8Bit.setStitched(bl);
        turbulenceRable8Bit.setFractalNoise(bl2);
        SVGFeTurbulenceElementBridge.handleColorInterpolationFilters(turbulenceRable8Bit, element);
        SVGFeTurbulenceElementBridge.updateFilterMap(element, turbulenceRable8Bit, map);
        return turbulenceRable8Bit;
    }

    protected static float[] convertBaseFrenquency(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "baseFrequency");
        if (string.length() == 0) {
            return new float[]{0.001f, 0.001f};
        }
        float[] fArray = new float[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        try {
            fArray[0] = SVGUtilities.convertSVGNumber(stringTokenizer.nextToken());
            fArray[1] = stringTokenizer.hasMoreTokens() ? SVGUtilities.convertSVGNumber(stringTokenizer.nextToken()) : fArray[0];
            if (stringTokenizer.hasMoreTokens()) {
                throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"baseFrequency", string});
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"baseFrequency", string});
        }
        if (fArray[0] < 0.0f || fArray[1] < 0.0f) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"baseFrequency", string});
        }
        return fArray;
    }

    protected static boolean convertStitchTiles(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "stitchTiles");
        if (string.length() == 0) {
            return false;
        }
        if ("stitch".equals(string)) {
            return true;
        }
        if ("noStitch".equals(string)) {
            return false;
        }
        throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"stitchTiles", string});
    }

    protected static boolean convertType(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "type");
        if (string.length() == 0) {
            return false;
        }
        if ("fractalNoise".equals(string)) {
            return true;
        }
        if ("turbulence".equals(string)) {
            return false;
        }
        throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"type", string});
    }
}

