/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.lang.ref.SoftReference;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.SVGFontElementBridge;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFace;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGFontFamily
implements GVTFontFamily {
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_ID = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_ID;
    protected GVTFontFace fontFace;
    protected Element fontElement;
    protected BridgeContext ctx;
    protected Boolean complex = null;

    public SVGFontFamily(GVTFontFace gVTFontFace, Element element, BridgeContext bridgeContext) {
        this.fontFace = gVTFontFace;
        this.fontElement = element;
        this.ctx = bridgeContext;
    }

    public String getFamilyName() {
        return this.fontFace.getFamilyName();
    }

    public GVTFontFace getFontFace() {
        return this.fontFace;
    }

    public GVTFont deriveFont(float f2, AttributedCharacterIterator attributedCharacterIterator) {
        return this.deriveFont(f2, attributedCharacterIterator.getAttributes());
    }

    public GVTFont deriveFont(float f2, Map map) {
        SVGFontElementBridge sVGFontElementBridge = (SVGFontElementBridge)this.ctx.getBridge(this.fontElement);
        SoftReference softReference = (SoftReference)map.get(TEXT_COMPOUND_ID);
        Element element = (Element)softReference.get();
        return sVGFontElementBridge.createFont(this.ctx, this.fontElement, element, f2, this.fontFace);
    }

    public boolean isComplex() {
        if (this.complex != null) {
            return this.complex;
        }
        boolean bl = SVGFontFamily.isComplex(this.fontElement, this.ctx);
        this.complex = bl ? Boolean.TRUE : Boolean.FALSE;
        return bl;
    }

    public static boolean isComplex(Element element, BridgeContext bridgeContext) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/svg", "glyph");
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Element element2 = (Element)nodeList.item(i2);
            for (Node node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element element3;
                Bridge bridge;
                if (node.getNodeType() != 1 || (bridge = bridgeContext.getBridge(element3 = (Element)node)) == null || !(bridge instanceof GraphicsNodeBridge)) continue;
                return true;
            }
        }
        return false;
    }
}

