/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSFontFace;
import org.apache.batik.bridge.FontFace;
import org.apache.batik.bridge.SVGFontFaceElementBridge;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.FontFaceRule;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.gvt.font.GVTFontFace;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.UnresolvedFontFamily;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class SVGFontUtilities
implements SVGConstants {
    public static List getFontFaces(Document document, BridgeContext bridgeContext) {
        Object object;
        Map map = bridgeContext.getFontFamilyMap();
        LinkedList<FontFace> linkedList = (LinkedList<FontFace>)map.get(document);
        if (linkedList != null) {
            return linkedList;
        }
        linkedList = new LinkedList<FontFace>();
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "font-face");
        SVGFontFaceElementBridge sVGFontFaceElementBridge = (SVGFontFaceElementBridge)bridgeContext.getBridge("http://www.w3.org/2000/svg", "font-face");
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            object = (Element)nodeList.item(i2);
            linkedList.add(sVGFontFaceElementBridge.createFontFace(bridgeContext, (Element)object));
        }
        CSSEngine cSSEngine = ((SVGOMDocument)document).getCSSEngine();
        object = cSSEngine.getFontFaces();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            FontFaceRule fontFaceRule = (FontFaceRule)iterator.next();
            linkedList.add(CSSFontFace.createCSSFontFace(cSSEngine, fontFaceRule));
        }
        return linkedList;
    }

    public static GVTFontFamily getFontFamily(Element element, BridgeContext bridgeContext, String string, String string2, String string3) {
        Object object;
        Object object2;
        Object object3;
        String string4 = string.toLowerCase() + " " + string2 + " " + string3;
        Map map = bridgeContext.getFontFamilyMap();
        GVTFontFamily gVTFontFamily = (GVTFontFamily)map.get(string4);
        if (gVTFontFamily != null) {
            return gVTFontFamily;
        }
        Document document = element.getOwnerDocument();
        List list = (List)map.get(document);
        if (list == null) {
            list = SVGFontUtilities.getFontFaces(document, bridgeContext);
            map.put(document, list);
        }
        Iterator iterator = list.iterator();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (iterator.hasNext()) {
            object3 = (FontFace)iterator.next();
            if (!((GVTFontFace)object3).hasFamilyName(string) || !((String)(object2 = ((GVTFontFace)object3).getFontStyle())).equals("all") && ((String)object2).indexOf(string3) == -1 || (object = ((FontFace)object3).getFontFamily(bridgeContext)) == null) continue;
            linkedList.add(object);
        }
        if (linkedList.size() == 1) {
            map.put(string4, linkedList.get(0));
            return (GVTFontFamily)linkedList.get(0);
        }
        if (linkedList.size() > 1) {
            String string5;
            int n2;
            Object object4;
            object3 = SVGFontUtilities.getFontWeightNumberString(string2);
            object2 = new ArrayList(linkedList.size());
            object = linkedList.iterator();
            while (object.hasNext()) {
                object4 = ((GVTFontFamily)object.next()).getFontFace();
                String string6 = ((GVTFontFace)object4).getFontWeight();
                string6 = SVGFontUtilities.getFontWeightNumberString(string6);
                object2.add(string6);
            }
            object4 = new ArrayList(object2);
            for (n2 = 100; n2 <= 900; n2 += 100) {
                string5 = String.valueOf(n2);
                boolean bl = false;
                int n3 = 1000;
                int n4 = 0;
                for (int i2 = 0; i2 < object2.size(); ++i2) {
                    String string7 = (String)object2.get(i2);
                    if (string7.indexOf(string5) > -1) {
                        bl = true;
                        break;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string7, " ,");
                    while (stringTokenizer.hasMoreTokens()) {
                        int n5 = Integer.parseInt(stringTokenizer.nextToken());
                        int n6 = Math.abs(n5 - n2);
                        if (n6 >= n3) continue;
                        n3 = n6;
                        n4 = i2;
                    }
                }
                if (bl) continue;
                String string8 = object4.get(n4) + ", " + string5;
                object4.set(n4, string8);
            }
            for (n2 = 0; n2 < linkedList.size(); ++n2) {
                string5 = (String)object4.get(n2);
                if (string5.indexOf((String)object3) <= -1) continue;
                map.put(string4, linkedList.get(n2));
                return (GVTFontFamily)linkedList.get(n2);
            }
            map.put(string4, linkedList.get(0));
            return (GVTFontFamily)linkedList.get(0);
        }
        object3 = new UnresolvedFontFamily(string);
        map.put(string4, object3);
        return object3;
    }

    protected static String getFontWeightNumberString(String string) {
        if (string.equals("normal")) {
            return "400";
        }
        if (string.equals("bold")) {
            return "700";
        }
        if (string.equals("all")) {
            return "100, 200, 300, 400, 500, 600, 700, 800, 900";
        }
        return string;
    }
}

