/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class XBLShadowTreeElementBridge
extends AbstractGraphicsNodeBridge {
    public String getLocalName() {
        return "shadowTree";
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/2004/xbl";
    }

    public Bridge getInstance() {
        return new XBLShadowTreeElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        this.associateSVGContext(bridgeContext, element, compositeGraphicsNode);
        return compositeGraphicsNode;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
    }

    public boolean getDisplay(Element element) {
        return true;
    }

    public boolean isComposite() {
        return true;
    }

    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
        if (mutationEvent.getTarget() instanceof Element) {
            this.handleElementAdded((CompositeGraphicsNode)this.node, this.e, (Element)((Object)mutationEvent.getTarget()));
        }
    }

    public void handleElementAdded(CompositeGraphicsNode compositeGraphicsNode, Node node, Element element) {
        GVTBuilder gVTBuilder = this.ctx.getGVTBuilder();
        GraphicsNode graphicsNode = gVTBuilder.build(this.ctx, element);
        if (graphicsNode == null) {
            return;
        }
        int n2 = -1;
        for (Node node2 = element.getPreviousSibling(); node2 != null; node2 = node2.getPreviousSibling()) {
            GraphicsNode graphicsNode2;
            if (node2.getNodeType() != 1) continue;
            Element element2 = (Element)node2;
            for (graphicsNode2 = this.ctx.getGraphicsNode(element2); graphicsNode2 != null && graphicsNode2.getParent() != compositeGraphicsNode; graphicsNode2 = graphicsNode2.getParent()) {
            }
            if (graphicsNode2 != null && (n2 = compositeGraphicsNode.indexOf(graphicsNode2)) != -1) break;
        }
        compositeGraphicsNode.add(++n2, graphicsNode);
    }
}

