/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.dom;

import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.StringValue;
import org.apache.batik.css.engine.value.Value;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class CSSOMValue
implements CSSPrimitiveValue,
CSSValueList,
Counter,
Rect,
RGBColor {
    protected ValueProvider valueProvider;
    protected ModificationHandler handler;
    protected LeftComponent leftComponent;
    protected RightComponent rightComponent;
    protected BottomComponent bottomComponent;
    protected TopComponent topComponent;
    protected RedComponent redComponent;
    protected GreenComponent greenComponent;
    protected BlueComponent blueComponent;
    protected CSSValue[] items;

    public CSSOMValue(ValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    public void setModificationHandler(ModificationHandler modificationHandler) {
        this.handler = modificationHandler;
    }

    public String getCssText() {
        return this.valueProvider.getValue().getCssText();
    }

    public void setCssText(String string) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.textChanged(string);
    }

    public short getCssValueType() {
        return this.valueProvider.getValue().getCssValueType();
    }

    public short getPrimitiveType() {
        return this.valueProvider.getValue().getPrimitiveType();
    }

    public void setFloatValue(short s2, float f2) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.floatValueChanged(s2, f2);
    }

    public float getFloatValue(short s2) throws DOMException {
        return CSSOMValue.convertFloatValue(s2, this.valueProvider.getValue());
    }

    public static float convertFloatValue(short s2, Value value) {
        switch (s2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 18: {
                if (value.getPrimitiveType() != s2) break;
                return value.getFloatValue();
            }
            case 6: {
                return CSSOMValue.toCentimeters(value);
            }
            case 7: {
                return CSSOMValue.toMillimeters(value);
            }
            case 8: {
                return CSSOMValue.toInches(value);
            }
            case 9: {
                return CSSOMValue.toPoints(value);
            }
            case 10: {
                return CSSOMValue.toPicas(value);
            }
            case 11: {
                return CSSOMValue.toDegrees(value);
            }
            case 12: {
                return CSSOMValue.toRadians(value);
            }
            case 13: {
                return CSSOMValue.toGradians(value);
            }
            case 14: {
                return CSSOMValue.toMilliseconds(value);
            }
            case 15: {
                return CSSOMValue.toSeconds(value);
            }
            case 16: {
                return CSSOMValue.toHertz(value);
            }
            case 17: {
                return CSSOMValue.tokHertz(value);
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toCentimeters(Value value) {
        switch (value.getPrimitiveType()) {
            case 6: {
                return value.getFloatValue();
            }
            case 7: {
                return value.getFloatValue() / 10.0f;
            }
            case 8: {
                return value.getFloatValue() * 2.54f;
            }
            case 9: {
                return value.getFloatValue() * 2.54f / 72.0f;
            }
            case 10: {
                return value.getFloatValue() * 2.54f / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toInches(Value value) {
        switch (value.getPrimitiveType()) {
            case 6: {
                return value.getFloatValue() / 2.54f;
            }
            case 7: {
                return value.getFloatValue() / 25.4f;
            }
            case 8: {
                return value.getFloatValue();
            }
            case 9: {
                return value.getFloatValue() / 72.0f;
            }
            case 10: {
                return value.getFloatValue() / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toMillimeters(Value value) {
        switch (value.getPrimitiveType()) {
            case 6: {
                return value.getFloatValue() * 10.0f;
            }
            case 7: {
                return value.getFloatValue();
            }
            case 8: {
                return value.getFloatValue() * 25.4f;
            }
            case 9: {
                return value.getFloatValue() * 25.4f / 72.0f;
            }
            case 10: {
                return value.getFloatValue() * 25.4f / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toPoints(Value value) {
        switch (value.getPrimitiveType()) {
            case 6: {
                return value.getFloatValue() * 72.0f / 2.54f;
            }
            case 7: {
                return value.getFloatValue() * 72.0f / 25.4f;
            }
            case 8: {
                return value.getFloatValue() * 72.0f;
            }
            case 9: {
                return value.getFloatValue();
            }
            case 10: {
                return value.getFloatValue() * 12.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toPicas(Value value) {
        switch (value.getPrimitiveType()) {
            case 6: {
                return value.getFloatValue() * 6.0f / 2.54f;
            }
            case 7: {
                return value.getFloatValue() * 6.0f / 25.4f;
            }
            case 8: {
                return value.getFloatValue() * 6.0f;
            }
            case 9: {
                return value.getFloatValue() / 12.0f;
            }
            case 10: {
                return value.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toDegrees(Value value) {
        switch (value.getPrimitiveType()) {
            case 11: {
                return value.getFloatValue();
            }
            case 12: {
                return (float)Math.toDegrees(value.getFloatValue());
            }
            case 13: {
                return value.getFloatValue() * 9.0f / 5.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toRadians(Value value) {
        switch (value.getPrimitiveType()) {
            case 11: {
                return value.getFloatValue() * 5.0f / 9.0f;
            }
            case 12: {
                return value.getFloatValue();
            }
            case 13: {
                return (float)((double)(value.getFloatValue() * 100.0f) / Math.PI);
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toGradians(Value value) {
        switch (value.getPrimitiveType()) {
            case 11: {
                return (float)((double)value.getFloatValue() * Math.PI / 180.0);
            }
            case 12: {
                return (float)((double)value.getFloatValue() * Math.PI / 100.0);
            }
            case 13: {
                return value.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toMilliseconds(Value value) {
        switch (value.getPrimitiveType()) {
            case 14: {
                return value.getFloatValue();
            }
            case 15: {
                return value.getFloatValue() * 1000.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toSeconds(Value value) {
        switch (value.getPrimitiveType()) {
            case 14: {
                return value.getFloatValue() / 1000.0f;
            }
            case 15: {
                return value.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toHertz(Value value) {
        switch (value.getPrimitiveType()) {
            case 16: {
                return value.getFloatValue();
            }
            case 17: {
                return value.getFloatValue() / 1000.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float tokHertz(Value value) {
        switch (value.getPrimitiveType()) {
            case 16: {
                return value.getFloatValue() * 1000.0f;
            }
            case 17: {
                return value.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    public void setStringValue(short s2, String string) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.stringValueChanged(s2, string);
    }

    public String getStringValue() throws DOMException {
        return this.valueProvider.getValue().getStringValue();
    }

    public Counter getCounterValue() throws DOMException {
        return this;
    }

    public Rect getRectValue() throws DOMException {
        return this;
    }

    public RGBColor getRGBColorValue() throws DOMException {
        return this;
    }

    public int getLength() {
        return this.valueProvider.getValue().getLength();
    }

    public CSSValue item(int n2) {
        Object object;
        int n3 = this.valueProvider.getValue().getLength();
        if (n2 < 0 || n2 >= n3) {
            return null;
        }
        if (this.items == null) {
            this.items = new CSSValue[this.valueProvider.getValue().getLength()];
        } else if (this.items.length < n3) {
            object = new CSSValue[n3];
            System.arraycopy(this.items, 0, object, 0, this.items.length);
            this.items = object;
        }
        object = this.items[n2];
        if (object == null) {
            object = new ListComponent(n2);
            this.items[n2] = object;
        }
        return object;
    }

    public String getIdentifier() {
        return this.valueProvider.getValue().getIdentifier();
    }

    public String getListStyle() {
        return this.valueProvider.getValue().getListStyle();
    }

    public String getSeparator() {
        return this.valueProvider.getValue().getSeparator();
    }

    public CSSPrimitiveValue getTop() {
        this.valueProvider.getValue().getTop();
        if (this.topComponent == null) {
            this.topComponent = new TopComponent();
        }
        return this.topComponent;
    }

    public CSSPrimitiveValue getRight() {
        this.valueProvider.getValue().getRight();
        if (this.rightComponent == null) {
            this.rightComponent = new RightComponent();
        }
        return this.rightComponent;
    }

    public CSSPrimitiveValue getBottom() {
        this.valueProvider.getValue().getBottom();
        if (this.bottomComponent == null) {
            this.bottomComponent = new BottomComponent();
        }
        return this.bottomComponent;
    }

    public CSSPrimitiveValue getLeft() {
        this.valueProvider.getValue().getLeft();
        if (this.leftComponent == null) {
            this.leftComponent = new LeftComponent();
        }
        return this.leftComponent;
    }

    public CSSPrimitiveValue getRed() {
        this.valueProvider.getValue().getRed();
        if (this.redComponent == null) {
            this.redComponent = new RedComponent();
        }
        return this.redComponent;
    }

    public CSSPrimitiveValue getGreen() {
        this.valueProvider.getValue().getGreen();
        if (this.greenComponent == null) {
            this.greenComponent = new GreenComponent();
        }
        return this.greenComponent;
    }

    public CSSPrimitiveValue getBlue() {
        this.valueProvider.getValue().getBlue();
        if (this.blueComponent == null) {
            this.blueComponent = new BlueComponent();
        }
        return this.blueComponent;
    }

    protected class ListComponent
    extends AbstractComponent {
        protected int index;

        public ListComponent(int n2) {
            this.index = n2;
        }

        protected Value getValue() {
            if (this.index >= CSSOMValue.this.valueProvider.getValue().getLength()) {
                throw new DOMException(7, "");
            }
            return CSSOMValue.this.valueProvider.getValue().item(this.index);
        }

        public void setCssText(String string) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.listTextChanged(this.index, string);
        }

        public void setFloatValue(short s2, float f2) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.listFloatValueChanged(this.index, s2, f2);
        }

        public void setStringValue(short s2, String string) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.listStringValueChanged(this.index, s2, string);
        }
    }

    protected class BlueComponent
    extends FloatComponent {
        protected BlueComponent() {
        }

        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getBlue();
        }

        public void setCssText(String string) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.blueTextChanged(string);
        }

        public void setFloatValue(short s2, float f2) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.blueFloatValueChanged(s2, f2);
        }
    }

    protected class GreenComponent
    extends FloatComponent {
        protected GreenComponent() {
        }

        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getGreen();
        }

        public void setCssText(String string) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.greenTextChanged(string);
        }

        public void setFloatValue(short s2, float f2) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.greenFloatValueChanged(s2, f2);
        }
    }

    protected class RedComponent
    extends FloatComponent {
        protected RedComponent() {
        }

        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getRed();
        }

        public void setCssText(String string) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.redTextChanged(string);
        }

        public void setFloatValue(short s2, float f2) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.redFloatValueChanged(s2, f2);
        }
    }

    protected class BottomComponent
    extends FloatComponent {
        protected BottomComponent() {
        }

        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getBottom();
        }

        public void setCssText(String string) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.bottomTextChanged(string);
        }

        public void setFloatValue(short s2, float f2) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.bottomFloatValueChanged(s2, f2);
        }
    }

    protected class RightComponent
    extends FloatComponent {
        protected RightComponent() {
        }

        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getRight();
        }

        public void setCssText(String string) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.rightTextChanged(string);
        }

        public void setFloatValue(short s2, float f2) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.rightFloatValueChanged(s2, f2);
        }
    }

    protected class TopComponent
    extends FloatComponent {
        protected TopComponent() {
        }

        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getTop();
        }

        public void setCssText(String string) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.topTextChanged(string);
        }

        public void setFloatValue(short s2, float f2) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.topFloatValueChanged(s2, f2);
        }
    }

    protected class LeftComponent
    extends FloatComponent {
        protected LeftComponent() {
        }

        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getLeft();
        }

        public void setCssText(String string) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.leftTextChanged(string);
        }

        public void setFloatValue(short s2, float f2) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.leftFloatValueChanged(s2, f2);
        }
    }

    protected abstract class FloatComponent
    extends AbstractComponent {
        protected FloatComponent() {
        }

        public void setStringValue(short s2, String string) throws DOMException {
            throw new DOMException(15, "");
        }
    }

    protected abstract class AbstractComponent
    implements CSSPrimitiveValue {
        protected AbstractComponent() {
        }

        protected abstract Value getValue();

        public String getCssText() {
            return this.getValue().getCssText();
        }

        public short getCssValueType() {
            return this.getValue().getCssValueType();
        }

        public short getPrimitiveType() {
            return this.getValue().getPrimitiveType();
        }

        public float getFloatValue(short s2) throws DOMException {
            return CSSOMValue.convertFloatValue(s2, this.getValue());
        }

        public String getStringValue() throws DOMException {
            return CSSOMValue.this.valueProvider.getValue().getStringValue();
        }

        public Counter getCounterValue() throws DOMException {
            throw new DOMException(15, "");
        }

        public Rect getRectValue() throws DOMException {
            throw new DOMException(15, "");
        }

        public RGBColor getRGBColorValue() throws DOMException {
            throw new DOMException(15, "");
        }

        public int getLength() {
            throw new DOMException(15, "");
        }

        public CSSValue item(int n2) {
            throw new DOMException(15, "");
        }
    }

    public abstract class AbstractModificationHandler
    implements ModificationHandler {
        protected abstract Value getValue();

        public void floatValueChanged(short s2, float f2) throws DOMException {
            this.textChanged(FloatValue.getCssText(s2, f2));
        }

        public void stringValueChanged(short s2, String string) throws DOMException {
            this.textChanged(StringValue.getCssText(s2, string));
        }

        public void leftTextChanged(String string) throws DOMException {
            Value value = this.getValue();
            string = "rect(" + value.getTop().getCssText() + ", " + value.getRight().getCssText() + ", " + value.getBottom().getCssText() + ", " + string + ')';
            this.textChanged(string);
        }

        public void leftFloatValueChanged(short s2, float f2) throws DOMException {
            Value value = this.getValue();
            String string = "rect(" + value.getTop().getCssText() + ", " + value.getRight().getCssText() + ", " + value.getBottom().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ')';
            this.textChanged(string);
        }

        public void topTextChanged(String string) throws DOMException {
            Value value = this.getValue();
            string = "rect(" + string + ", " + value.getRight().getCssText() + ", " + value.getBottom().getCssText() + ", " + value.getLeft().getCssText() + ')';
            this.textChanged(string);
        }

        public void topFloatValueChanged(short s2, float f2) throws DOMException {
            Value value = this.getValue();
            String string = "rect(" + FloatValue.getCssText(s2, f2) + ", " + value.getRight().getCssText() + ", " + value.getBottom().getCssText() + ", " + value.getLeft().getCssText() + ')';
            this.textChanged(string);
        }

        public void rightTextChanged(String string) throws DOMException {
            Value value = this.getValue();
            string = "rect(" + value.getTop().getCssText() + ", " + string + ", " + value.getBottom().getCssText() + ", " + value.getLeft().getCssText() + ')';
            this.textChanged(string);
        }

        public void rightFloatValueChanged(short s2, float f2) throws DOMException {
            Value value = this.getValue();
            String string = "rect(" + value.getTop().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ", " + value.getBottom().getCssText() + ", " + value.getLeft().getCssText() + ')';
            this.textChanged(string);
        }

        public void bottomTextChanged(String string) throws DOMException {
            Value value = this.getValue();
            string = "rect(" + value.getTop().getCssText() + ", " + value.getRight().getCssText() + ", " + string + ", " + value.getLeft().getCssText() + ')';
            this.textChanged(string);
        }

        public void bottomFloatValueChanged(short s2, float f2) throws DOMException {
            Value value = this.getValue();
            String string = "rect(" + value.getTop().getCssText() + ", " + value.getRight().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ", " + value.getLeft().getCssText() + ')';
            this.textChanged(string);
        }

        public void redTextChanged(String string) throws DOMException {
            Value value = this.getValue();
            string = "rgb(" + string + ", " + value.getGreen().getCssText() + ", " + value.getBlue().getCssText() + ')';
            this.textChanged(string);
        }

        public void redFloatValueChanged(short s2, float f2) throws DOMException {
            Value value = this.getValue();
            String string = "rgb(" + FloatValue.getCssText(s2, f2) + ", " + value.getGreen().getCssText() + ", " + value.getBlue().getCssText() + ')';
            this.textChanged(string);
        }

        public void greenTextChanged(String string) throws DOMException {
            Value value = this.getValue();
            string = "rgb(" + value.getRed().getCssText() + ", " + string + ", " + value.getBlue().getCssText() + ')';
            this.textChanged(string);
        }

        public void greenFloatValueChanged(short s2, float f2) throws DOMException {
            Value value = this.getValue();
            String string = "rgb(" + value.getRed().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ", " + value.getBlue().getCssText() + ')';
            this.textChanged(string);
        }

        public void blueTextChanged(String string) throws DOMException {
            Value value = this.getValue();
            string = "rgb(" + value.getRed().getCssText() + ", " + value.getGreen().getCssText() + ", " + string + ')';
            this.textChanged(string);
        }

        public void blueFloatValueChanged(short s2, float f2) throws DOMException {
            Value value = this.getValue();
            String string = "rgb(" + value.getRed().getCssText() + ", " + value.getGreen().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ')';
            this.textChanged(string);
        }

        public void listTextChanged(int n2, String string) throws DOMException {
            int n3;
            ListValue listValue = (ListValue)this.getValue();
            int n4 = listValue.getLength();
            StringBuffer stringBuffer = new StringBuffer(n4 * 8);
            for (n3 = 0; n3 < n2; ++n3) {
                stringBuffer.append(listValue.item(n3).getCssText());
                stringBuffer.append(listValue.getSeparatorChar());
            }
            stringBuffer.append(string);
            for (n3 = n2 + 1; n3 < n4; ++n3) {
                stringBuffer.append(listValue.getSeparatorChar());
                stringBuffer.append(listValue.item(n3).getCssText());
            }
            string = stringBuffer.toString();
            this.textChanged(string);
        }

        public void listFloatValueChanged(int n2, short s2, float f2) throws DOMException {
            int n3;
            ListValue listValue = (ListValue)this.getValue();
            int n4 = listValue.getLength();
            StringBuffer stringBuffer = new StringBuffer(n4 * 8);
            for (n3 = 0; n3 < n2; ++n3) {
                stringBuffer.append(listValue.item(n3).getCssText());
                stringBuffer.append(listValue.getSeparatorChar());
            }
            stringBuffer.append(FloatValue.getCssText(s2, f2));
            for (n3 = n2 + 1; n3 < n4; ++n3) {
                stringBuffer.append(listValue.getSeparatorChar());
                stringBuffer.append(listValue.item(n3).getCssText());
            }
            this.textChanged(stringBuffer.toString());
        }

        public void listStringValueChanged(int n2, short s2, String string) throws DOMException {
            int n3;
            ListValue listValue = (ListValue)this.getValue();
            int n4 = listValue.getLength();
            StringBuffer stringBuffer = new StringBuffer(n4 * 8);
            for (n3 = 0; n3 < n2; ++n3) {
                stringBuffer.append(listValue.item(n3).getCssText());
                stringBuffer.append(listValue.getSeparatorChar());
            }
            stringBuffer.append(StringValue.getCssText(s2, string));
            for (n3 = n2 + 1; n3 < n4; ++n3) {
                stringBuffer.append(listValue.getSeparatorChar());
                stringBuffer.append(listValue.item(n3).getCssText());
            }
            this.textChanged(stringBuffer.toString());
        }
    }

    public static interface ModificationHandler {
        public void textChanged(String var1) throws DOMException;

        public void floatValueChanged(short var1, float var2) throws DOMException;

        public void stringValueChanged(short var1, String var2) throws DOMException;

        public void leftTextChanged(String var1) throws DOMException;

        public void leftFloatValueChanged(short var1, float var2) throws DOMException;

        public void topTextChanged(String var1) throws DOMException;

        public void topFloatValueChanged(short var1, float var2) throws DOMException;

        public void rightTextChanged(String var1) throws DOMException;

        public void rightFloatValueChanged(short var1, float var2) throws DOMException;

        public void bottomTextChanged(String var1) throws DOMException;

        public void bottomFloatValueChanged(short var1, float var2) throws DOMException;

        public void redTextChanged(String var1) throws DOMException;

        public void redFloatValueChanged(short var1, float var2) throws DOMException;

        public void greenTextChanged(String var1) throws DOMException;

        public void greenFloatValueChanged(short var1, float var2) throws DOMException;

        public void blueTextChanged(String var1) throws DOMException;

        public void blueFloatValueChanged(short var1, float var2) throws DOMException;

        public void listTextChanged(int var1, String var2) throws DOMException;

        public void listFloatValueChanged(int var1, short var2, float var3) throws DOMException;

        public void listStringValueChanged(int var1, short var2, String var3) throws DOMException;
    }

    public static interface ValueProvider {
        public Value getValue();
    }
}

