/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.css2;

import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.css.engine.value.StringValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class FontFamilyManager
extends AbstractValueManager {
    protected static final ListValue DEFAULT_VALUE = new ListValue();
    protected static final StringMap values;

    public boolean isInheritedProperty() {
        return true;
    }

    public boolean isAnimatableProperty() {
        return true;
    }

    public boolean isAdditiveProperty() {
        return false;
    }

    public int getPropertyType() {
        return 26;
    }

    public String getPropertyName() {
        return "font-family";
    }

    public Value getDefaultValue() {
        return DEFAULT_VALUE;
    }

    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            default: {
                throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
            }
            case 35: 
            case 36: 
        }
        ListValue listValue = new ListValue();
        do {
            switch (lexicalUnit.getLexicalUnitType()) {
                case 36: {
                    listValue.append(new StringValue(19, lexicalUnit.getStringValue()));
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    break;
                }
                case 35: {
                    StringBuffer stringBuffer = new StringBuffer(lexicalUnit.getStringValue());
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    if (lexicalUnit != null && lexicalUnit.getLexicalUnitType() == 35) {
                        do {
                            stringBuffer.append(' ');
                            stringBuffer.append(lexicalUnit.getStringValue());
                        } while ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null && lexicalUnit.getLexicalUnitType() == 35);
                        listValue.append(new StringValue(19, stringBuffer.toString()));
                        break;
                    }
                    String string = stringBuffer.toString();
                    String string2 = string.toLowerCase().intern();
                    Value value = (Value)values.get(string2);
                    listValue.append(value != null ? value : new StringValue(19, string));
                }
            }
            if (lexicalUnit == null) {
                return listValue;
            }
            if (lexicalUnit.getLexicalUnitType() == 0) continue;
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        } while ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) != null);
        throw this.createMalformedLexicalUnitDOMException();
    }

    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n2, StyleMap styleMap, Value value) {
        if (value == DEFAULT_VALUE) {
            CSSContext cSSContext = cSSEngine.getCSSContext();
            value = cSSContext.getDefaultFontFamily();
        }
        return value;
    }

    static {
        DEFAULT_VALUE.append(new StringValue(19, "Arial"));
        DEFAULT_VALUE.append(new StringValue(19, "Helvetica"));
        DEFAULT_VALUE.append(new StringValue(21, "sans-serif"));
        values = new StringMap();
        values.put("cursive", ValueConstants.CURSIVE_VALUE);
        values.put("fantasy", ValueConstants.FANTASY_VALUE);
        values.put("monospace", ValueConstants.MONOSPACE_VALUE);
        values.put("serif", ValueConstants.SERIF_VALUE);
        values.put("sans-serif", ValueConstants.SANS_SERIF_VALUE);
    }
}

