/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.value.AbstractValue;
import org.w3c.dom.DOMException;

public class ICCColor
extends AbstractValue {
    protected String colorProfile;
    protected int count;
    protected float[] colors = new float[5];

    public ICCColor(String string) {
        this.colorProfile = string;
    }

    public short getCssValueType() {
        return 3;
    }

    public String getColorProfile() throws DOMException {
        return this.colorProfile;
    }

    public int getNumberOfColors() throws DOMException {
        return this.count;
    }

    public float getColor(int n2) throws DOMException {
        return this.colors[n2];
    }

    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer(this.count * 8);
        stringBuffer.append("icc-color(");
        stringBuffer.append(this.colorProfile);
        for (int i2 = 0; i2 < this.count; ++i2) {
            stringBuffer.append(", ");
            stringBuffer.append(this.colors[i2]);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void append(float f2) {
        if (this.count == this.colors.length) {
            float[] fArray = new float[this.count * 2];
            System.arraycopy(this.colors, 0, fArray, 0, this.count);
            this.colors = fArray;
        }
        this.colors[this.count++] = f2;
    }
}

