/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractSVGLength;
import org.apache.batik.dom.svg.AbstractSVGList;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.parser.LengthListHandler;
import org.apache.batik.parser.LengthListParser;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLengthList;

public abstract class AbstractSVGLengthList
extends AbstractSVGList
implements SVGLengthList {
    protected short direction;
    public static final String SVG_LENGTH_LIST_SEPARATOR = " ";

    protected String getItemSeparator() {
        return SVG_LENGTH_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    protected abstract Element getElement();

    protected AbstractSVGLengthList(short s2) {
        this.direction = s2;
    }

    public SVGLength initialize(SVGLength sVGLength) throws DOMException, SVGException {
        return (SVGLength)((Object)this.initializeImpl(sVGLength));
    }

    public SVGLength getItem(int n2) throws DOMException {
        return (SVGLength)((Object)this.getItemImpl(n2));
    }

    public SVGLength insertItemBefore(SVGLength sVGLength, int n2) throws DOMException, SVGException {
        return (SVGLength)((Object)this.insertItemBeforeImpl(sVGLength, n2));
    }

    public SVGLength replaceItem(SVGLength sVGLength, int n2) throws DOMException, SVGException {
        return (SVGLength)((Object)this.replaceItemImpl(sVGLength, n2));
    }

    public SVGLength removeItem(int n2) throws DOMException {
        return (SVGLength)((Object)this.removeItemImpl(n2));
    }

    public SVGLength appendItem(SVGLength sVGLength) throws DOMException, SVGException {
        return (SVGLength)((Object)this.appendItemImpl(sVGLength));
    }

    protected SVGItem createSVGItem(Object object) {
        SVGLength sVGLength = (SVGLength)object;
        return new SVGLengthItem(sVGLength.getUnitType(), sVGLength.getValueInSpecifiedUnits(), this.direction);
    }

    protected void doParse(String string, ListHandler listHandler) throws ParseException {
        LengthListParser lengthListParser = new LengthListParser();
        LengthListBuilder lengthListBuilder = new LengthListBuilder(listHandler);
        lengthListParser.setLengthListHandler(lengthListBuilder);
        lengthListParser.parse(string);
    }

    protected void checkItemType(Object object) throws SVGException {
        if (!(object instanceof SVGLength)) {
            this.createSVGException((short)0, "expected.length", null);
        }
    }

    protected class LengthListBuilder
    implements LengthListHandler {
        protected ListHandler listHandler;
        protected float currentValue;
        protected short currentType;

        public LengthListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        public void startLengthList() throws ParseException {
            this.listHandler.startList();
        }

        public void startLength() throws ParseException {
            this.currentType = 1;
            this.currentValue = 0.0f;
        }

        public void lengthValue(float f2) throws ParseException {
            this.currentValue = f2;
        }

        public void em() throws ParseException {
            this.currentType = (short)3;
        }

        public void ex() throws ParseException {
            this.currentType = (short)4;
        }

        public void in() throws ParseException {
            this.currentType = (short)8;
        }

        public void cm() throws ParseException {
            this.currentType = (short)6;
        }

        public void mm() throws ParseException {
            this.currentType = (short)7;
        }

        public void pc() throws ParseException {
            this.currentType = (short)10;
        }

        public void pt() throws ParseException {
            this.currentType = (short)3;
        }

        public void px() throws ParseException {
            this.currentType = (short)5;
        }

        public void percentage() throws ParseException {
            this.currentType = (short)2;
        }

        public void endLength() throws ParseException {
            this.listHandler.item(new SVGLengthItem(this.currentType, this.currentValue, AbstractSVGLengthList.this.direction));
        }

        public void endLengthList() throws ParseException {
            this.listHandler.endList();
        }
    }

    protected class SVGLengthItem
    extends AbstractSVGLength
    implements SVGItem {
        protected AbstractSVGList parentList;

        public SVGLengthItem(short s2, float f2, short s3) {
            super(s3);
            this.unitType = s2;
            this.value = f2;
        }

        protected SVGOMElement getAssociatedElement() {
            return (SVGOMElement)AbstractSVGLengthList.this.getElement();
        }

        public void setParent(AbstractSVGList abstractSVGList) {
            this.parentList = abstractSVGList;
        }

        public AbstractSVGList getParent() {
            return this.parentList;
        }

        protected void reset() {
            if (this.parentList != null) {
                this.parentList.itemChanged();
            }
        }
    }
}

