/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import org.apache.batik.ext.awt.image.TransferFunction;

public class DiscreteTransfer
implements TransferFunction {
    public byte[] lutData;
    public int[] tableValues;
    private int n;

    public DiscreteTransfer(int[] nArray) {
        this.tableValues = nArray;
        this.n = nArray.length;
    }

    private void buildLutData() {
        this.lutData = new byte[256];
        for (int i2 = 0; i2 <= 255; ++i2) {
            int n2 = (int)Math.floor((float)(i2 * this.n) / 255.0f);
            if (n2 == this.n) {
                n2 = this.n - 1;
            }
            this.lutData[i2] = (byte)(this.tableValues[n2] & 0xFF);
        }
    }

    public byte[] getLookupTable() {
        this.buildLutData();
        return this.lutData;
    }
}

