/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Color;
import org.apache.batik.ext.awt.image.AbstractLight;

public class SpotLight
extends AbstractLight {
    private double lightX;
    private double lightY;
    private double lightZ;
    private double pointAtX;
    private double pointAtY;
    private double pointAtZ;
    private double specularExponent;
    private double limitingConeAngle;
    private double limitingCos;
    private final double[] S = new double[3];

    public double getLightX() {
        return this.lightX;
    }

    public double getLightY() {
        return this.lightY;
    }

    public double getLightZ() {
        return this.lightZ;
    }

    public double getPointAtX() {
        return this.pointAtX;
    }

    public double getPointAtY() {
        return this.pointAtY;
    }

    public double getPointAtZ() {
        return this.pointAtZ;
    }

    public double getSpecularExponent() {
        return this.specularExponent;
    }

    public double getLimitingConeAngle() {
        return this.limitingConeAngle;
    }

    public SpotLight(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Color color) {
        super(color);
        this.lightX = d2;
        this.lightY = d3;
        this.lightZ = d4;
        this.pointAtX = d5;
        this.pointAtY = d6;
        this.pointAtZ = d7;
        this.specularExponent = d8;
        this.limitingConeAngle = d9;
        this.limitingCos = Math.cos(Math.toRadians(d9));
        this.S[0] = d5 - d2;
        this.S[1] = d6 - d3;
        this.S[2] = d7 - d4;
        double d10 = 1.0 / Math.sqrt(this.S[0] * this.S[0] + this.S[1] * this.S[1] + this.S[2] * this.S[2]);
        this.S[0] = this.S[0] * d10;
        this.S[1] = this.S[1] * d10;
        this.S[2] = this.S[2] * d10;
    }

    public boolean isConstant() {
        return false;
    }

    public final double getLightBase(double d2, double d3, double d4, double[] dArray) {
        double d5 = this.lightX - d2;
        double d6 = this.lightY - d3;
        double d7 = this.lightZ - d4;
        double d8 = 1.0 / Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
        double d9 = -((d5 *= d8) * this.S[0] + (d6 *= d8) * this.S[1] + (d7 *= d8) * this.S[2]);
        dArray[0] = d5;
        dArray[1] = d6;
        dArray[2] = d7;
        if (d9 <= this.limitingCos) {
            return 0.0;
        }
        double d10 = this.limitingCos / d9;
        d10 *= d10;
        d10 *= d10;
        d10 *= d10;
        d10 *= d10;
        d10 *= d10;
        d10 *= d10;
        d10 = 1.0 - d10;
        return d10 * Math.pow(d9, this.specularExponent);
    }

    public final void getLight(double d2, double d3, double d4, double[] dArray) {
        double d5 = this.getLightBase(d2, d3, d4, dArray);
        dArray[0] = dArray[0] * d5;
        dArray[1] = dArray[1] * d5;
        dArray[2] = dArray[2] * d5;
    }

    public final void getLight4(double d2, double d3, double d4, double[] dArray) {
        dArray[3] = this.getLightBase(d2, d3, d4, dArray);
    }

    public double[][] getLightRow4(double d2, double d3, double d4, int n2, double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = dArray2;
        if (dArray3 == null) {
            dArray3 = new double[n2][4];
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.getLight4(d2, d3, dArray[i2][3], dArray3[i2]);
            d2 += d4;
        }
        return dArray3;
    }
}

