/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import org.apache.batik.ext.awt.image.TransferFunction;

public class TableTransfer
implements TransferFunction {
    public byte[] lutData;
    public int[] tableValues;
    private int n;

    public TableTransfer(int[] nArray) {
        this.tableValues = nArray;
        this.n = nArray.length;
    }

    private void buildLutData() {
        this.lutData = new byte[256];
        for (int i2 = 0; i2 <= 255; ++i2) {
            float f2 = (float)(i2 * (this.n - 1)) / 255.0f;
            int n2 = (int)Math.floor(f2);
            int n3 = n2 + 1 > this.n - 1 ? this.n - 1 : n2 + 1;
            float f3 = f2 - (float)n2;
            this.lutData[i2] = (byte)((int)((float)this.tableValues[n2] + f3 * (float)(this.tableValues[n3] - this.tableValues[n2])) & 0xFF);
        }
    }

    public byte[] getLookupTable() {
        this.buildLutData();
        return this.lutData;
    }
}

