/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.imageio;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.apache.batik.ext.awt.image.spi.ImageWriterParams;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageIOImageWriter
implements org.apache.batik.ext.awt.image.spi.ImageWriter,
IIOWriteWarningListener {
    private String targetMIME;

    public ImageIOImageWriter(String string) {
        this.targetMIME = string;
    }

    public void writeImage(RenderedImage renderedImage, OutputStream outputStream) throws IOException {
        this.writeImage(renderedImage, outputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImage(RenderedImage renderedImage, OutputStream outputStream, ImageWriterParams imageWriterParams) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(this.getMIMEType());
        ImageWriter imageWriter = null;
        try {
            block9: {
                imageWriter = iterator.next();
                if (imageWriter != null) {
                    imageWriter.addIIOWriteWarningListener(this);
                    ImageOutputStream imageOutputStream = null;
                    try {
                        imageOutputStream = ImageIO.createImageOutputStream(outputStream);
                        ImageWriteParam imageWriteParam = this.getDefaultWriteParam(imageWriter, renderedImage, imageWriterParams);
                        ImageTypeSpecifier imageTypeSpecifier = imageWriteParam.getDestinationType() != null ? imageWriteParam.getDestinationType() : ImageTypeSpecifier.createFromRenderedImage(renderedImage);
                        IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
                        if (imageWriterParams != null && iIOMetadata != null) {
                            iIOMetadata = this.updateMetadata(iIOMetadata, imageWriterParams);
                        }
                        imageWriter.setOutput(imageOutputStream);
                        IIOImage iIOImage = new IIOImage(renderedImage, null, iIOMetadata);
                        imageWriter.write(null, iIOImage, imageWriteParam);
                        Object var12_11 = null;
                        if (imageOutputStream == null) break block9;
                        System.err.println("closing");
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        if (imageOutputStream != null) {
                            System.err.println("closing");
                            imageOutputStream.close();
                        }
                        throw throwable;
                    }
                    imageOutputStream.close();
                    {
                        break block9;
                    }
                }
                throw new UnsupportedOperationException("No ImageIO codec for writing " + this.getMIMEType() + " is available!");
            }
            Object var14_14 = null;
            if (imageWriter != null) {
                System.err.println("disposing");
                imageWriter.dispose();
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (imageWriter != null) {
                System.err.println("disposing");
                imageWriter.dispose();
            }
            throw throwable;
        }
    }

    protected ImageWriteParam getDefaultWriteParam(ImageWriter imageWriter, RenderedImage renderedImage, ImageWriterParams imageWriterParams) {
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        System.err.println("Param: " + imageWriterParams);
        if (imageWriterParams != null && imageWriterParams.getCompressionMethod() != null) {
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionType(imageWriterParams.getCompressionMethod());
        }
        return imageWriteParam;
    }

    protected IIOMetadata updateMetadata(IIOMetadata iIOMetadata, ImageWriterParams imageWriterParams) {
        if (iIOMetadata.isStandardMetadataFormatSupported()) {
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree("javax_imageio_1.0");
            IIOMetadataNode iIOMetadataNode2 = ImageIOImageWriter.getChildNode(iIOMetadataNode, "Dimension");
            if (imageWriterParams.getResolution() != null) {
                IIOMetadataNode iIOMetadataNode3 = ImageIOImageWriter.getChildNode(iIOMetadataNode2, "HorizontalPixelSize");
                if (iIOMetadataNode3 == null) {
                    iIOMetadataNode3 = new IIOMetadataNode("HorizontalPixelSize");
                    iIOMetadataNode2.appendChild(iIOMetadataNode3);
                }
                iIOMetadataNode3.setAttribute("value", Double.toString(imageWriterParams.getResolution().doubleValue() / 25.4));
                iIOMetadataNode3 = ImageIOImageWriter.getChildNode(iIOMetadataNode2, "VerticalPixelSize");
                if (iIOMetadataNode3 == null) {
                    iIOMetadataNode3 = new IIOMetadataNode("VerticalPixelSize");
                    iIOMetadataNode2.appendChild(iIOMetadataNode3);
                }
                iIOMetadataNode3.setAttribute("value", Double.toString(imageWriterParams.getResolution().doubleValue() / 25.4));
            }
            try {
                iIOMetadata.mergeTree("javax_imageio_1.0", iIOMetadataNode);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                throw new RuntimeException("Cannot update image metadata: " + iIOInvalidTreeException.getMessage());
            }
        }
        return iIOMetadata;
    }

    protected static IIOMetadataNode getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            if (!string.equals(node2.getNodeName())) continue;
            return (IIOMetadataNode)node2;
        }
        return null;
    }

    public String getMIMEType() {
        return this.targetMIME;
    }

    public void warningOccurred(ImageWriter imageWriter, int n2, String string) {
        System.err.println("Problem while writing image using ImageI/O: " + string);
    }
}

