/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.tiff;

import java.awt.image.BufferedImage;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFEncodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFField;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFImageEncoder;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.TIFFTranscoder;

public class TIFFTranscoderInternalCodecWriteAdapter
implements TIFFTranscoder.WriteAdapter {
    public void writeImage(TIFFTranscoder tIFFTranscoder, BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        TranscodingHints transcodingHints = tIFFTranscoder.getTranscodingHints();
        TIFFEncodeParam tIFFEncodeParam = new TIFFEncodeParam();
        float f2 = tIFFTranscoder.getUserAgent().getPixelUnitToMillimeter();
        int n2 = (int)((double)(100000.0f / f2) + 0.5);
        int n3 = 10000;
        long[] lArray = new long[]{n2, n3};
        TIFFField[] tIFFFieldArray = new TIFFField[]{new TIFFField(296, 3, 1, new char[]{'\u0003'}), new TIFFField(282, 5, 1, new long[][]{lArray}), new TIFFField(283, 5, 1, new long[][]{lArray})};
        tIFFEncodeParam.setExtraFields(tIFFFieldArray);
        if (transcodingHints.containsKey(TIFFTranscoder.KEY_COMPRESSION_METHOD)) {
            String string = (String)transcodingHints.get(TIFFTranscoder.KEY_COMPRESSION_METHOD);
            if ("packbits".equals(string)) {
                tIFFEncodeParam.setCompression(32773);
            } else if ("deflate".equals(string)) {
                tIFFEncodeParam.setCompression(32946);
            }
        }
        try {
            int n4 = bufferedImage.getWidth();
            int n5 = bufferedImage.getHeight();
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            OutputStream outputStream = transcoderOutput.getOutputStream();
            TIFFImageEncoder tIFFImageEncoder = new TIFFImageEncoder(outputStream, tIFFEncodeParam);
            int n6 = singlePixelPackedSampleModel.getNumBands();
            int[] nArray = new int[n6];
            for (int i2 = 0; i2 < n6; ++i2) {
                nArray[i2] = i2;
            }
            PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n4, n5, n6, n4 * n6, nArray);
            FormatRed formatRed = new FormatRed(GraphicsUtil.wrap(bufferedImage), pixelInterleavedSampleModel);
            tIFFImageEncoder.encode(formatRed);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }
}

