/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.MorphologyRable;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.BufferedImageCachableRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.MorphologyOp;
import org.apache.batik.ext.awt.image.rendered.PadRed;
import org.apache.batik.ext.awt.image.rendered.RenderedImageCachableRed;

public class MorphologyRable8Bit
extends AbstractRable
implements MorphologyRable {
    private double radiusX;
    private double radiusY;
    private boolean doDilation;

    public MorphologyRable8Bit(Filter filter, double d2, double d3, boolean bl) {
        super(filter, null);
        this.setRadiusX(d2);
        this.setRadiusY(d3);
        this.setDoDilation(bl);
    }

    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    public Rectangle2D getBounds2D() {
        return this.getSource().getBounds2D();
    }

    public void setRadiusX(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.radiusX = d2;
    }

    public void setRadiusY(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.radiusY = d2;
    }

    public void setDoDilation(boolean bl) {
        this.touch();
        this.doDilation = bl;
    }

    public boolean getDoDilation() {
        return this.doDilation;
    }

    public double getRadiusX() {
        return this.radiusX;
    }

    public double getRadiusY() {
        return this.radiusY;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        AffineTransform affineTransform = renderContext.getTransform();
        double d2 = affineTransform.getScaleX();
        double d3 = affineTransform.getScaleY();
        double d4 = affineTransform.getShearX();
        double d5 = affineTransform.getShearY();
        double d6 = affineTransform.getTranslateX();
        double d7 = affineTransform.getTranslateY();
        double d8 = Math.sqrt(d2 * d2 + d5 * d5);
        double d9 = Math.sqrt(d3 * d3 + d4 * d4);
        AffineTransform affineTransform2 = AffineTransform.getScaleInstance(d8, d9);
        int n2 = (int)Math.round(this.radiusX * d8);
        int n3 = (int)Math.round(this.radiusY * d9);
        MorphologyOp morphologyOp = null;
        if (n2 > 0 && n3 > 0) {
            morphologyOp = new MorphologyOp(n2, n3, this.doDilation);
        }
        AffineTransform affineTransform3 = new AffineTransform(d2 / d8, d5 / d8, d4 / d9, d3 / d9, d6, d7);
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            shape = this.getBounds2D();
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        rectangle2D = new Rectangle2D.Double(rectangle2D.getX() - (double)n2 / d8, rectangle2D.getY() - (double)n3 / d9, rectangle2D.getWidth() + (double)(2 * n2) / d8, rectangle2D.getHeight() + (double)(2 * n3) / d9);
        RenderedImage renderedImage = this.getSource().createRendering(new RenderContext(affineTransform2, rectangle2D, renderingHints));
        if (renderedImage == null) {
            return null;
        }
        CachableRed cachableRed = new RenderedImageCachableRed(renderedImage);
        Shape shape2 = affineTransform2.createTransformedShape(shape.getBounds2D());
        rectangle2D = shape2.getBounds2D();
        rectangle2D = new Rectangle2D.Double(rectangle2D.getX() - (double)n2, rectangle2D.getY() - (double)n3, rectangle2D.getWidth() + (double)(2 * n2), rectangle2D.getHeight() + (double)(2 * n3));
        cachableRed = new PadRed(cachableRed, rectangle2D.getBounds(), PadMode.ZERO_PAD, renderingHints);
        ColorModel colorModel = renderedImage.getColorModel();
        Raster raster = cachableRed.getData();
        Point point = new Point(0, 0);
        WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), point);
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        BufferedImage bufferedImage2 = morphologyOp != null ? morphologyOp.filter(bufferedImage, null) : bufferedImage;
        int n4 = cachableRed.getMinX();
        int n5 = cachableRed.getMinY();
        cachableRed = new BufferedImageCachableRed(bufferedImage2, n4, n5);
        if (!affineTransform3.isIdentity()) {
            cachableRed = new AffineRed(cachableRed, affineTransform3, renderingHints);
        }
        return cachableRed;
    }

    public Shape getDependencyRegion(int n2, Rectangle2D rectangle2D) {
        return super.getDependencyRegion(n2, rectangle2D);
    }

    public Shape getDirtyRegion(int n2, Rectangle2D rectangle2D) {
        return super.getDirtyRegion(n2, rectangle2D);
    }
}

