/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class ColorMatrixRed
extends AbstractRed {
    private float[][] matrix;

    public float[][] getMatrix() {
        return this.copyMatrix(this.matrix);
    }

    public void setMatrix(float[][] fArray) {
        float[][] fArray2 = this.copyMatrix(fArray);
        if (fArray2 == null) {
            throw new IllegalArgumentException();
        }
        if (fArray2.length != 4) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            if (fArray2[i2].length == 5) continue;
            throw new IllegalArgumentException(String.valueOf(i2) + " : " + fArray2[i2].length);
        }
        this.matrix = fArray;
    }

    private float[][] copyMatrix(float[][] fArray) {
        if (fArray == null) {
            return null;
        }
        float[][] fArrayArray = new float[fArray.length][];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (fArray[i2] == null) continue;
            fArrayArray[i2] = new float[fArray[i2].length];
            System.arraycopy(fArray[i2], 0, fArrayArray[i2], 0, fArray[i2].length);
        }
        return fArrayArray;
    }

    public ColorMatrixRed(CachableRed cachableRed, float[][] fArray) {
        this.setMatrix(fArray);
        ColorModel colorModel = cachableRed.getColorModel();
        ColorSpace colorSpace = null;
        if (colorModel != null) {
            colorSpace = colorModel.getColorSpace();
        }
        ColorModel colorModel2 = colorSpace == null ? GraphicsUtil.Linear_sRGB_Unpre : (colorSpace == ColorSpace.getInstance(1004) ? GraphicsUtil.Linear_sRGB_Unpre : GraphicsUtil.sRGB_Unpre);
        SampleModel sampleModel = colorModel2.createCompatibleSampleModel(cachableRed.getWidth(), cachableRed.getHeight());
        this.init(cachableRed, cachableRed.getBounds(), colorModel2, sampleModel, cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        writableRaster = cachableRed.copyData(writableRaster);
        ColorModel colorModel = cachableRed.getColorModel();
        GraphicsUtil.coerceData(writableRaster, colorModel, false);
        int n2 = writableRaster.getMinX();
        int n3 = writableRaster.getMinY();
        int n4 = writableRaster.getWidth();
        int n5 = writableRaster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n6 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n2 - writableRaster.getSampleModelTranslateX(), n3 - writableRaster.getSampleModelTranslateY());
        int n7 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int n8 = n7 - n4;
        int n9 = n6;
        int n10 = 0;
        int n11 = 0;
        float f2 = this.matrix[0][0] / 255.0f;
        float f3 = this.matrix[0][1] / 255.0f;
        float f4 = this.matrix[0][2] / 255.0f;
        float f5 = this.matrix[0][3] / 255.0f;
        float f6 = this.matrix[0][4] / 255.0f;
        float f7 = this.matrix[1][0] / 255.0f;
        float f8 = this.matrix[1][1] / 255.0f;
        float f9 = this.matrix[1][2] / 255.0f;
        float f10 = this.matrix[1][3] / 255.0f;
        float f11 = this.matrix[1][4] / 255.0f;
        float f12 = this.matrix[2][0] / 255.0f;
        float f13 = this.matrix[2][1] / 255.0f;
        float f14 = this.matrix[2][2] / 255.0f;
        float f15 = this.matrix[2][3] / 255.0f;
        float f16 = this.matrix[2][4] / 255.0f;
        float f17 = this.matrix[3][0] / 255.0f;
        float f18 = this.matrix[3][1] / 255.0f;
        float f19 = this.matrix[3][2] / 255.0f;
        float f20 = this.matrix[3][3] / 255.0f;
        float f21 = this.matrix[3][4] / 255.0f;
        for (n10 = 0; n10 < n5; ++n10) {
            for (n11 = 0; n11 < n4; ++n11) {
                int n12 = nArray[n9];
                int n13 = n12 >>> 24;
                int n14 = n12 >> 16 & 0xFF;
                int n15 = n12 >> 8 & 0xFF;
                int n16 = n12 & 0xFF;
                int n17 = (int)((f2 * (float)n14 + f3 * (float)n15 + f4 * (float)n16 + f5 * (float)n13 + f6) * 255.0f);
                int n18 = (int)((f7 * (float)n14 + f8 * (float)n15 + f9 * (float)n16 + f10 * (float)n13 + f11) * 255.0f);
                int n19 = (int)((f12 * (float)n14 + f13 * (float)n15 + f14 * (float)n16 + f15 * (float)n13 + f16) * 255.0f);
                int n20 = (int)((f17 * (float)n14 + f18 * (float)n15 + f19 * (float)n16 + f20 * (float)n13 + f21) * 255.0f);
                if ((n17 & 0xFFFFFF00) != 0) {
                    int n21 = n17 = (n17 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                if ((n18 & 0xFFFFFF00) != 0) {
                    int n22 = n18 = (n18 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                if ((n19 & 0xFFFFFF00) != 0) {
                    int n23 = n19 = (n19 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                if ((n20 & 0xFFFFFF00) != 0) {
                    n20 = (n20 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[n9++] = n20 << 24 | n17 << 16 | n18 << 8 | n19;
            }
            n9 += n8;
        }
        return writableRaster;
    }
}

