/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.Light;
import org.apache.batik.ext.awt.image.SpotLight;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.BumpMap;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class SpecularLightingRed
extends AbstractTiledRed {
    private double ks;
    private double specularExponent;
    private Light light;
    private BumpMap bumpMap;
    private double scaleX;
    private double scaleY;
    private Rectangle litRegion;
    private boolean linear;

    public SpecularLightingRed(double d2, double d3, Light light, BumpMap bumpMap, Rectangle rectangle, double d4, double d5, boolean bl) {
        this.ks = d2;
        this.specularExponent = d3;
        this.light = light;
        this.bumpMap = bumpMap;
        this.litRegion = rectangle;
        this.scaleX = d4;
        this.scaleY = d5;
        this.linear = bl;
        ColorModel colorModel = bl ? GraphicsUtil.Linear_sRGB_Unpre : GraphicsUtil.sRGB_Unpre;
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        int n4 = AbstractTiledRed.getDefaultTileSize();
        if (n2 > n4) {
            n2 = n4;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(n2, n3);
        this.init((CachableRed)null, rectangle, colorModel, sampleModel, rectangle.x, rectangle.y, null);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRaster(writableRaster);
        return writableRaster;
    }

    public void genRect(WritableRaster writableRaster) {
        double d2 = this.scaleX;
        double d3 = this.scaleY;
        double[] dArray = this.light.getColor(this.linear);
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getMinX();
        int n5 = writableRaster.getMinY();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n6 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n4 - writableRaster.getSampleModelTranslateX(), n5 - writableRaster.getSampleModelTranslateY());
        int n7 = singlePixelPackedSampleModel.getScanlineStride();
        int n8 = n7 - n2;
        int n9 = n6;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        double d4 = d2 * (double)n4;
        double d5 = d3 * (double)n5;
        double d6 = 0.0;
        int n13 = 0;
        double d7 = dArray[0] > dArray[1] ? dArray[0] : dArray[1];
        d7 = d7 > dArray[2] ? d7 : dArray[2];
        double d8 = 255.0 / d7;
        n13 = (int)(dArray[0] * d8 + 0.5);
        int n14 = (int)(dArray[1] * d8 + 0.5);
        n13 = n13 << 8 | n14;
        n14 = (int)(dArray[2] * d8 + 0.5);
        n13 = n13 << 8 | n14;
        d7 *= 255.0 * this.ks;
        double[][][] dArray2 = this.bumpMap.getNormalArray(n4, n5, n2, n3);
        if (this.light instanceof SpotLight) {
            SpotLight spotLight = (SpotLight)this.light;
            double[][] dArray3 = new double[n2][4];
            for (n11 = 0; n11 < n3; ++n11) {
                double[][] dArray4 = dArray2[n11];
                spotLight.getLightRow4(d4, d5 + (double)n11 * d3, d2, n2, dArray4, dArray3);
                for (n12 = 0; n12 < n2; ++n12) {
                    double[] dArray5 = dArray4[n12];
                    double[] dArray6 = dArray3[n12];
                    double d9 = dArray6[3];
                    if (d9 == 0.0) {
                        n10 = 0;
                    } else {
                        dArray6[2] = dArray6[2] + 1.0;
                        d6 = dArray6[0] * dArray6[0] + dArray6[1] * dArray6[1] + dArray6[2] * dArray6[2];
                        double d10 = dArray5[0] * dArray6[0] + dArray5[1] * dArray6[1] + dArray5[2] * dArray6[2];
                        n10 = (int)(d7 * (d9 *= Math.pow(d10 / (d6 = Math.sqrt(d6)), this.specularExponent)) + 0.5);
                        if ((n10 & 0xFFFFFF00) != 0) {
                            n10 = (n10 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                        }
                    }
                    nArray[n9++] = n10 << 24 | n13;
                }
                n9 += n8;
            }
        } else if (!this.light.isConstant()) {
            double[][] dArray7 = new double[n2][4];
            for (n11 = 0; n11 < n3; ++n11) {
                double[][] dArray8 = dArray2[n11];
                this.light.getLightRow(d4, d5 + (double)n11 * d3, d2, n2, dArray8, dArray7);
                for (n12 = 0; n12 < n2; ++n12) {
                    double[] dArray9 = dArray8[n12];
                    double[] dArray10 = dArray7[n12];
                    dArray10[2] = dArray10[2] + 1.0;
                    d6 = dArray10[0] * dArray10[0] + dArray10[1] * dArray10[1] + dArray10[2] * dArray10[2];
                    d6 = Math.sqrt(d6);
                    double d11 = dArray9[0] * dArray10[0] + dArray9[1] * dArray10[1] + dArray9[2] * dArray10[2];
                    n10 = (int)(d7 * (d6 = Math.pow(d11 / d6, this.specularExponent)) + 0.5);
                    if ((n10 & 0xFFFFFF00) != 0) {
                        n10 = (n10 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    nArray[n9++] = n10 << 24 | n13;
                }
                n9 += n8;
            }
        } else {
            double[] dArray11 = new double[3];
            this.light.getLight(0.0, 0.0, 0.0, dArray11);
            dArray11[2] = dArray11[2] + 1.0;
            d6 = Math.sqrt(dArray11[0] * dArray11[0] + dArray11[1] * dArray11[1] + dArray11[2] * dArray11[2]);
            if (d6 > 0.0) {
                dArray11[0] = dArray11[0] / d6;
                dArray11[1] = dArray11[1] / d6;
                dArray11[2] = dArray11[2] / d6;
            }
            for (n11 = 0; n11 < n3; ++n11) {
                double[][] dArray12 = dArray2[n11];
                for (n12 = 0; n12 < n2; ++n12) {
                    double[] dArray13 = dArray12[n12];
                    n10 = (int)(d7 * Math.pow(dArray13[0] * dArray11[0] + dArray13[1] * dArray11[1] + dArray13[2] * dArray11[2], this.specularExponent) + 0.5);
                    if ((n10 & 0xFFFFFF00) != 0) {
                        n10 = (n10 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    nArray[n9++] = n10 << 24 | n13;
                }
                n9 += n8;
            }
        }
    }
}

