/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import org.apache.batik.ext.awt.image.spi.AbstractRegistryEntry;
import org.apache.batik.ext.awt.image.spi.StreamRegistryEntry;

public abstract class MagicNumberRegistryEntry
extends AbstractRegistryEntry
implements StreamRegistryEntry {
    public static final float PRIORITY = 1000.0f;
    MagicNumber[] magicNumbers;

    public MagicNumberRegistryEntry(String string, float f2, String string2, String string3, int n2, byte[] byArray) {
        super(string, f2, string2, string3);
        this.magicNumbers = new MagicNumber[1];
        this.magicNumbers[0] = new MagicNumber(n2, byArray);
    }

    public MagicNumberRegistryEntry(String string, String string2, String string3, int n2, byte[] byArray) {
        this(string, 1000.0f, string2, string3, n2, byArray);
    }

    public MagicNumberRegistryEntry(String string, float f2, String string2, String string3, MagicNumber[] magicNumberArray) {
        super(string, f2, string2, string3);
        this.magicNumbers = magicNumberArray;
    }

    public MagicNumberRegistryEntry(String string, String string2, String string3, MagicNumber[] magicNumberArray) {
        this(string, 1000.0f, string2, string3, magicNumberArray);
    }

    public MagicNumberRegistryEntry(String string, float f2, String[] stringArray, String[] stringArray2, int n2, byte[] byArray) {
        super(string, f2, stringArray, stringArray2);
        this.magicNumbers = new MagicNumber[1];
        this.magicNumbers[0] = new MagicNumber(n2, byArray);
    }

    public MagicNumberRegistryEntry(String string, String[] stringArray, String[] stringArray2, int n2, byte[] byArray) {
        this(string, 1000.0f, stringArray, stringArray2, n2, byArray);
    }

    public MagicNumberRegistryEntry(String string, float f2, String[] stringArray, String[] stringArray2, MagicNumber[] magicNumberArray) {
        super(string, f2, stringArray, stringArray2);
        this.magicNumbers = magicNumberArray;
    }

    public MagicNumberRegistryEntry(String string, String[] stringArray, String[] stringArray2, MagicNumber[] magicNumberArray) {
        this(string, 1000.0f, stringArray, stringArray2, magicNumberArray);
    }

    public MagicNumberRegistryEntry(String string, String[] stringArray, String[] stringArray2, MagicNumber[] magicNumberArray, float f2) {
        super(string, f2, stringArray, stringArray2);
        this.magicNumbers = magicNumberArray;
    }

    public int getReadlimit() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.magicNumbers.length; ++i2) {
            int n3 = this.magicNumbers[i2].getReadlimit();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public boolean isCompatibleStream(InputStream inputStream) throws StreamCorruptedException {
        for (int i2 = 0; i2 < this.magicNumbers.length; ++i2) {
            if (!this.magicNumbers[i2].isMatch(inputStream)) continue;
            return true;
        }
        return false;
    }

    public static class MagicNumber {
        int offset;
        byte[] magicNumber;
        byte[] buffer;

        public MagicNumber(int n2, byte[] byArray) {
            this.offset = n2;
            this.magicNumber = (byte[])byArray.clone();
            this.buffer = new byte[byArray.length];
        }

        int getReadlimit() {
            return this.offset + this.magicNumber.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean isMatch(InputStream inputStream) throws StreamCorruptedException {
            int n2;
            int n3;
            inputStream.mark(this.getReadlimit());
            try {
                try {}
                catch (IOException iOException) {
                    boolean bl = false;
                    Object var6_13 = null;
                    try {
                        inputStream.reset();
                        return bl;
                    }
                    catch (IOException iOException2) {
                        throw new StreamCorruptedException(iOException2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_14 = null;
                try {}
                catch (IOException iOException) {
                    throw new StreamCorruptedException(iOException.getMessage());
                }
                inputStream.reset();
                throw throwable;
            }
            for (n2 = 0; n2 < this.offset; n2 += n3) {
                n3 = (int)inputStream.skip(this.offset - n2);
                if (n3 != -1) continue;
                boolean bl = false;
                Object var6_9 = null;
                try {}
                catch (IOException iOException) {
                    throw new StreamCorruptedException(iOException.getMessage());
                }
                inputStream.reset();
                return bl;
            }
            for (n2 = 0; n2 < this.buffer.length; n2 += n3) {
                n3 = inputStream.read(this.buffer, n2, this.buffer.length - n2);
                if (n3 != -1) continue;
                boolean bl = false;
                Object var6_10 = null;
                try {}
                catch (IOException iOException) {
                    throw new StreamCorruptedException(iOException.getMessage());
                }
                inputStream.reset();
                return bl;
            }
            for (n3 = 0; n3 < this.magicNumber.length; ++n3) {
                if (this.magicNumber[n3] == this.buffer[n3]) continue;
                boolean bl = false;
                Object var6_11 = null;
                try {}
                catch (IOException iOException) {
                    throw new StreamCorruptedException(iOException.getMessage());
                }
                inputStream.reset();
                return bl;
            }
            Object var6_12 = null;
            try {}
            catch (IOException iOException) {
                throw new StreamCorruptedException(iOException.getMessage());
            }
            inputStream.reset();
            return true;
        }
    }
}

