/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.LinearTransfer;
import org.apache.batik.ext.awt.image.TransferFunction;
import org.apache.batik.ext.awt.image.renderable.AbstractColorInterpolationRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.rendered.ComponentTransferRed;
import org.apache.batik.extension.svg.BatikHistogramNormalizationFilter;
import org.apache.batik.extension.svg.HistogramRed;

public class BatikHistogramNormalizationFilter8Bit
extends AbstractColorInterpolationRable
implements BatikHistogramNormalizationFilter {
    private float trim = 0.01f;
    protected int[] histo = null;
    protected float slope;
    protected float intercept;

    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    public float getTrim() {
        return this.trim;
    }

    public void setTrim(float f2) {
        this.trim = f2;
        this.touch();
    }

    public BatikHistogramNormalizationFilter8Bit(Filter filter, float f2) {
        this.setSource(filter);
        this.setTrim(f2);
    }

    public void computeHistogram(RenderContext renderContext) {
        int n2;
        float f2;
        if (this.histo != null) {
            return;
        }
        Filter filter = this.getSource();
        float f3 = 100.0f / filter.getWidth();
        if (f3 > (f2 = 100.0f / filter.getHeight())) {
            f3 = f2;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f3, f3);
        renderContext = new RenderContext(affineTransform, renderContext.getRenderingHints());
        RenderedImage renderedImage = this.getSource().createRendering(renderContext);
        this.histo = new HistogramRed(this.convertSourceCS(renderedImage)).getHistogram();
        int n3 = (int)((double)((float)(renderedImage.getWidth() * renderedImage.getHeight()) * this.trim) + 0.5);
        int n4 = 0;
        for (n2 = 0; n2 < 255 && (n4 += this.histo[n2]) < n3; ++n2) {
        }
        int n5 = n2;
        n4 = 0;
        for (n2 = 255; n2 > 0 && (n4 += this.histo[n2]) < n3; --n2) {
        }
        int n6 = n2;
        this.slope = 255.0f / (float)(n6 - n5);
        this.intercept = this.slope * (float)(-n5) / 255.0f;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        RenderedImage renderedImage = this.getSource().createRendering(renderContext);
        if (renderedImage == null) {
            return null;
        }
        this.computeHistogram(renderContext);
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = sampleModel.getNumBands();
        TransferFunction[] transferFunctionArray = new TransferFunction[n2];
        LinearTransfer linearTransfer = new LinearTransfer(this.slope, this.intercept);
        for (int i2 = 0; i2 < transferFunctionArray.length; ++i2) {
            transferFunctionArray[i2] = linearTransfer;
        }
        return new ComponentTransferRed(this.convertSourceCS(renderedImage), transferFunctionArray, null);
    }
}

