/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.filter;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.gvt.GraphicsNode;

public class GraphicsNodeRed8Bit
extends AbstractRed {
    private GraphicsNode node;
    private AffineTransform node2dev;
    private RenderingHints hints;
    private boolean usePrimitivePaint;
    static final boolean onMacOSX = "Mac OS X".equals(System.getProperty("os.name"));

    public GraphicsNodeRed8Bit(GraphicsNode graphicsNode, AffineTransform affineTransform, boolean bl, RenderingHints renderingHints) {
        int n2;
        Cloneable cloneable;
        this.node = graphicsNode;
        this.node2dev = affineTransform;
        this.hints = renderingHints;
        this.usePrimitivePaint = bl;
        AffineTransform affineTransform2 = affineTransform;
        Rectangle2D rectangle2D = graphicsNode.getPrimitiveBounds();
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
        }
        if (!bl && (cloneable = graphicsNode.getTransform()) != null) {
            affineTransform2 = (AffineTransform)affineTransform2.clone();
            affineTransform2.concatenate((AffineTransform)cloneable);
        }
        cloneable = affineTransform2.createTransformedShape(rectangle2D).getBounds();
        ColorModel colorModel = this.createColorModel();
        int n3 = AbstractTiledRed.getDefaultTileSize();
        int n4 = n3 * (int)Math.floor(((Rectangle)cloneable).x / n3);
        int n5 = n3 * (int)Math.floor(((Rectangle)cloneable).y / n3);
        int n6 = ((Rectangle)cloneable).x + ((Rectangle)cloneable).width - n4;
        if (n6 > n3) {
            n6 = n3;
        }
        if ((n2 = ((Rectangle)cloneable).y + ((Rectangle)cloneable).height - n5) > n3) {
            n2 = n3;
        }
        if (n6 <= 0 || n2 <= 0) {
            n6 = 1;
            n2 = 1;
        }
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(n6, n2);
        this.init((CachableRed)null, (Rectangle)cloneable, colorModel, sampleModel, n4, n5, null);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.genRect(writableRaster);
        return writableRaster;
    }

    public void genRect(WritableRaster writableRaster) {
        BufferedImage bufferedImage = new BufferedImage(this.cm, writableRaster.createWritableTranslatedChild(0, 0), this.cm.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage, this.hints);
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, writableRaster.getWidth(), writableRaster.getHeight());
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.translate(-writableRaster.getMinX(), -writableRaster.getMinY());
        graphics2D.transform(this.node2dev);
        if (this.usePrimitivePaint) {
            this.node.primitivePaint(graphics2D);
        } else {
            this.node.paint(graphics2D);
        }
        graphics2D.dispose();
    }

    public ColorModel createColorModel() {
        if (onMacOSX) {
            return GraphicsUtil.sRGB_Pre;
        }
        return GraphicsUtil.sRGB_Unpre;
    }
}

