/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.flow;

import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTLineMetrics;

public class BlockInfo {
    public static final int ALIGN_START = 0;
    public static final int ALIGN_MIDDLE = 1;
    public static final int ALIGN_END = 2;
    public static final int ALIGN_FULL = 3;
    protected float top;
    protected float right;
    protected float bottom;
    protected float left;
    protected float indent;
    protected int alignment;
    protected float lineHeight;
    protected List fontList;
    protected Map fontAttrs;
    protected float ascent = -1.0f;
    protected float descent = -1.0f;
    protected boolean flowRegionBreak;

    public BlockInfo(float f2, float f3, float f4, float f5, float f6, int n2, float f7, List list, Map map, boolean bl) {
        this.top = f2;
        this.right = f3;
        this.bottom = f4;
        this.left = f5;
        this.indent = f6;
        this.alignment = n2;
        this.lineHeight = f7;
        this.fontList = list;
        this.fontAttrs = map;
        this.flowRegionBreak = bl;
    }

    public BlockInfo(float f2, int n2) {
        this.setMargin(f2);
        this.indent = 0.0f;
        this.alignment = n2;
        this.flowRegionBreak = false;
    }

    public void setMargin(float f2) {
        this.top = f2;
        this.right = f2;
        this.bottom = f2;
        this.left = f2;
    }

    public void initLineInfo(FontRenderContext fontRenderContext) {
        Iterator iterator;
        float f2 = 12.0f;
        Float f3 = (Float)this.fontAttrs.get(TextAttribute.SIZE);
        if (f3 != null) {
            f2 = f3.floatValue();
        }
        if ((iterator = this.fontList.iterator()).hasNext()) {
            GVTFont gVTFont = (GVTFont)iterator.next();
            GVTLineMetrics gVTLineMetrics = gVTFont.getLineMetrics("", fontRenderContext);
            this.ascent = gVTLineMetrics.getAscent();
            this.descent = gVTLineMetrics.getDescent();
        }
        if (this.ascent == -1.0f) {
            this.ascent = f2 * 0.8f;
            this.descent = f2 * 0.2f;
        }
    }

    public float getTopMargin() {
        return this.top;
    }

    public float getRightMargin() {
        return this.right;
    }

    public float getBottomMargin() {
        return this.bottom;
    }

    public float getLeftMargin() {
        return this.left;
    }

    public float getIndent() {
        return this.indent;
    }

    public int getTextAlignment() {
        return this.alignment;
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public List getFontList() {
        return this.fontList;
    }

    public Map getFontAttrs() {
        return this.fontAttrs;
    }

    public float getAscent() {
        return this.ascent;
    }

    public float getDescent() {
        return this.descent;
    }

    public boolean isFlowRegionBreak() {
        return this.flowRegionBreak;
    }
}

