/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.gvt.font.AWTFontFamily;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.UnresolvedFontFamily;

public class FontFamilyResolver {
    public static final AWTFontFamily defaultFont;
    protected static final Map fonts;
    protected static final List awtFontFamilies;
    protected static final List awtFonts;
    protected static final Map resolvedFontFamilies;

    public static String lookup(String string) {
        return (String)fonts.get(string.toLowerCase());
    }

    public static GVTFontFamily resolve(String string) {
        GVTFontFamily gVTFontFamily = (GVTFontFamily)resolvedFontFamilies.get(string = string.toLowerCase());
        if (gVTFontFamily == null) {
            String string2 = (String)fonts.get(string);
            if (string2 != null) {
                gVTFontFamily = new AWTFontFamily(string2);
            }
            resolvedFontFamilies.put(string, gVTFontFamily);
        }
        return gVTFontFamily;
    }

    public static GVTFontFamily resolve(UnresolvedFontFamily unresolvedFontFamily) {
        return FontFamilyResolver.resolve(unresolvedFontFamily.getFamilyName());
    }

    public static GVTFontFamily getFamilyThatCanDisplay(char c2) {
        for (int i2 = 0; i2 < awtFontFamilies.size(); ++i2) {
            AWTFontFamily aWTFontFamily = (AWTFontFamily)awtFontFamilies.get(i2);
            AWTGVTFont aWTGVTFont = (AWTGVTFont)awtFonts.get(i2);
            if (!aWTGVTFont.canDisplay(c2) || aWTFontFamily.getFamilyName().indexOf("Song") != -1) continue;
            return aWTFontFamily;
        }
        return null;
    }

    static {
        Object object;
        String string;
        Object object2;
        defaultFont = new AWTFontFamily("SansSerif");
        fonts = new HashMap();
        awtFontFamilies = new ArrayList();
        awtFonts = new ArrayList();
        fonts.put("sans-serif", "SansSerif");
        fonts.put("serif", "Serif");
        fonts.put("times", "Serif");
        fonts.put("times new roman", "Serif");
        fonts.put("cursive", "Dialog");
        fonts.put("fantasy", "Symbol");
        fonts.put("monospace", "Monospaced");
        fonts.put("monospaced", "Monospaced");
        fonts.put("courier", "Monospaced");
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n2 = stringArray != null ? stringArray.length : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            fonts.put(stringArray[i2].toLowerCase(), stringArray[i2]);
            object2 = new StringTokenizer(stringArray[i2]);
            string = "";
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string = string + ((StringTokenizer)object2).nextToken();
            }
            fonts.put(string.toLowerCase(), stringArray[i2]);
            object = stringArray[i2].replace(' ', '-');
            if (((String)object).equals(stringArray[i2])) continue;
            fonts.put(((String)object).toLowerCase(), stringArray[i2]);
        }
        awtFontFamilies.add(defaultFont);
        awtFonts.add(new AWTGVTFont(defaultFont.getFamilyName(), 0, 12));
        Collection collection = fonts.values();
        object2 = collection.iterator();
        while (object2.hasNext()) {
            string = (String)object2.next();
            object = new AWTFontFamily(string);
            awtFontFamilies.add(object);
            AWTGVTFont aWTGVTFont = new AWTGVTFont(string, 0, 12);
            awtFonts.add(aWTGVTFont);
        }
        resolvedFontFamilies = new HashMap();
    }
}

