/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.font.FontFamilyResolver;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.renderer.BasicTextPainter;
import org.apache.batik.gvt.text.AttributedCharacterSpanIterator;
import org.apache.batik.gvt.text.BidiAttributedCharacterIterator;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;

public class StrokingTextPainter
extends BasicTextPainter {
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_ID = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_ID;
    public static final AttributedCharacterIterator.Attribute GVT_FONT = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT;
    public static final AttributedCharacterIterator.Attribute GVT_FONTS = GVTAttributedCharacterIterator.TextAttribute.GVT_FONTS;
    public static final AttributedCharacterIterator.Attribute BIDI_LEVEL = GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL;
    public static final AttributedCharacterIterator.Attribute XPOS = GVTAttributedCharacterIterator.TextAttribute.X;
    public static final AttributedCharacterIterator.Attribute YPOS = GVTAttributedCharacterIterator.TextAttribute.Y;
    public static final AttributedCharacterIterator.Attribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    public static final AttributedCharacterIterator.Attribute WRITING_MODE = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE;
    public static final Integer WRITING_MODE_TTB = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB;
    public static final Integer WRITING_MODE_RTL = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL;
    public static final AttributedCharacterIterator.Attribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    public static final Integer ADJUST_SPACING = GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING;
    public static final Integer ADJUST_ALL = GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL;
    public static final GVTAttributedCharacterIterator.TextAttribute ALT_GLYPH_HANDLER = GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER;
    static Set extendedAtts = new HashSet();
    protected static TextPainter singleton;

    public static TextPainter getInstance() {
        return singleton;
    }

    public void paint(TextNode textNode, Graphics2D graphics2D) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return;
        }
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        this.paintDecorations(list, graphics2D, 1);
        this.paintDecorations(list, graphics2D, 4);
        this.paintTextRuns(list, graphics2D);
        this.paintDecorations(list, graphics2D, 2);
    }

    protected void printAttrs(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        int n2 = attributedCharacterIterator.getBeginIndex();
        System.out.print("AttrRuns: ");
        while (attributedCharacterIterator.current() != '\uffff') {
            int n3 = attributedCharacterIterator.getRunLimit();
            System.out.print("" + (n3 - n2) + ", ");
            attributedCharacterIterator.setIndex(n3);
            n2 = n3;
        }
        System.out.println("");
    }

    public List getTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator) {
        List list = textNode.getTextRuns();
        if (list != null) {
            return list;
        }
        AttributedCharacterIterator[] attributedCharacterIteratorArray = this.getTextChunkACIs(attributedCharacterIterator);
        list = this.computeTextRuns(textNode, attributedCharacterIterator, attributedCharacterIteratorArray);
        textNode.setTextRuns(list);
        return textNode.getTextRuns();
    }

    public List computeTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, AttributedCharacterIterator[] attributedCharacterIteratorArray) {
        Object object;
        int[][] nArrayArray = new int[attributedCharacterIteratorArray.length][];
        int n2 = attributedCharacterIterator.getBeginIndex();
        for (int i2 = 0; i2 < attributedCharacterIteratorArray.length; ++i2) {
            object = new BidiAttributedCharacterIterator(attributedCharacterIteratorArray[i2], this.fontRenderContext, n2);
            attributedCharacterIteratorArray[i2] = object;
            nArrayArray[i2] = ((BidiAttributedCharacterIterator)object).getCharMap();
            attributedCharacterIteratorArray[i2] = StrokingTextPainter.createModifiedACIForFontMatching(attributedCharacterIteratorArray[i2]);
            n2 += attributedCharacterIteratorArray[i2].getEndIndex() - attributedCharacterIteratorArray[i2].getBeginIndex();
        }
        ArrayList arrayList = new ArrayList();
        Object object2 = null;
        int n3 = 0;
        Point2D point2D = textNode.getLocation();
        do {
            attributedCharacterIteratorArray[n3].first();
            object = this.getTextChunk(textNode, attributedCharacterIteratorArray[n3], nArrayArray[n3], arrayList, (TextChunk)object2);
            attributedCharacterIteratorArray[n3].first();
            if (object != null) {
                point2D = this.adjustChunkOffsets(point2D, arrayList, (TextChunk)object);
            }
            object2 = object;
        } while (object != null && ++n3 < attributedCharacterIteratorArray.length);
        return arrayList;
    }

    protected AttributedCharacterIterator[] getTextChunkACIs(AttributedCharacterIterator attributedCharacterIterator) {
        int n2;
        Object object;
        boolean bl;
        ArrayList<AttributedCharacterSpanIterator> arrayList = new ArrayList<AttributedCharacterSpanIterator>();
        int n3 = attributedCharacterIterator.getBeginIndex();
        attributedCharacterIterator.first();
        Object object2 = attributedCharacterIterator.getAttribute(WRITING_MODE);
        boolean bl2 = bl = object2 == WRITING_MODE_TTB;
        while (attributedCharacterIterator.setIndex(n3) != '\uffff') {
            object = null;
            int n4 = n3;
            n2 = 0;
            while (attributedCharacterIterator.setIndex(n4) != '\uffff') {
                Float f2;
                Serializable serializable;
                TextPath textPath = (TextPath)attributedCharacterIterator.getAttribute(TEXTPATH);
                if (n4 != n3) {
                    if (!bl ? (serializable = (Float)attributedCharacterIterator.getAttribute(XPOS)) != null && !serializable.isNaN() : (serializable = (Float)attributedCharacterIterator.getAttribute(YPOS)) != null && !serializable.isNaN()) break;
                    if (object == null && textPath != null || object != null && textPath == null) break;
                }
                object = textPath;
                if (attributedCharacterIterator.getAttribute(FLOW_PARAGRAPH) != null) {
                    n2 = attributedCharacterIterator.getRunLimit(FLOW_PARAGRAPH);
                    attributedCharacterIterator.setIndex(n2);
                    break;
                }
                n2 = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_ID);
                if (n4 == n3 && (serializable = (TextNode.Anchor)attributedCharacterIterator.getAttribute(ANCHOR_TYPE)) != TextNode.Anchor.START && !(bl ? (f2 = (Float)attributedCharacterIterator.getAttribute(YPOS)) == null || f2.isNaN() : (f2 = (Float)attributedCharacterIterator.getAttribute(XPOS)) == null || f2.isNaN())) {
                    int n5 = n4 + 1;
                    while (n5 < n2) {
                        Float f3;
                        attributedCharacterIterator.setIndex(n5);
                        if (bl ? (f3 = (Float)attributedCharacterIterator.getAttribute(YPOS)) == null || f3.isNaN() : (f3 = (Float)attributedCharacterIterator.getAttribute(XPOS)) == null || f3.isNaN()) break;
                        arrayList.add(new AttributedCharacterSpanIterator(attributedCharacterIterator, n5 - 1, n5));
                        n3 = n5++;
                    }
                }
                n4 = n2;
            }
            n4 = attributedCharacterIterator.getIndex();
            arrayList.add(new AttributedCharacterSpanIterator(attributedCharacterIterator, n3, n4));
            n3 = n4;
        }
        object = new AttributedCharacterIterator[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        n2 = 0;
        while (iterator.hasNext()) {
            object[n2] = (AttributedCharacterIterator)iterator.next();
            ++n2;
        }
        return object;
    }

    protected static AttributedCharacterIterator createModifiedACIForFontMatching(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        AttributedString attributedString = null;
        int n2 = 0;
        int n3 = attributedCharacterIterator.getBeginIndex();
        boolean bl = true;
        int n4 = attributedCharacterIterator.getRunStart(TEXT_COMPOUND_ID);
        while (bl) {
            int n5;
            GVTFont gVTFont;
            int n6;
            int n7 = n4;
            n4 = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_ID);
            int n8 = n4 - n7;
            List list = (List)attributedCharacterIterator.getAttribute(GVT_FONTS);
            float f2 = 12.0f;
            Float f3 = (Float)attributedCharacterIterator.getAttribute(TextAttribute.SIZE);
            if (f3 != null) {
                f2 = f3.floatValue();
            }
            if (list.size() == 0) {
                list.add(FontFamilyResolver.defaultFont.deriveFont(f2, attributedCharacterIterator));
            }
            boolean[] blArray = new boolean[n8];
            if (attributedString == null) {
                attributedString = new AttributedString(attributedCharacterIterator);
            }
            GVTFont gVTFont2 = null;
            int n9 = 0;
            int n10 = n7;
            for (n6 = 0; n6 < list.size(); ++n6) {
                int n11 = n10;
                boolean bl2 = false;
                attributedCharacterIterator.setIndex(n11);
                gVTFont = (GVTFont)list.get(n6);
                if (gVTFont2 == null) {
                    gVTFont2 = gVTFont;
                }
                while (n11 < n4) {
                    n5 = gVTFont.canDisplayUpTo(attributedCharacterIterator, n11, n4);
                    Object object = attributedCharacterIterator.getAttribute(ALT_GLYPH_HANDLER);
                    if (object != null) {
                        n5 = -1;
                    }
                    if (n5 == -1) {
                        n5 = n4;
                    }
                    if (n5 <= n11) {
                        if (!bl2) {
                            n10 = n11;
                            bl2 = true;
                        }
                        ++n11;
                        continue;
                    }
                    int n12 = -1;
                    for (int i2 = n11; i2 < n5; ++i2) {
                        if (blArray[i2 - n7]) {
                            if (n12 != -1) {
                                attributedString.addAttribute(GVT_FONT, gVTFont, n12 - n3, i2 - n3);
                                n12 = -1;
                            }
                        } else if (n12 == -1) {
                            n12 = i2;
                        }
                        blArray[i2 - n7] = true;
                        ++n9;
                    }
                    if (n12 != -1) {
                        attributedString.addAttribute(GVT_FONT, gVTFont, n12 - n3, n5 - n3);
                    }
                    n11 = n5 + 1;
                }
                if (n9 == n8) break;
            }
            n6 = -1;
            GVTFontFamily gVTFontFamily = null;
            gVTFont = gVTFont2;
            for (n5 = 0; n5 < n8; ++n5) {
                if (blArray[n5]) {
                    if (n6 == -1) continue;
                    attributedString.addAttribute(GVT_FONT, gVTFont, n6 + n2, n5 + n2);
                    n6 = -1;
                    gVTFont = null;
                    gVTFontFamily = null;
                    continue;
                }
                char c2 = attributedCharacterIterator.setIndex(n7 + n5);
                GVTFontFamily gVTFontFamily2 = FontFamilyResolver.getFamilyThatCanDisplay(c2);
                if (n6 == -1) {
                    n6 = n5;
                    gVTFontFamily = gVTFontFamily2;
                    if (gVTFontFamily == null) {
                        gVTFont = gVTFont2;
                        continue;
                    }
                    gVTFont = gVTFontFamily2.deriveFont(f2, attributedCharacterIterator);
                    continue;
                }
                if (gVTFontFamily == gVTFontFamily2) continue;
                attributedString.addAttribute(GVT_FONT, gVTFont, n6 + n2, n5 + n2);
                n6 = n5;
                gVTFontFamily = gVTFontFamily2;
                gVTFont = gVTFontFamily == null ? gVTFont2 : gVTFontFamily2.deriveFont(f2, attributedCharacterIterator);
            }
            if (n6 != -1) {
                attributedString.addAttribute(GVT_FONT, gVTFont, n6 + n2, n8 + n2);
            }
            n2 += n8;
            if (attributedCharacterIterator.setIndex(n4) == '\uffff') {
                bl = false;
            }
            n7 = n4;
        }
        if (attributedString != null) {
            return attributedString.getIterator();
        }
        return attributedCharacterIterator;
    }

    protected TextChunk getTextChunk(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, int[] nArray, List list, TextChunk textChunk) {
        int n2 = 0;
        if (textChunk != null) {
            n2 = textChunk.end;
        }
        int n3 = n2;
        int n4 = attributedCharacterIterator.getIndex();
        if (attributedCharacterIterator.current() == '\uffff') {
            return null;
        }
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 0.0f);
        boolean bl = true;
        TextSpanLayout textSpanLayout = null;
        while (true) {
            int n5 = attributedCharacterIterator.getRunStart(extendedAtts);
            int n6 = attributedCharacterIterator.getRunLimit(extendedAtts);
            AttributedCharacterSpanIterator attributedCharacterSpanIterator = new AttributedCharacterSpanIterator(attributedCharacterIterator, n5, n6);
            int[] nArray2 = new int[n6 - n5];
            System.arraycopy(nArray, n5 - n4, nArray2, 0, nArray2.length);
            FontRenderContext fontRenderContext = this.fontRenderContext;
            RenderingHints renderingHints = textNode.getRenderingHints();
            if (renderingHints != null && renderingHints.get(RenderingHints.KEY_TEXT_ANTIALIASING) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                fontRenderContext = this.aaOffFontRenderContext;
            }
            textSpanLayout = this.getTextLayoutFactory().createTextLayout(attributedCharacterSpanIterator, nArray2, float_, fontRenderContext);
            list.add(new TextRun(textSpanLayout, attributedCharacterSpanIterator, bl));
            Point2D point2D = textSpanLayout.getAdvance2D();
            float_2.x += (float)point2D.getX();
            float_2.y += (float)point2D.getY();
            ++n3;
            if (attributedCharacterIterator.setIndex(n6) == '\uffff') break;
            bl = false;
        }
        return new TextChunk(n2, n3, float_2);
    }

    protected Point2D adjustChunkOffsets(Point2D point2D, List list, TextChunk textChunk) {
        Point2D.Float float_;
        TextRun textRun = (TextRun)list.get(textChunk.begin);
        int n2 = textRun.getAnchorType();
        Float f2 = textRun.getLength();
        Integer n3 = textRun.getLengthAdjust();
        boolean bl = true;
        if (f2 == null || f2.isNaN()) {
            bl = false;
        }
        int n4 = 0;
        for (int i2 = textChunk.begin; i2 < textChunk.end; ++i2) {
            textRun = (TextRun)list.get(i2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            n4 += attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        }
        if (n3 == GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING && n4 == 1) {
            bl = false;
        }
        float f3 = 1.0f;
        float f4 = 1.0f;
        textRun = (TextRun)list.get(textChunk.end - 1);
        TextSpanLayout textSpanLayout = textRun.getLayout();
        GVTGlyphMetrics gVTGlyphMetrics = textSpanLayout.getGlyphMetrics(textSpanLayout.getGlyphCount() - 1);
        GVTLineMetrics gVTLineMetrics = textSpanLayout.getLineMetrics();
        Rectangle2D rectangle2D = gVTGlyphMetrics.getBounds2D();
        float f5 = (gVTGlyphMetrics.getVerticalAdvance() - (gVTLineMetrics.getAscent() + gVTLineMetrics.getDescent())) / 2.0f;
        float f6 = (float)(rectangle2D.getWidth() + rectangle2D.getX());
        float f7 = (float)((double)(f5 + gVTLineMetrics.getAscent()) + (rectangle2D.getHeight() + rectangle2D.getY()));
        if (!bl) {
            float_ = new Point2D.Float((float)(textChunk.advance.getX() + (double)f6 - (double)gVTGlyphMetrics.getHorizontalAdvance()), (float)(textChunk.advance.getY() - (double)gVTGlyphMetrics.getVerticalAdvance() + (double)f7));
        } else {
            double d2;
            Point2D point2D2 = textChunk.advance;
            if (textSpanLayout.isVertical()) {
                if (n3 == ADJUST_SPACING) {
                    f4 = (float)((double)(f2.floatValue() - f7) / (point2D2.getY() - (double)gVTGlyphMetrics.getVerticalAdvance()));
                } else {
                    d2 = point2D2.getY() - (double)gVTGlyphMetrics.getVerticalAdvance() + (double)f7;
                    f4 = (float)((double)f2.floatValue() / d2);
                }
                float_ = new Point2D.Float(0.0f, f2.floatValue());
            } else {
                if (n3 == ADJUST_SPACING) {
                    f3 = (float)((double)(f2.floatValue() - f6) / (point2D2.getX() - (double)gVTGlyphMetrics.getHorizontalAdvance()));
                } else {
                    d2 = point2D2.getX() + (double)f6 - (double)gVTGlyphMetrics.getHorizontalAdvance();
                    f3 = (float)((double)f2.floatValue() / d2);
                }
                float_ = new Point2D.Float(f2.floatValue(), 0.0f);
            }
            Point2D.Float float_2 = new Point2D.Float(0.0f, 0.0f);
            for (int i3 = textChunk.begin; i3 < textChunk.end; ++i3) {
                textRun = (TextRun)list.get(i3);
                textSpanLayout = textRun.getLayout();
                textSpanLayout.setScale(f3, f4, n3 == ADJUST_SPACING);
                Point2D point2D3 = textSpanLayout.getAdvance2D();
                float_2.x += (float)point2D3.getX();
                float_2.y += (float)point2D3.getY();
            }
            textChunk.advance = float_2;
        }
        float f8 = 0.0f;
        float f9 = 0.0f;
        switch (n2) {
            case 1: {
                f8 = (float)(-((Point2D)float_).getX() / 2.0);
                f9 = (float)(-((Point2D)float_).getY() / 2.0);
                break;
            }
            case 2: {
                f8 = (float)(-((Point2D)float_).getX());
                f9 = (float)(-((Point2D)float_).getY());
                break;
            }
        }
        textRun = (TextRun)list.get(textChunk.begin);
        textSpanLayout = textRun.getLayout();
        AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
        attributedCharacterIterator.first();
        boolean bl2 = textSpanLayout.isVertical();
        Float f10 = (Float)attributedCharacterIterator.getAttribute(XPOS);
        Float f11 = (Float)attributedCharacterIterator.getAttribute(YPOS);
        TextPath textPath = (TextPath)attributedCharacterIterator.getAttribute(TEXTPATH);
        float f12 = (float)point2D.getX();
        float f13 = (float)point2D.getY();
        float f14 = 0.0f;
        float f15 = 0.0f;
        if (f10 != null && !f10.isNaN()) {
            f14 = f12 = f10.floatValue();
        }
        if (f11 != null && !f11.isNaN()) {
            f15 = f13 = f11.floatValue();
        }
        if (bl2) {
            f13 += f9;
            f15 += f9;
            f14 = 0.0f;
        } else {
            f12 += f8;
            f14 += f8;
            f15 = 0.0f;
        }
        for (int i4 = textChunk.begin; i4 < textChunk.end; ++i4) {
            Point2D point2D4;
            textRun = (TextRun)list.get(i4);
            textSpanLayout = textRun.getLayout();
            attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            textPath = (TextPath)attributedCharacterIterator.getAttribute(TEXTPATH);
            if (bl2) {
                f10 = (Float)attributedCharacterIterator.getAttribute(XPOS);
                if (f10 != null && !f10.isNaN()) {
                    f12 = f10.floatValue();
                }
            } else {
                f11 = (Float)attributedCharacterIterator.getAttribute(YPOS);
                if (f11 != null && !f11.isNaN()) {
                    f13 = f11.floatValue();
                }
            }
            if (textPath == null) {
                textSpanLayout.setOffset(new Point2D.Float(f12, f13));
                point2D4 = textSpanLayout.getAdvance2D();
                f12 = (float)((double)f12 + point2D4.getX());
                f13 = (float)((double)f13 + point2D4.getY());
                continue;
            }
            textSpanLayout.setOffset(new Point2D.Float(f14, f15));
            point2D4 = textSpanLayout.getAdvance2D();
            f14 += (float)point2D4.getX();
            f15 += (float)point2D4.getY();
            point2D4 = textSpanLayout.getTextPathAdvance();
            f12 = (float)point2D4.getX();
            f13 = (float)point2D4.getY();
        }
        return new Point2D.Float(f12, f13);
    }

    protected void paintDecorations(List list, Graphics2D graphics2D, int n2) {
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        RectangularShape rectangularShape = null;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Rectangle2D rectangle2D;
            Shape shape;
            TextRun textRun = (TextRun)list.get(i2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null && textPaintInfo.composite != null) {
                graphics2D.setComposite(textPaintInfo.composite);
            }
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            if (textPaintInfo != null) {
                switch (n2) {
                    case 1: {
                        paint3 = textPaintInfo.underlinePaint;
                        stroke2 = textPaintInfo.underlineStroke;
                        paint4 = textPaintInfo.underlineStrokePaint;
                        break;
                    }
                    case 4: {
                        paint3 = textPaintInfo.overlinePaint;
                        stroke2 = textPaintInfo.overlineStroke;
                        paint4 = textPaintInfo.overlineStrokePaint;
                        break;
                    }
                    case 2: {
                        paint3 = textPaintInfo.strikethroughPaint;
                        stroke2 = textPaintInfo.strikethroughStroke;
                        paint4 = textPaintInfo.strikethroughStrokePaint;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (textRun.isFirstRunInChunk()) {
                shape = textRun.getLayout().getDecorationOutline(n2);
                rectangle2D = shape.getBounds2D();
                d2 = rectangle2D.getY();
                d3 = rectangle2D.getHeight();
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangularShape != null) {
                if (paint != null) {
                    graphics2D.setPaint(paint);
                    graphics2D.fill(rectangularShape);
                }
                if (stroke != null && paint2 != null) {
                    graphics2D.setPaint(paint2);
                    graphics2D.setStroke(stroke);
                    graphics2D.draw(rectangularShape);
                }
                rectangularShape = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                shape = textRun.getLayout().getDecorationOutline(n2);
                if (rectangularShape == null) {
                    rectangle2D = shape.getBounds2D();
                    rectangularShape = new Rectangle2D.Double(rectangle2D.getX(), d2, rectangle2D.getWidth(), d3);
                } else {
                    rectangle2D = shape.getBounds2D();
                    double d4 = Math.min(rectangularShape.getX(), rectangle2D.getX());
                    double d5 = Math.max(rectangularShape.getMaxX(), rectangle2D.getMaxX());
                    ((Rectangle2D)rectangularShape).setRect(d4, d2, d5 - d4, d3);
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
        }
        if (rectangularShape != null) {
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fill(rectangularShape);
            }
            if (stroke != null && paint2 != null) {
                graphics2D.setPaint(paint2);
                graphics2D.setStroke(stroke);
                graphics2D.draw(rectangularShape);
            }
        }
    }

    protected void paintTextRuns(List list, Graphics2D graphics2D) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            TextRun textRun = (TextRun)list.get(i2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null && textPaintInfo.composite != null) {
                graphics2D.setComposite(textPaintInfo.composite);
            }
            textRun.getLayout().draw(graphics2D);
        }
    }

    public Shape getOutline(TextNode textNode) {
        Object object;
        Object object2;
        GeneralPath generalPath = null;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object2 = (TextRun)list.get(i2);
            object = ((TextRun)object2).getLayout();
            GeneralPath generalPath2 = new GeneralPath(object.getOutline());
            if (generalPath == null) {
                generalPath = generalPath2;
                continue;
            }
            generalPath.setWindingRule(1);
            generalPath.append(generalPath2, false);
        }
        Shape shape = this.getDecorationOutline(list, 1);
        object2 = this.getDecorationOutline(list, 2);
        object = this.getDecorationOutline(list, 4);
        if (shape != null) {
            if (generalPath == null) {
                generalPath = new GeneralPath(shape);
            } else {
                generalPath.setWindingRule(1);
                generalPath.append(shape, false);
            }
        }
        if (object2 != null) {
            if (generalPath == null) {
                generalPath = new GeneralPath((Shape)object2);
            } else {
                generalPath.setWindingRule(1);
                generalPath.append((Shape)object2, false);
            }
        }
        if (object != null) {
            if (generalPath == null) {
                generalPath = new GeneralPath((Shape)object);
            } else {
                generalPath.setWindingRule(1);
                generalPath.append((Shape)object, false);
            }
        }
        return generalPath;
    }

    public Rectangle2D getBounds2D(TextNode textNode) {
        Object object;
        Object object2;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        Rectangle2D rectangle2D = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object2 = (TextRun)list.get(i2);
            object = ((TextRun)object2).getLayout();
            Rectangle2D rectangle2D2 = object.getBounds2D();
            if (rectangle2D2 == null) continue;
            if (rectangle2D == null) {
                rectangle2D = rectangle2D2;
                continue;
            }
            rectangle2D.add(rectangle2D2);
        }
        Shape shape = this.getDecorationStrokeOutline(list, 1);
        if (shape != null) {
            if (rectangle2D == null) {
                rectangle2D = shape.getBounds2D();
            } else {
                rectangle2D.add(shape.getBounds2D());
            }
        }
        if ((object2 = this.getDecorationStrokeOutline(list, 2)) != null) {
            if (rectangle2D == null) {
                rectangle2D = object2.getBounds2D();
            } else {
                rectangle2D.add(object2.getBounds2D());
            }
        }
        if ((object = this.getDecorationStrokeOutline(list, 4)) != null) {
            if (rectangle2D == null) {
                rectangle2D = object.getBounds2D();
            } else {
                rectangle2D.add(object.getBounds2D());
            }
        }
        return rectangle2D;
    }

    protected Shape getDecorationOutline(List list, int n2) {
        Path2D path2D = null;
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        RectangularShape rectangularShape = null;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Rectangle2D rectangle2D;
            Shape shape;
            TextRun textRun = (TextRun)list.get(i2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null) {
                switch (n2) {
                    case 1: {
                        paint3 = textPaintInfo.underlinePaint;
                        stroke2 = textPaintInfo.underlineStroke;
                        paint4 = textPaintInfo.underlineStrokePaint;
                        break;
                    }
                    case 4: {
                        paint3 = textPaintInfo.overlinePaint;
                        stroke2 = textPaintInfo.overlineStroke;
                        paint4 = textPaintInfo.overlineStrokePaint;
                        break;
                    }
                    case 2: {
                        paint3 = textPaintInfo.strikethroughPaint;
                        stroke2 = textPaintInfo.strikethroughStroke;
                        paint4 = textPaintInfo.strikethroughStrokePaint;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (textRun.isFirstRunInChunk()) {
                shape = textRun.getLayout().getDecorationOutline(n2);
                rectangle2D = shape.getBounds2D();
                d2 = rectangle2D.getY();
                d3 = rectangle2D.getHeight();
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangularShape != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(rectangularShape);
                } else {
                    path2D.append(rectangularShape, false);
                }
                rectangularShape = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                shape = textRun.getLayout().getDecorationOutline(n2);
                if (rectangularShape == null) {
                    rectangle2D = shape.getBounds2D();
                    rectangularShape = new Rectangle2D.Double(rectangle2D.getX(), d2, rectangle2D.getWidth(), d3);
                } else {
                    rectangle2D = shape.getBounds2D();
                    double d4 = Math.min(rectangularShape.getX(), rectangle2D.getX());
                    double d5 = Math.max(rectangularShape.getMaxX(), rectangle2D.getMaxX());
                    ((Rectangle2D)rectangularShape).setRect(d4, d2, d5 - d4, d3);
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
        }
        if (rectangularShape != null) {
            if (path2D == null) {
                path2D = new GeneralPath(rectangularShape);
            } else {
                path2D.append(rectangularShape, false);
            }
        }
        return path2D;
    }

    protected Shape getDecorationStrokeOutline(List list, int n2) {
        Path2D path2D = null;
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        Shape shape = null;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Rectangle2D rectangle2D;
            Shape shape2;
            TextRun textRun = (TextRun)list.get(i2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null) {
                switch (n2) {
                    case 1: {
                        paint3 = textPaintInfo.underlinePaint;
                        stroke2 = textPaintInfo.underlineStroke;
                        paint4 = textPaintInfo.underlineStrokePaint;
                        break;
                    }
                    case 4: {
                        paint3 = textPaintInfo.overlinePaint;
                        stroke2 = textPaintInfo.overlineStroke;
                        paint4 = textPaintInfo.overlineStrokePaint;
                        break;
                    }
                    case 2: {
                        paint3 = textPaintInfo.strikethroughPaint;
                        stroke2 = textPaintInfo.strikethroughStroke;
                        paint4 = textPaintInfo.strikethroughStrokePaint;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (textRun.isFirstRunInChunk()) {
                shape2 = textRun.getLayout().getDecorationOutline(n2);
                rectangle2D = shape2.getBounds2D();
                d2 = rectangle2D.getY();
                d3 = rectangle2D.getHeight();
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && shape != null) {
                shape2 = null;
                if (stroke != null && paint2 != null) {
                    shape2 = stroke.createStrokedShape(shape);
                } else if (paint != null) {
                    shape2 = shape;
                }
                if (shape2 != null) {
                    if (path2D == null) {
                        path2D = new GeneralPath(shape2);
                    } else {
                        path2D.append(shape2, false);
                    }
                }
                shape = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                shape2 = textRun.getLayout().getDecorationOutline(n2);
                if (shape == null) {
                    rectangle2D = shape2.getBounds2D();
                    shape = new Rectangle2D.Double(rectangle2D.getX(), d2, rectangle2D.getWidth(), d3);
                } else {
                    rectangle2D = shape2.getBounds2D();
                    double d4 = Math.min(((RectangularShape)shape).getX(), rectangle2D.getX());
                    double d5 = Math.max(((RectangularShape)shape).getMaxX(), rectangle2D.getMaxX());
                    ((Rectangle2D)shape).setRect(d4, d2, d5 - d4, d3);
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
        }
        if (shape != null) {
            Shape shape3 = null;
            if (stroke != null && paint2 != null) {
                shape3 = stroke.createStrokedShape(shape);
            } else if (paint != null) {
                shape3 = shape;
            }
            if (shape3 != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(shape3);
                } else {
                    path2D.append(shape3, false);
                }
            }
        }
        return path2D;
    }

    public Mark getMark(TextNode textNode, int n2, boolean bl) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        if (n2 < attributedCharacterIterator.getBeginIndex() || n2 > attributedCharacterIterator.getEndIndex()) {
            return null;
        }
        TextHit textHit = new TextHit(n2, bl);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    protected Mark hitTest(double d2, double d3, TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            TextRun textRun = (TextRun)list.get(i2);
            TextSpanLayout textSpanLayout = textRun.getLayout();
            TextHit textHit = textSpanLayout.hitTestChar((float)d2, (float)d3);
            if (textHit == null || !textSpanLayout.getBounds2D().contains(d2, d3)) continue;
            return new BasicTextPainter.BasicMark(textNode, textHit);
        }
        return null;
    }

    public Mark selectFirst(TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        TextHit textHit = new TextHit(attributedCharacterIterator.getBeginIndex(), false);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    public Mark selectLast(TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        TextHit textHit = new TextHit(attributedCharacterIterator.getEndIndex() - 1, false);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    public int[] getSelected(Mark mark, Mark mark2) {
        BasicTextPainter.BasicMark basicMark;
        BasicTextPainter.BasicMark basicMark2;
        if (mark == null || mark2 == null) {
            return null;
        }
        try {
            basicMark2 = (BasicTextPainter.BasicMark)mark;
            basicMark = (BasicTextPainter.BasicMark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new Error("This Mark was not instantiated by this TextPainter class!");
        }
        TextNode textNode = basicMark2.getTextNode();
        if (textNode == null) {
            return null;
        }
        if (textNode != basicMark.getTextNode()) {
            throw new Error("Markers are from different TextNodes!");
        }
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        int[] nArray = new int[]{basicMark2.getHit().getCharIndex(), basicMark.getHit().getCharIndex()};
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        Iterator iterator = list.iterator();
        int n2 = -1;
        int n3 = -1;
        TextSpanLayout textSpanLayout = null;
        TextSpanLayout textSpanLayout2 = null;
        while (iterator.hasNext()) {
            TextRun textRun = (TextRun)iterator.next();
            TextSpanLayout textSpanLayout3 = textRun.getLayout();
            if (n2 == -1 && (n2 = textSpanLayout3.getGlyphIndex(nArray[0])) != -1) {
                textSpanLayout = textSpanLayout3;
            }
            if (n3 == -1 && (n3 = textSpanLayout3.getGlyphIndex(nArray[1])) != -1) {
                textSpanLayout2 = textSpanLayout3;
            }
            if (n2 == -1 || n3 == -1) continue;
        }
        if (textSpanLayout == null || textSpanLayout2 == null) {
            return null;
        }
        int n4 = textSpanLayout.getCharacterCount(n2, n2);
        int n5 = textSpanLayout2.getCharacterCount(n3, n3);
        if (n4 > 1) {
            if (nArray[0] > nArray[1] && textSpanLayout.isLeftToRight()) {
                nArray[0] = nArray[0] + (n4 - 1);
            } else if (nArray[1] > nArray[0] && !textSpanLayout.isLeftToRight()) {
                nArray[0] = nArray[0] - (n4 - 1);
            }
        }
        if (n5 > 1) {
            if (nArray[1] > nArray[0] && textSpanLayout2.isLeftToRight()) {
                nArray[1] = nArray[1] + (n5 - 1);
            } else if (nArray[0] > nArray[1] && !textSpanLayout2.isLeftToRight()) {
                nArray[1] = nArray[1] - (n5 - 1);
            }
        }
        return nArray;
    }

    public Shape getHighlightShape(Mark mark, Mark mark2) {
        Object object;
        int n2;
        BasicTextPainter.BasicMark basicMark;
        BasicTextPainter.BasicMark basicMark2;
        if (mark == null || mark2 == null) {
            return null;
        }
        try {
            basicMark2 = (BasicTextPainter.BasicMark)mark;
            basicMark = (BasicTextPainter.BasicMark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new Error("This Mark was not instantiated by this TextPainter class!");
        }
        TextNode textNode = basicMark2.getTextNode();
        if (textNode == null) {
            return null;
        }
        if (textNode != basicMark.getTextNode()) {
            throw new Error("Markers are from different TextNodes!");
        }
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        int n3 = basicMark2.getHit().getCharIndex();
        if (n3 > (n2 = basicMark.getHit().getCharIndex())) {
            object = basicMark2;
            basicMark2 = basicMark;
            basicMark = object;
            int n4 = n3;
            n3 = n2;
            n2 = n4;
        }
        object = this.getTextRuns(textNode, attributedCharacterIterator);
        GeneralPath generalPath = new GeneralPath();
        for (int i2 = 0; i2 < object.size(); ++i2) {
            TextRun textRun = (TextRun)object.get(i2);
            TextSpanLayout textSpanLayout = textRun.getLayout();
            Shape shape = textSpanLayout.getHighlightShape(n3, n2);
            if (shape == null || shape.getBounds().isEmpty()) continue;
            generalPath.append(shape, false);
        }
        return generalPath;
    }

    static {
        extendedAtts.add(FLOW_PARAGRAPH);
        extendedAtts.add(TEXT_COMPOUND_ID);
        extendedAtts.add(GVT_FONT);
        singleton = new StrokingTextPainter();
    }

    public class TextRun {
        protected AttributedCharacterIterator aci;
        protected TextSpanLayout layout;
        protected int anchorType;
        protected boolean firstRunInChunk;
        protected Float length;
        protected Integer lengthAdjust;

        public TextRun(TextSpanLayout textSpanLayout, AttributedCharacterIterator attributedCharacterIterator, boolean bl) {
            this.layout = textSpanLayout;
            this.aci = attributedCharacterIterator;
            this.aci.first();
            this.firstRunInChunk = bl;
            this.anchorType = 0;
            TextNode.Anchor anchor = (TextNode.Anchor)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
            if (anchor != null) {
                this.anchorType = anchor.getType();
            }
            if (attributedCharacterIterator.getAttribute(WRITING_MODE) == WRITING_MODE_RTL) {
                if (this.anchorType == 0) {
                    this.anchorType = 2;
                } else if (this.anchorType == 2) {
                    this.anchorType = 0;
                }
            }
            this.length = (Float)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH);
            this.lengthAdjust = (Integer)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST);
        }

        public AttributedCharacterIterator getACI() {
            return this.aci;
        }

        public TextSpanLayout getLayout() {
            return this.layout;
        }

        public int getAnchorType() {
            return this.anchorType;
        }

        public Float getLength() {
            return this.length;
        }

        public Integer getLengthAdjust() {
            return this.lengthAdjust;
        }

        public boolean isFirstRunInChunk() {
            return this.firstRunInChunk;
        }
    }

    class TextChunk {
        public int begin;
        public int end;
        public Point2D advance;

        public TextChunk(int n2, int n3, Point2D point2D) {
            this.begin = n2;
            this.end = n3;
            this.advance = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
        }
    }
}

