/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.Set;

public class AttributedCharacterSpanIterator
implements AttributedCharacterIterator {
    private AttributedCharacterIterator aci;
    private int begin;
    private int end;

    public AttributedCharacterSpanIterator(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        this.aci = attributedCharacterIterator;
        this.end = Math.min(attributedCharacterIterator.getEndIndex(), n3);
        this.begin = Math.max(attributedCharacterIterator.getBeginIndex(), n2);
        this.aci.setIndex(this.begin);
    }

    public Set getAllAttributeKeys() {
        return this.aci.getAllAttributeKeys();
    }

    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        return this.aci.getAttribute(attribute);
    }

    public Map getAttributes() {
        return this.aci.getAttributes();
    }

    public int getRunLimit() {
        return Math.min(this.aci.getRunLimit(), this.end);
    }

    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        return Math.min(this.aci.getRunLimit(attribute), this.end);
    }

    public int getRunLimit(Set set) {
        return Math.min(this.aci.getRunLimit(set), this.end);
    }

    public int getRunStart() {
        return Math.max(this.aci.getRunStart(), this.begin);
    }

    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        return Math.max(this.aci.getRunStart(attribute), this.begin);
    }

    public int getRunStart(Set set) {
        return Math.max(this.aci.getRunStart(set), this.begin);
    }

    public Object clone() {
        return new AttributedCharacterSpanIterator((AttributedCharacterIterator)this.aci.clone(), this.begin, this.end);
    }

    public char current() {
        return this.aci.current();
    }

    public char first() {
        return this.aci.setIndex(this.begin);
    }

    public int getBeginIndex() {
        return this.begin;
    }

    public int getEndIndex() {
        return this.end;
    }

    public int getIndex() {
        return this.aci.getIndex();
    }

    public char last() {
        return this.setIndex(this.end - 1);
    }

    public char next() {
        if (this.getIndex() < this.end - 1) {
            return this.aci.next();
        }
        return this.setIndex(this.end);
    }

    public char previous() {
        if (this.getIndex() > this.begin) {
            return this.aci.previous();
        }
        return '\uffff';
    }

    public char setIndex(int n2) {
        int n3 = Math.max(n2, this.begin);
        n3 = Math.min(n3, this.end);
        int n4 = this.aci.setIndex(n3);
        if (n3 == this.end) {
            n4 = 65535;
        }
        return (char)n4;
    }
}

