/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.Table;

public class HmtxTable
implements Table {
    private byte[] buf = null;
    private int[] hMetrics = null;
    private short[] leftSideBearing = null;

    protected HmtxTable(DirectoryEntry directoryEntry, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(directoryEntry.getOffset());
        this.buf = new byte[directoryEntry.getLength()];
        randomAccessFile.read(this.buf);
    }

    public void init(int n2, int n3) {
        int n4;
        if (this.buf == null) {
            return;
        }
        this.hMetrics = new int[n2];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf);
        for (n4 = 0; n4 < n2; ++n4) {
            this.hMetrics[n4] = byteArrayInputStream.read() << 24 | byteArrayInputStream.read() << 16 | byteArrayInputStream.read() << 8 | byteArrayInputStream.read();
        }
        if (n3 > 0) {
            this.leftSideBearing = new short[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                this.leftSideBearing[n4] = (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read());
            }
        }
        this.buf = null;
    }

    public int getAdvanceWidth(int n2) {
        if (this.hMetrics == null) {
            return 0;
        }
        if (n2 < this.hMetrics.length) {
            return this.hMetrics[n2] >> 16;
        }
        return this.hMetrics[this.hMetrics.length - 1] >> 16;
    }

    public short getLeftSideBearing(int n2) {
        if (this.hMetrics == null) {
            return 0;
        }
        if (n2 < this.hMetrics.length) {
            return (short)(this.hMetrics[n2] & 0xFFFF);
        }
        return this.leftSideBearing[n2 - this.hMetrics.length];
    }

    public int getType() {
        return 1752003704;
    }
}

