/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.apache.batik.swing.gvt.JGVTComponent;

public class AbstractRotateInteractor
extends InteractorAdapter {
    protected boolean finished;
    protected double initialRotation;

    public boolean endInteraction() {
        return this.finished;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.finished = false;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        Dimension dimension = jGVTComponent.getSize();
        double d2 = mouseEvent.getX() - dimension.width / 2;
        double d3 = mouseEvent.getY() - dimension.height / 2;
        double d4 = -d3 / Math.sqrt(d2 * d2 + d3 * d3);
        this.initialRotation = d2 > 0.0 ? Math.acos(d4) : -Math.acos(d4);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.finished = true;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        AffineTransform affineTransform = this.rotateTransform(jGVTComponent.getSize(), mouseEvent.getX(), mouseEvent.getY());
        affineTransform.concatenate(jGVTComponent.getRenderingTransform());
        jGVTComponent.setRenderingTransform(affineTransform);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.finished = true;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        jGVTComponent.setPaintingTransform(null);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        jGVTComponent.setPaintingTransform(this.rotateTransform(jGVTComponent.getSize(), mouseEvent.getX(), mouseEvent.getY()));
    }

    protected AffineTransform rotateTransform(Dimension dimension, int n2, int n3) {
        double d2 = n2 - dimension.width / 2;
        double d3 = n3 - dimension.height / 2;
        double d4 = -d3 / Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = d2 > 0.0 ? Math.acos(d4) : -Math.acos(d4);
        return AffineTransform.getRotateInstance(d5 -= this.initialRotation, dimension.width / 2, dimension.height / 2);
    }
}

