/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.PaintKey;
import org.w3c.dom.Document;

public abstract class ImageTranscoder
extends SVGAbstractTranscoder {
    public static final TranscodingHints.Key KEY_BACKGROUND_COLOR = new PaintKey();
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = new BooleanKey();

    protected ImageTranscoder() {
    }

    protected void transcode(Document document, String string, TranscoderOutput transcoderOutput) throws TranscoderException {
        super.transcode(document, string, transcoderOutput);
        int n2 = (int)((double)this.width + 0.5);
        int n3 = (int)((double)this.height + 0.5);
        ImageRenderer imageRenderer = this.createRenderer();
        imageRenderer.updateOffScreen(n2, n3);
        imageRenderer.setTransform(this.curTxf);
        imageRenderer.setTree(this.root);
        this.root = null;
        try {
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            imageRenderer.repaint(this.curTxf.createInverse().createTransformedShape(float_));
            BufferedImage bufferedImage = imageRenderer.getOffScreen();
            imageRenderer = null;
            BufferedImage bufferedImage2 = this.createImage(n2, n3);
            Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage2);
            if (this.hints.containsKey(KEY_BACKGROUND_COLOR)) {
                Paint paint = (Paint)this.hints.get(KEY_BACKGROUND_COLOR);
                graphics2D.setComposite(AlphaComposite.SrcOver);
                graphics2D.setPaint(paint);
                graphics2D.fillRect(0, 0, n2, n3);
            }
            if (bufferedImage != null) {
                graphics2D.drawRenderedImage(bufferedImage, new AffineTransform());
            }
            graphics2D.dispose();
            bufferedImage = null;
            this.writeImage(bufferedImage2, transcoderOutput);
        }
        catch (Exception exception) {
            throw new TranscoderException(exception);
        }
    }

    protected ImageRenderer createRenderer() {
        ConcreteImageRendererFactory concreteImageRendererFactory = new ConcreteImageRendererFactory();
        return concreteImageRendererFactory.createStaticImageRenderer();
    }

    protected void forceTransparentWhite(BufferedImage bufferedImage, SinglePixelPackedSampleModel singlePixelPackedSampleModel) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int n4 = singlePixelPackedSampleModel.getScanlineStride();
        int n5 = dataBufferInt.getOffset();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n6 = n5;
        int n7 = n4 - n2;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                n12 = nArray[n6];
                n8 = n12 >> 24 & 0xFF;
                n9 = n12 >> 16 & 0xFF;
                n10 = n12 >> 8 & 0xFF;
                n11 = n12 & 0xFF;
                n9 = (255 * (255 - n8) + n8 * n9) / 255;
                n10 = (255 * (255 - n8) + n8 * n10) / 255;
                n11 = (255 * (255 - n8) + n8 * n11) / 255;
                nArray[n6++] = n8 << 24 & 0xFF000000 | n9 << 16 & 0xFF0000 | n10 << 8 & 0xFF00 | n11 & 0xFF;
            }
            n6 += n7;
        }
    }

    public abstract BufferedImage createImage(int var1, int var2);

    public abstract void writeImage(BufferedImage var1, TranscoderOutput var2) throws TranscoderException;
}

