/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.apache.batik.transcoder.wmf.tosvg.WMFFont;
import org.apache.batik.transcoder.wmf.tosvg.WMFRecordStore;

public class AbstractWMFPainter {
    public static final String WMF_FILE_EXTENSION = ".wmf";
    protected WMFFont wmfFont = null;
    protected int currentHorizAlign = 0;
    protected int currentVertAlign = 0;
    public static final int PEN = 1;
    public static final int BRUSH = 2;
    public static final int FONT = 3;
    public static final int NULL_PEN = 4;
    public static final int NULL_BRUSH = 5;
    public static final int PALETTE = 6;
    public static final int OBJ_BITMAP = 7;
    public static final int OBJ_REGION = 8;
    protected WMFRecordStore currentStore;
    protected transient boolean bReadingWMF = true;
    protected transient BufferedInputStream bufStream = null;

    protected BufferedImage getImage(byte[] byArray, int n2, int n3) {
        int n4 = (byArray[7] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
        int n5 = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
        if (n2 != n4 || n3 != n5) {
            return null;
        }
        return this.getImage(byArray);
    }

    protected Dimension getImageDimension(byte[] byArray) {
        int n2 = (byArray[7] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
        int n3 = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
        return new Dimension(n2, n3);
    }

    protected BufferedImage getImage(byte[] byArray) {
        int n2 = (byArray[7] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
        int n3 = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
        int[] nArray = new int[n2 * n3];
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n4 = (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        int n5 = (byArray[13] & 0xFF) << 8 | byArray[12] & 0xFF;
        int n6 = (byArray[15] & 0xFF) << 8 | byArray[14] & 0xFF;
        int n7 = (byArray[23] & 0xFF) << 24 | (byArray[22] & 0xFF) << 16 | (byArray[21] & 0xFF) << 8 | byArray[20] & 0xFF;
        if (n7 == 0) {
            n7 = ((n2 * n6 + 31 & 0xFFFFFFE0) >> 3) * n3;
        }
        int n8 = (byArray[35] & 0xFF) << 24 | (byArray[34] & 0xFF) << 16 | (byArray[33] & 0xFF) << 8 | byArray[32] & 0xFF;
        if (n6 == 24) {
            int n9 = n7 / n3 - n2 * 3;
            int n10 = n4;
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    nArray[n2 * (n3 - i2 - 1) + i3] = 0xFF000000 | (byArray[n10 + 2] & 0xFF) << 16 | (byArray[n10 + 1] & 0xFF) << 8 | byArray[n10] & 0xFF;
                    n10 += 3;
                }
                n10 += n9;
            }
        } else if (n6 == 8) {
            int n11;
            int n12 = 0;
            n12 = n8 > 0 ? n8 : 256;
            int n13 = n4;
            int[] nArray2 = new int[n12];
            for (n11 = 0; n11 < n12; ++n11) {
                nArray2[n11] = 0xFF000000 | (byArray[n13 + 2] & 0xFF) << 16 | (byArray[n13 + 1] & 0xFF) << 8 | byArray[n13] & 0xFF;
                n13 += 4;
            }
            n7 = byArray.length - n13;
            n11 = n7 / n3 - n2;
            for (int i4 = 0; i4 < n3; ++i4) {
                for (int i5 = 0; i5 < n2; ++i5) {
                    nArray[n2 * (n3 - i4 - 1) + i5] = nArray2[byArray[n13] & 0xFF];
                    ++n13;
                }
                n13 += n11;
            }
        } else if (n6 == 1) {
            int n14;
            int n15 = 2;
            int n16 = n4;
            int[] nArray3 = new int[n15];
            for (n14 = 0; n14 < n15; ++n14) {
                nArray3[n14] = 0xFF000000 | (byArray[n16 + 2] & 0xFF) << 16 | (byArray[n16 + 1] & 0xFF) << 8 | byArray[n16] & 0xFF;
                n16 += 4;
            }
            n14 = 7;
            byte by = byArray[n16];
            int n17 = n7 / n3 - n2 / 8;
            for (int i6 = 0; i6 < n3; ++i6) {
                for (int i7 = 0; i7 < n2; ++i7) {
                    nArray[n2 * (n3 - i6 - 1) + i7] = (by & 1 << n14) != 0 ? nArray3[1] : nArray3[0];
                    if (--n14 != -1) continue;
                    n14 = 7;
                    by = byArray[++n16];
                }
                n14 = 7;
                if ((n16 += n17) >= byArray.length) continue;
                by = byArray[n16];
            }
        }
        writableRaster.setDataElements(0, 0, n2, n3, nArray);
        return bufferedImage;
    }

    protected AttributedCharacterIterator getCharacterIterator(Graphics2D graphics2D, String string, WMFFont wMFFont) {
        return this.getAttributedString(graphics2D, string, wMFFont).getIterator();
    }

    protected AttributedCharacterIterator getCharacterIterator(Graphics2D graphics2D, String string, WMFFont wMFFont, int n2) {
        AttributedString attributedString = this.getAttributedString(graphics2D, string, wMFFont);
        return attributedString.getIterator();
    }

    protected AttributedString getAttributedString(Graphics2D graphics2D, String string, WMFFont wMFFont) {
        AttributedString attributedString = new AttributedString(string);
        Font font = graphics2D.getFont();
        attributedString.addAttribute(TextAttribute.SIZE, new Float(font.getSize2D()));
        attributedString.addAttribute(TextAttribute.FONT, font);
        if (this.wmfFont.underline != 0) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.wmfFont.italic != 0) {
            attributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            attributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        }
        if (this.wmfFont.weight > 400) {
            attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        }
        return attributedString;
    }

    public void setRecordStore(WMFRecordStore wMFRecordStore) {
        if (wMFRecordStore == null) {
            throw new IllegalArgumentException();
        }
        this.currentStore = wMFRecordStore;
    }

    public WMFRecordStore getRecordStore() {
        return this.currentStore;
    }

    protected int addObject(WMFRecordStore wMFRecordStore, int n2, Object object) {
        return this.currentStore.addObject(n2, object);
    }

    protected int addObjectAt(WMFRecordStore wMFRecordStore, int n2, Object object, int n3) {
        return this.currentStore.addObjectAt(n2, object, n3);
    }
}

