/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.batik.ext.awt.geom.Polygon2D;
import org.apache.batik.ext.awt.geom.Polyline2D;
import org.apache.batik.transcoder.wmf.tosvg.AbstractWMFPainter;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;
import org.apache.batik.transcoder.wmf.tosvg.TextureFactory;
import org.apache.batik.transcoder.wmf.tosvg.WMFFont;
import org.apache.batik.transcoder.wmf.tosvg.WMFRecordStore;
import org.apache.batik.transcoder.wmf.tosvg.WMFUtilities;

public class WMFPainter
extends AbstractWMFPainter {
    private static final int INPUT_BUFFER_SIZE = 30720;
    private static final Integer INTEGER_0 = new Integer(0);
    private float scale;
    private float scaleX;
    private float scaleY;
    private float conv;
    private float xOffset;
    private float yOffset;
    private float vpX;
    private float vpY;
    private float vpW;
    private float vpH;
    private Color frgdColor;
    private Color bkgdColor;
    private boolean opaque = false;
    private transient boolean firstEffectivePaint = true;
    private static BasicStroke solid = new BasicStroke(1.0f, 0, 1);
    private static BasicStroke textSolid = new BasicStroke(1.0f, 0, 1);
    private transient ImageObserver observer = new ImageObserver(){

        public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
            return false;
        }
    };
    private transient BufferedInputStream bufStream = null;

    public WMFPainter(WMFRecordStore wMFRecordStore, float f2) {
        this(wMFRecordStore, 0, 0, f2);
    }

    public WMFPainter(WMFRecordStore wMFRecordStore, int n2, int n3, float f2) {
        this.setRecordStore(wMFRecordStore);
        TextureFactory.getInstance().reset();
        this.conv = f2;
        this.xOffset = -n2;
        this.yOffset = -n3;
        this.scale = (float)wMFRecordStore.getWidthPixels() / (float)wMFRecordStore.getWidthUnits() * f2;
        this.scale = this.scale * (float)wMFRecordStore.getWidthPixels() / (float)wMFRecordStore.getVpW();
        float f3 = (float)wMFRecordStore.getVpW() / (float)wMFRecordStore.getWidthPixels() * (float)wMFRecordStore.getWidthUnits() / (float)wMFRecordStore.getWidthPixels();
        float f4 = (float)wMFRecordStore.getVpH() / (float)wMFRecordStore.getHeightPixels() * (float)wMFRecordStore.getHeightUnits() / (float)wMFRecordStore.getHeightPixels();
        this.xOffset *= f3;
        this.yOffset *= f4;
        this.scaleX = this.scale;
        this.scaleY = this.scale;
    }

    public void paint(Graphics graphics) {
        float f2 = 10.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        Object var10_10 = null;
        Stack<Serializable> stack = new Stack<Serializable>();
        int n5 = this.currentStore.getNumRecords();
        int n6 = this.currentStore.getNumObjects();
        this.vpX = this.currentStore.getVpX() * this.scale;
        this.vpY = this.currentStore.getVpY() * this.scale;
        this.vpW = (float)this.currentStore.getVpW() * this.scale;
        this.vpH = (float)this.currentStore.getVpH() * this.scale;
        if (!this.currentStore.isReading()) {
            GdiObject gdiObject;
            graphics.setPaintMode();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(solid);
            n2 = -1;
            n3 = -1;
            n4 = -1;
            this.frgdColor = null;
            this.bkgdColor = Color.white;
            for (int i2 = 0; i2 < n6; ++i2) {
                gdiObject = this.currentStore.getObject(i2);
                gdiObject.clear();
            }
            float f7 = this.vpW;
            float f8 = this.vpH;
            graphics2D.setColor(Color.black);
            block58: for (int i3 = 0; i3 < n5; ++i3) {
                MetaRecord metaRecord = this.currentStore.getRecord(i3);
                switch (metaRecord.functionId) {
                    case 523: {
                        this.vpX = -((float)metaRecord.elementAt(0));
                        this.currentStore.setVpX(this.vpX);
                        this.vpY = -((float)metaRecord.elementAt(1));
                        this.currentStore.setVpY(this.vpY);
                        this.vpX *= this.scale;
                        this.vpY *= this.scale;
                        continue block58;
                    }
                    case 0: 
                    case 524: {
                        this.vpW = metaRecord.elementAt(0);
                        this.vpH = metaRecord.elementAt(1);
                        this.scaleX = this.scale;
                        this.scaleY = this.scale;
                        solid = new BasicStroke(this.scaleX * 2.0f, 0, 1);
                        continue block58;
                    }
                    case 525: 
                    case 526: 
                    case 527: 
                    case 529: 
                    case 1040: 
                    case 1042: {
                        continue block58;
                    }
                    case 262: {
                        continue block58;
                    }
                    case 762: {
                        int n7 = 0;
                        int n8 = metaRecord.elementAt(0);
                        if (n8 == 5) {
                            Color color = Color.white;
                            n7 = this.addObjectAt(this.currentStore, 4, color, n7);
                            continue block58;
                        }
                        f4 = metaRecord.elementAt(4);
                        this.setStroke(graphics2D, n8, f4, this.scaleX);
                        Color color = new Color(metaRecord.elementAt(1), metaRecord.elementAt(2), metaRecord.elementAt(3));
                        n7 = this.addObjectAt(this.currentStore, 1, color, n7);
                        continue block58;
                    }
                    case 764: {
                        int n9 = 0;
                        int n10 = metaRecord.elementAt(0);
                        Color color = new Color(metaRecord.elementAt(1), metaRecord.elementAt(2), metaRecord.elementAt(3));
                        if (n10 == 0) {
                            n9 = this.addObjectAt(this.currentStore, 2, color, n9);
                            continue block58;
                        }
                        if (n10 == 2) {
                            int n11 = metaRecord.elementAt(4);
                            Paint paint = !this.opaque ? TextureFactory.getInstance().getTexture(n11, color) : TextureFactory.getInstance().getTexture(n11, color, this.bkgdColor);
                            if (paint != null) {
                                n9 = this.addObjectAt(this.currentStore, 2, paint, n9);
                                continue block58;
                            }
                            color = Color.black;
                            n9 = this.addObjectAt(this.currentStore, 5, color, n9);
                            continue block58;
                        }
                        color = Color.black;
                        n9 = this.addObjectAt(this.currentStore, 5, color, n9);
                        continue block58;
                    }
                    case 763: {
                        int n12;
                        float f9 = (int)(this.scaleY * (float)metaRecord.elementAt(0));
                        int n13 = metaRecord.elementAt(3);
                        int n14 = metaRecord.elementAt(1);
                        int n15 = metaRecord.elementAt(2);
                        int n16 = n14 > 0 ? 2 : 0;
                        n16 |= n15 > 400 ? 1 : 0;
                        String string = ((MetaRecord.StringRecord)metaRecord).text;
                        for (n12 = 0; n12 < string.length() && (Character.isLetterOrDigit(string.charAt(n12)) || Character.isWhitespace(string.charAt(n12))); ++n12) {
                        }
                        string = n12 > 0 ? string.substring(0, n12) : "System";
                        if (f9 < 0.0f) {
                            f9 = -f9;
                        }
                        int n17 = 0;
                        f2 = f9;
                        Font font = new Font(string, n16, (int)f9);
                        font = font.deriveFont(f9);
                        int n18 = metaRecord.elementAt(4);
                        int n19 = metaRecord.elementAt(5);
                        int n20 = metaRecord.elementAt(6);
                        int n21 = metaRecord.elementAt(7);
                        WMFFont wMFFont = new WMFFont(font, n13, n18, n19, n14, n15, n20, n21);
                        n17 = this.addObjectAt(this.currentStore, 3, wMFFont, n17);
                        continue block58;
                    }
                    case 248: 
                    case 505: 
                    case 765: 
                    case 1790: 
                    case 1791: {
                        int n22 = this.addObjectAt(this.currentStore, 6, INTEGER_0, 0);
                        continue block58;
                    }
                    case 247: {
                        int n23 = this.addObjectAt(this.currentStore, 8, INTEGER_0, 0);
                        continue block58;
                    }
                    case 53: 
                    case 55: 
                    case 313: 
                    case 564: 
                    case 1078: {
                        continue block58;
                    }
                    case 301: {
                        int n24 = metaRecord.elementAt(0);
                        if ((n24 & Integer.MIN_VALUE) != 0) continue block58;
                        if (n24 >= n6) {
                            switch (n24 -= n6) {
                                case 5: {
                                    n2 = -1;
                                    continue block58;
                                }
                                case 8: {
                                    n3 = -1;
                                    continue block58;
                                }
                            }
                            continue block58;
                        }
                        gdiObject = this.currentStore.getObject(n24);
                        if (!gdiObject.used) continue block58;
                        switch (gdiObject.type) {
                            case 1: {
                                graphics2D.setColor((Color)gdiObject.obj);
                                n3 = n24;
                                break;
                            }
                            case 2: {
                                if (gdiObject.obj instanceof Color) {
                                    graphics2D.setColor((Color)gdiObject.obj);
                                } else if (gdiObject.obj instanceof Paint) {
                                    graphics2D.setPaint((Paint)gdiObject.obj);
                                } else {
                                    graphics2D.setPaint(this.getPaint((byte[])gdiObject.obj));
                                }
                                n2 = n24;
                                break;
                            }
                            case 3: {
                                this.wmfFont = (WMFFont)gdiObject.obj;
                                Font font = this.wmfFont.font;
                                graphics2D.setFont(font);
                                n4 = n24;
                                break;
                            }
                            case 4: {
                                n3 = -1;
                                break;
                            }
                            case 5: {
                                n2 = -1;
                            }
                        }
                        continue block58;
                    }
                    case 496: {
                        int n24 = metaRecord.elementAt(0);
                        gdiObject = this.currentStore.getObject(n24);
                        if (n24 == n2) {
                            n2 = -1;
                        } else if (n24 == n3) {
                            n3 = -1;
                        } else if (n24 == n4) {
                            n4 = -1;
                        }
                        gdiObject.clear();
                        continue block58;
                    }
                    case 1336: {
                        int n25;
                        int n26 = metaRecord.elementAt(0);
                        int[] nArray = new int[n26];
                        for (n25 = 0; n25 < n26; ++n25) {
                            nArray[n25] = metaRecord.elementAt(n25 + 1);
                        }
                        n25 = n26 + 1;
                        ArrayList<Polygon2D> arrayList = new ArrayList<Polygon2D>(n26);
                        for (int i4 = 0; i4 < n26; ++i4) {
                            int n27 = nArray[i4];
                            float[] fArray = new float[n27];
                            float[] fArray2 = new float[n27];
                            for (int i5 = 0; i5 < n27; ++i5) {
                                fArray[i5] = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(n25 + i5 * 2));
                                fArray2[i5] = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(n25 + i5 * 2 + 1));
                            }
                            n25 += n27 * 2;
                            Polygon2D polygon2D = new Polygon2D(fArray, fArray2, n27);
                            arrayList.add(polygon2D);
                        }
                        if (n2 >= 0) {
                            this.setBrushPaint(this.currentStore, graphics2D, n2);
                            this.fillPolyPolygon(graphics2D, arrayList);
                            this.firstEffectivePaint = false;
                        }
                        if (n3 < 0) continue block58;
                        this.setPenColor(this.currentStore, graphics2D, n3);
                        this.drawPolyPolygon(graphics2D, arrayList);
                        this.firstEffectivePaint = false;
                        continue block58;
                    }
                    case 804: {
                        int n28 = metaRecord.elementAt(0);
                        float[] fArray = new float[n28];
                        float[] fArray3 = new float[n28];
                        for (int i6 = 0; i6 < n28; ++i6) {
                            fArray[i6] = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(i6 * 2 + 1));
                            fArray3[i6] = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(i6 * 2 + 2));
                        }
                        Polygon2D polygon2D = new Polygon2D(fArray, fArray3, n28);
                        this.paint(n2, n3, polygon2D, graphics2D);
                        continue block58;
                    }
                    case 532: {
                        f5 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                        f6 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                        continue block58;
                    }
                    case 531: {
                        float f10 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                        float f11 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                        Line2D.Float float_ = new Line2D.Float(f5, f6, f10, f11);
                        this.paintWithPen(n3, float_, graphics2D);
                        f5 = f10;
                        f6 = f11;
                        continue block58;
                    }
                    case 805: {
                        int n29 = metaRecord.elementAt(0);
                        float[] fArray = new float[n29];
                        float[] fArray4 = new float[n29];
                        for (int i7 = 0; i7 < n29; ++i7) {
                            fArray[i7] = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(i7 * 2 + 1));
                            fArray4[i7] = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(i7 * 2 + 2));
                        }
                        Polyline2D polyline2D = new Polyline2D(fArray, fArray4, n29);
                        this.paintWithPen(n3, polyline2D, graphics2D);
                        continue block58;
                    }
                    case 1051: {
                        float f12 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                        float f13 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(2));
                        float f14 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                        float f15 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(3));
                        Rectangle2D.Float float_ = new Rectangle2D.Float(f12, f14, f13 - f12, f15 - f14);
                        this.paint(n2, n3, float_, graphics2D);
                        continue block58;
                    }
                    case 1564: {
                        float f16 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                        float f17 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(2));
                        float f18 = this.scaleX * (float)metaRecord.elementAt(4);
                        float f19 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                        float f20 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(3));
                        float f21 = this.scaleY * (float)metaRecord.elementAt(5);
                        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(f16, f19, f17 - f16, f20 - f19, f18, f21);
                        this.paint(n2, n3, float_, graphics2D);
                        continue block58;
                    }
                    case 1048: {
                        float f22 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                        float f23 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(2));
                        float f24 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                        float f25 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(3));
                        Ellipse2D.Float float_ = new Ellipse2D.Float(f22, f24, f23 - f22, f25 - f24);
                        this.paint(n2, n3, float_, graphics2D);
                        continue block58;
                    }
                    case 302: {
                        this.currentHorizAlign = WMFUtilities.getHorizontalAlignment(metaRecord.elementAt(0));
                        this.currentVertAlign = WMFUtilities.getVerticalAlignment(metaRecord.elementAt(0));
                        continue block58;
                    }
                    case 521: {
                        this.frgdColor = new Color(metaRecord.elementAt(0), metaRecord.elementAt(1), metaRecord.elementAt(2));
                        graphics2D.setColor(this.frgdColor);
                        continue block58;
                    }
                    case 513: {
                        this.bkgdColor = new Color(metaRecord.elementAt(0), metaRecord.elementAt(1), metaRecord.elementAt(2));
                        graphics2D.setColor(this.bkgdColor);
                        continue block58;
                    }
                    case 2610: {
                        int n20;
                        try {
                            byte[] byArray = ((MetaRecord.ByteRecord)metaRecord).bstr;
                            String string = WMFUtilities.decodeString(this.wmfFont, byArray);
                            float f26 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                            float f27 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                            if (this.frgdColor != null) {
                                graphics2D.setColor(this.frgdColor);
                            } else {
                                graphics2D.setColor(Color.black);
                            }
                            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
                            GeneralPath generalPath = new GeneralPath(1);
                            TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), fontRenderContext);
                            int n30 = metaRecord.elementAt(2);
                            int n31 = 0;
                            int n32 = 0;
                            n20 = 0;
                            int n33 = 0;
                            boolean bl = false;
                            Shape shape = null;
                            if ((n30 & 4) != 0) {
                                bl = true;
                                n31 = metaRecord.elementAt(3);
                                n32 = metaRecord.elementAt(4);
                                n20 = metaRecord.elementAt(5);
                                n33 = metaRecord.elementAt(6);
                                shape = graphics2D.getClip();
                                graphics2D.setClip(n31, n32, n20, n33);
                            }
                            this.firstEffectivePaint = false;
                            this.drawString(n30, graphics2D, this.getCharacterIterator(graphics2D, string, this.wmfFont, this.currentHorizAlign), f26, f27 += this.getVerticalAlignmentValue(textLayout, this.currentVertAlign), textLayout, this.wmfFont, this.currentHorizAlign);
                            if (!bl) continue block58;
                            graphics2D.setClip(shape);
                        }
                        catch (Exception exception) {}
                        continue block58;
                    }
                    case 1313: 
                    case 1583: {
                        try {
                            byte[] byArray = ((MetaRecord.ByteRecord)metaRecord).bstr;
                            String string = WMFUtilities.decodeString(this.wmfFont, byArray);
                            float f28 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                            float f29 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                            if (this.frgdColor != null) {
                                graphics2D.setColor(this.frgdColor);
                            } else {
                                graphics2D.setColor(Color.black);
                            }
                            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
                            GeneralPath generalPath = new GeneralPath(1);
                            TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), fontRenderContext);
                            this.firstEffectivePaint = false;
                            this.drawString(-1, graphics2D, this.getCharacterIterator(graphics2D, string, this.wmfFont), f28, f29 += this.getVerticalAlignmentValue(textLayout, this.currentVertAlign), textLayout, this.wmfFont, this.currentHorizAlign);
                        }
                        catch (Exception exception) {}
                        continue block58;
                    }
                    case 2071: 
                    case 2074: {
                        double d2 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                        double d3 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                        double d4 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(2));
                        double d5 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(3));
                        double d6 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(4));
                        double d7 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(5));
                        double d8 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(6));
                        double d9 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(7));
                        this.setBrushPaint(this.currentStore, graphics2D, n2);
                        double d10 = d2 + (d4 - d2) / 2.0;
                        double d11 = d3 + (d5 - d3) / 2.0;
                        double d12 = -Math.toDegrees(Math.atan2(d7 - d11, d6 - d10));
                        double d13 = -Math.toDegrees(Math.atan2(d9 - d11, d8 - d10));
                        double d14 = d13 - d12;
                        if (d14 < 0.0) {
                            d14 += 360.0;
                        }
                        if (d12 < 0.0) {
                            d12 += 360.0;
                        }
                        Arc2D.Double double_ = new Arc2D.Double(d2, d3, d4 - d2, d5 - d3, d12, d14, 0);
                        if (metaRecord.functionId == 2071) {
                            graphics2D.draw(double_);
                        } else {
                            graphics2D.fill(double_);
                        }
                        this.firstEffectivePaint = false;
                        continue block58;
                    }
                    case 2096: {
                        double d15 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(0));
                        double d16 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(1));
                        double d17 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(2));
                        double d18 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(3));
                        double d19 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(4));
                        double d20 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(5));
                        double d21 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(6));
                        double d22 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(7));
                        this.setBrushPaint(this.currentStore, graphics2D, n2);
                        double d10 = d15 + (d17 - d15) / 2.0;
                        double d11 = d16 + (d18 - d16) / 2.0;
                        double d12 = -Math.toDegrees(Math.atan2(d20 - d11, d19 - d10));
                        double d13 = -Math.toDegrees(Math.atan2(d22 - d11, d21 - d10));
                        double d14 = d13 - d12;
                        if (d14 < 0.0) {
                            d14 += 360.0;
                        }
                        if (d12 < 0.0) {
                            d12 += 360.0;
                        }
                        Arc2D.Double double_ = new Arc2D.Double(d15, d16, d17 - d15, d18 - d16, d12, d14, 1);
                        this.paint(n2, n3, double_, graphics2D);
                        this.firstEffectivePaint = false;
                        continue block58;
                    }
                    case 30: {
                        stack.push(new Float(f4));
                        stack.push(new Float(f5));
                        stack.push(new Float(f6));
                        stack.push(new Integer(n2));
                        stack.push(new Integer(n3));
                        stack.push(new Integer(n4));
                        stack.push(this.frgdColor);
                        stack.push(this.bkgdColor);
                        continue block58;
                    }
                    case 295: {
                        this.bkgdColor = (Color)stack.pop();
                        this.frgdColor = (Color)stack.pop();
                        n4 = (Integer)stack.pop();
                        n3 = (Integer)stack.pop();
                        n2 = (Integer)stack.pop();
                        f6 = ((Float)stack.pop()).floatValue();
                        f5 = ((Float)stack.pop()).floatValue();
                        f4 = ((Float)stack.pop()).floatValue();
                        continue block58;
                    }
                    case 4096: {
                        try {
                            this.setPenColor(this.currentStore, graphics2D, n3);
                            int n34 = metaRecord.elementAt(0);
                            int n35 = (n34 - 1) / 3;
                            float f30 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(1));
                            float f31 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(2));
                            GeneralPath generalPath = new GeneralPath(1);
                            generalPath.moveTo(f30, f31);
                            for (int i8 = 0; i8 < n35; ++i8) {
                                int n36 = i8 * 6;
                                float f32 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(n36 + 3));
                                float f33 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(n36 + 4));
                                float f34 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(n36 + 5));
                                float f35 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(n36 + 6));
                                float f36 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(n36 + 7));
                                float f37 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(n36 + 8));
                                generalPath.curveTo(f32, f33, f34, f35, f36, f37);
                                f30 = f36;
                                f31 = f37;
                            }
                            graphics2D.setStroke(solid);
                            graphics2D.draw(generalPath);
                            this.firstEffectivePaint = false;
                        }
                        catch (Exception exception) {}
                        continue block58;
                    }
                    case 259: 
                    case 261: 
                    case 263: 
                    case 264: 
                    case 300: 
                    case 522: 
                    case 544: 
                    case 1045: 
                    case 1046: 
                    case 1049: {
                        continue block58;
                    }
                    case 258: {
                        int n37 = metaRecord.elementAt(0);
                        this.opaque = n37 == 2;
                        continue block58;
                    }
                    case 260: {
                        float f38 = metaRecord.ElementAt(0).intValue();
                        Paint paint = null;
                        boolean bl = false;
                        if (f38 == 66.0f) {
                            paint = Color.black;
                            bl = true;
                        } else if (f38 == 1.6711778E7f) {
                            paint = Color.white;
                            bl = true;
                        } else if (f38 == 1.5728673E7f && n2 >= 0) {
                            paint = this.getStoredPaint(this.currentStore, n2);
                            bl = true;
                        }
                        if (!bl) continue block58;
                        if (paint != null) {
                            graphics2D.setPaint(paint);
                            continue block58;
                        }
                        this.setBrushPaint(this.currentStore, graphics2D, n2);
                        continue block58;
                    }
                    case 1565: {
                        float f39 = metaRecord.elementAt(0);
                        float f40 = this.scaleY * (float)metaRecord.elementAt(1);
                        float f41 = this.scaleX * (float)metaRecord.elementAt(2);
                        float f42 = this.scaleX * (this.vpX + this.xOffset + (float)metaRecord.elementAt(3));
                        float f43 = this.scaleY * (this.vpY + this.yOffset + (float)metaRecord.elementAt(4));
                        Paint paint = null;
                        boolean bl = false;
                        if (f39 == 66.0f) {
                            paint = Color.black;
                            bl = true;
                        } else if (f39 == 1.6711778E7f) {
                            paint = Color.white;
                            bl = true;
                        } else if (f39 == 1.5728673E7f && n2 >= 0) {
                            paint = this.getStoredPaint(this.currentStore, n2);
                            bl = true;
                        }
                        if (!bl) continue block58;
                        Color color = graphics2D.getColor();
                        if (paint != null) {
                            graphics2D.setPaint(paint);
                        } else {
                            this.setBrushPaint(this.currentStore, graphics2D, n2);
                        }
                        Rectangle2D.Float float_ = new Rectangle2D.Float(f42, f43, f41, f40);
                        graphics2D.fill(float_);
                        graphics2D.setColor(color);
                        continue block58;
                    }
                    case 2881: {
                        int n38 = metaRecord.elementAt(1);
                        int n39 = metaRecord.elementAt(2);
                        int n40 = metaRecord.elementAt(3);
                        int n41 = metaRecord.elementAt(4);
                        float f44 = this.conv * this.currentStore.getVpWFactor() * (this.vpY + this.yOffset + (float)metaRecord.elementAt(7));
                        float f45 = this.conv * this.currentStore.getVpHFactor() * (this.vpX + this.xOffset + (float)metaRecord.elementAt(8));
                        float f46 = metaRecord.elementAt(5);
                        float f47 = metaRecord.elementAt(6);
                        f47 = f47 * this.conv * this.currentStore.getVpWFactor();
                        f46 = f46 * this.conv * this.currentStore.getVpHFactor();
                        byte[] byArray = ((MetaRecord.ByteRecord)metaRecord).bstr;
                        BufferedImage bufferedImage = this.getImage(byArray, n39, n38);
                        if (bufferedImage == null) continue block58;
                        graphics2D.drawImage(bufferedImage, (int)f45, (int)f44, (int)(f45 + f47), (int)(f44 + f46), n41, n40, n41 + n39, n40 + n38, this.bkgdColor, this.observer);
                        continue block58;
                    }
                    case 3907: {
                        int n42 = metaRecord.elementAt(1);
                        int n43 = metaRecord.elementAt(2);
                        int n44 = metaRecord.elementAt(3);
                        int n45 = metaRecord.elementAt(4);
                        float f48 = this.conv * this.currentStore.getVpWFactor() * (this.vpY + this.yOffset + (float)metaRecord.elementAt(7));
                        float f49 = this.conv * this.currentStore.getVpHFactor() * (this.vpX + this.xOffset + (float)metaRecord.elementAt(8));
                        float f50 = metaRecord.elementAt(5);
                        float f51 = metaRecord.elementAt(6);
                        f51 = f51 * this.conv * this.currentStore.getVpWFactor();
                        f50 = f50 * this.conv * this.currentStore.getVpHFactor();
                        byte[] byArray = ((MetaRecord.ByteRecord)metaRecord).bstr;
                        BufferedImage bufferedImage = this.getImage(byArray, n43, n42);
                        if (bufferedImage == null) continue block58;
                        if (this.opaque) {
                            graphics2D.drawImage(bufferedImage, (int)f49, (int)f48, (int)(f49 + f51), (int)(f48 + f50), n45, n44, n45 + n43, n44 + n42, this.bkgdColor, this.observer);
                            continue block58;
                        }
                        graphics2D.drawImage(bufferedImage, (int)f49, (int)f48, (int)(f49 + f51), (int)(f48 + f50), n45, n44, n45 + n43, n44 + n42, this.observer);
                        continue block58;
                    }
                    case 2368: {
                        int n46 = metaRecord.ElementAt(0);
                        float f52 = (float)metaRecord.ElementAt(1).intValue() * this.conv * this.currentStore.getVpWFactor();
                        float f53 = (float)metaRecord.ElementAt(2).intValue() * this.conv * this.currentStore.getVpHFactor();
                        int n47 = metaRecord.ElementAt(3);
                        int n48 = metaRecord.ElementAt(4);
                        float f54 = this.conv * this.currentStore.getVpWFactor() * (this.vpY + this.yOffset + (float)metaRecord.ElementAt(5).intValue());
                        float f55 = this.conv * this.currentStore.getVpHFactor() * (this.vpX + this.xOffset + (float)metaRecord.ElementAt(6).intValue());
                        if (metaRecord instanceof MetaRecord.ByteRecord) {
                            byte[] byArray = ((MetaRecord.ByteRecord)metaRecord).bstr;
                            BufferedImage bufferedImage = this.getImage(byArray);
                            if (bufferedImage == null) continue block58;
                            int n49 = bufferedImage.getWidth();
                            int n50 = bufferedImage.getHeight();
                            if (this.opaque) {
                                graphics2D.drawImage(bufferedImage, (int)f55, (int)f54, (int)(f55 + f53), (int)(f54 + f52), n48, n47, n48 + n49, n47 + n50, this.bkgdColor, this.observer);
                                continue block58;
                            }
                            graphics2D.drawImage(bufferedImage, (int)f55, (int)f54, (int)(f55 + f53), (int)(f54 + f52), n48, n47, n48 + n49, n47 + n50, this.observer);
                            continue block58;
                        }
                        if (!this.opaque) continue block58;
                        Color color = graphics2D.getColor();
                        graphics2D.setColor(this.bkgdColor);
                        graphics2D.fill(new Rectangle2D.Float(f55, f54, f53, f52));
                        graphics2D.setColor(color);
                        continue block58;
                    }
                    case 322: {
                        int n51 = 0;
                        byte[] byArray = ((MetaRecord.ByteRecord)metaRecord).bstr;
                        n51 = this.addObjectAt(this.currentStore, 2, byArray, n51);
                        continue block58;
                    }
                }
            }
        }
    }

    private Paint getPaint(byte[] byArray) {
        Dimension dimension = this.getImageDimension(byArray);
        BufferedImage bufferedImage = this.getImage(byArray);
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, dimension.width, dimension.height);
        TexturePaint texturePaint = new TexturePaint(bufferedImage, float_);
        return texturePaint;
    }

    private void drawString(int n2, Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator, float f2, float f3, TextLayout textLayout, WMFFont wMFFont, int n3) {
        if (wMFFont.escape == 0) {
            if (n2 != -1) {
                this.fillTextBackground(-1, n2, graphics2D, f2, f3, 0.0f, textLayout);
            }
            float f4 = (float)textLayout.getBounds().getWidth();
            if (n3 == 6) {
                graphics2D.drawString(attributedCharacterIterator, f2 - f4 / 2.0f, f3);
            } else if (n3 == 2) {
                graphics2D.drawString(attributedCharacterIterator, f2 - f4, f3);
            } else {
                graphics2D.drawString(attributedCharacterIterator, f2, f3);
            }
        } else {
            AffineTransform affineTransform = graphics2D.getTransform();
            float f5 = -((float)((double)wMFFont.escape * Math.PI / 1800.0));
            float f6 = (float)textLayout.getBounds().getWidth();
            float f7 = (float)textLayout.getBounds().getHeight();
            if (n3 == 6) {
                graphics2D.translate(-f6 / 2.0f, f7 / 2.0f);
                graphics2D.rotate(f5, f2 - f6 / 2.0f, f3);
            } else if (n3 == 2) {
                graphics2D.translate(-f6 / 2.0f, f7 / 2.0f);
                graphics2D.rotate(f5, f2 - f6, f3);
            } else {
                graphics2D.translate(0.0, f7 / 2.0f);
                graphics2D.rotate(f5, f2, f3);
            }
            if (n2 != -1) {
                this.fillTextBackground(n3, n2, graphics2D, f2, f3, f6, textLayout);
            }
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(textSolid);
            graphics2D.drawString(attributedCharacterIterator, f2, f3);
            graphics2D.setStroke(stroke);
            graphics2D.setTransform(affineTransform);
        }
    }

    private void fillTextBackground(int n2, int n3, Graphics2D graphics2D, float f2, float f3, float f4, TextLayout textLayout) {
        float f5 = f2;
        if (n2 == 6) {
            f5 = f2 - f4 / 2.0f;
        } else if (n2 == 2) {
            f5 = f2 - f4;
        }
        if ((n3 & 2) != 0) {
            Color color = graphics2D.getColor();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.setColor(this.bkgdColor);
            graphics2D.translate(f5, f3);
            graphics2D.fill(textLayout.getBounds());
            graphics2D.setColor(color);
            graphics2D.setTransform(affineTransform);
        } else if (this.opaque) {
            Color color = graphics2D.getColor();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.setColor(this.bkgdColor);
            graphics2D.translate(f5, f3);
            graphics2D.fill(textLayout.getBounds());
            graphics2D.setColor(color);
            graphics2D.setTransform(affineTransform);
        }
    }

    private void drawPolyPolygon(Graphics2D graphics2D, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Polygon2D polygon2D = (Polygon2D)iterator.next();
            graphics2D.draw(polygon2D);
        }
    }

    private void fillPolyPolygon(Graphics2D graphics2D, List list) {
        if (list.size() == 1) {
            graphics2D.fill((Polygon2D)list.get(0));
        } else {
            GeneralPath generalPath = new GeneralPath(0);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Polygon2D polygon2D = (Polygon2D)list.get(i2);
                generalPath.append(polygon2D, false);
            }
            graphics2D.fill(generalPath);
        }
    }

    private void setStroke(Graphics2D graphics2D, int n2, float f2, float f3) {
        float f4 = f2 == 0.0f ? 1.0f : f2;
        float f5 = (float)Toolkit.getDefaultToolkit().getScreenResolution() / (float)this.currentStore.getMetaFileUnitsPerInch();
        float f6 = f3 / f5;
        f4 = f4 * f5 * f6;
        f5 = (float)this.currentStore.getWidthPixels() * 1.0f / 350.0f;
        if (n2 == 0) {
            BasicStroke basicStroke = new BasicStroke(f4, 0, 1);
            graphics2D.setStroke(basicStroke);
        } else if (n2 == 2) {
            float[] fArray = new float[]{1.0f * f5, 5.0f * f5};
            BasicStroke basicStroke = new BasicStroke(f4, 0, 1, 10.0f * f5, fArray, 0.0f);
            graphics2D.setStroke(basicStroke);
        } else if (n2 == 1) {
            float[] fArray = new float[]{5.0f * f5, 2.0f * f5};
            BasicStroke basicStroke = new BasicStroke(f4, 0, 1, 10.0f * f5, fArray, 0.0f);
            graphics2D.setStroke(basicStroke);
        } else if (n2 == 3) {
            float[] fArray = new float[]{5.0f * f5, 2.0f * f5, 1.0f * f5, 2.0f * f5};
            BasicStroke basicStroke = new BasicStroke(f4, 0, 1, 10.0f * f5, fArray, 0.0f);
            graphics2D.setStroke(basicStroke);
        } else if (n2 == 4) {
            float[] fArray = new float[]{5.0f * f5, 2.0f * f5, 1.0f * f5, 2.0f * f5, 1.0f * f5, 2.0f * f5};
            BasicStroke basicStroke = new BasicStroke(f4, 0, 1, 15.0f * f5, fArray, 0.0f);
            graphics2D.setStroke(basicStroke);
        } else {
            BasicStroke basicStroke = new BasicStroke(f4, 0, 1);
            graphics2D.setStroke(basicStroke);
        }
    }

    private void setPenColor(WMFRecordStore wMFRecordStore, Graphics2D graphics2D, int n2) {
        if (n2 >= 0) {
            GdiObject gdiObject = wMFRecordStore.getObject(n2);
            graphics2D.setColor((Color)gdiObject.obj);
            n2 = -1;
        }
    }

    private int getHorizontalAlignement(int n2) {
        int n3 = n2;
        n3 %= 24;
        if ((n3 %= 8) >= 6) {
            return 6;
        }
        if (n3 >= 2) {
            return 2;
        }
        return 0;
    }

    private void setBrushPaint(WMFRecordStore wMFRecordStore, Graphics2D graphics2D, int n2) {
        if (n2 >= 0) {
            GdiObject gdiObject = wMFRecordStore.getObject(n2);
            if (gdiObject.obj instanceof Color) {
                graphics2D.setColor((Color)gdiObject.obj);
            } else if (gdiObject.obj instanceof Paint) {
                graphics2D.setPaint((Paint)gdiObject.obj);
            } else {
                graphics2D.setPaint(this.getPaint((byte[])gdiObject.obj));
            }
            n2 = -1;
        }
    }

    private Paint getStoredPaint(WMFRecordStore wMFRecordStore, int n2) {
        if (n2 >= 0) {
            GdiObject gdiObject = wMFRecordStore.getObject(n2);
            if (gdiObject.obj instanceof Paint) {
                return (Paint)gdiObject.obj;
            }
            return this.getPaint((byte[])gdiObject.obj);
        }
        return null;
    }

    private void paint(int n2, int n3, Shape shape, Graphics2D graphics2D) {
        Paint paint;
        if (n2 >= 0) {
            paint = this.getStoredPaint(this.currentStore, n2);
            if (!this.firstEffectivePaint || !paint.equals(Color.white)) {
                this.setBrushPaint(this.currentStore, graphics2D, n2);
                graphics2D.fill(shape);
                this.firstEffectivePaint = false;
            }
        }
        if (n3 >= 0) {
            paint = this.getStoredPaint(this.currentStore, n3);
            if (!this.firstEffectivePaint || !paint.equals(Color.white)) {
                this.setPenColor(this.currentStore, graphics2D, n3);
                graphics2D.draw(shape);
                this.firstEffectivePaint = false;
            }
        }
    }

    private void paintWithPen(int n2, Shape shape, Graphics2D graphics2D) {
        if (n2 >= 0) {
            Paint paint = this.getStoredPaint(this.currentStore, n2);
            if (!this.firstEffectivePaint || !paint.equals(Color.white)) {
                this.setPenColor(this.currentStore, graphics2D, n2);
                graphics2D.draw(shape);
                this.firstEffectivePaint = false;
            }
        }
    }

    private float getVerticalAlignmentValue(TextLayout textLayout, int n2) {
        if (n2 == 8) {
            return -textLayout.getDescent();
        }
        if (n2 == 0) {
            return textLayout.getAscent();
        }
        return 0.0f;
    }

    public WMFRecordStore getRecordStore() {
        return this.currentStore;
    }
}

