/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.transcoder.wmf.tosvg.AbstractWMFReader;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;

public class WMFRecordStore
extends AbstractWMFReader {
    private URL url;
    protected int numRecords;
    protected float vpX;
    protected float vpY;
    protected List records;
    private boolean _bext = true;

    public WMFRecordStore() {
        this.reset();
    }

    public void reset() {
        this.numRecords = 0;
        this.vpX = 0.0f;
        this.vpY = 0.0f;
        this.vpW = 1000;
        this.vpH = 1000;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleXY = 1.0f;
        this.inch = 84;
        this.records = new ArrayList(20);
    }

    protected boolean readRecords(DataInputStream dataInputStream) throws IOException {
        int n2 = 1;
        int n3 = 0;
        this.numRecords = 0;
        while (n2 > 0) {
            n3 = this.readInt(dataInputStream);
            n3 -= 3;
            n2 = this.readShort(dataInputStream);
            if (n2 <= 0) break;
            MetaRecord metaRecord = new MetaRecord();
            switch (n2) {
                case 259: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readShort(dataInputStream);
                    if (n4 == 8) {
                        this.isotropic = false;
                    }
                    metaRecord.addElement(n4);
                    this.records.add(metaRecord);
                    break;
                }
                case 1583: {
                    int n4;
                    for (n4 = 0; n4 < n3; ++n4) {
                        short s2 = this.readShort(dataInputStream);
                    }
                    --this.numRecords;
                    break;
                }
                case 2610: {
                    int n5;
                    int n6;
                    int n4 = this.readShort(dataInputStream) * this.ySign;
                    int n7 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    short s3 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = 4;
                    int n10 = 0;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = 0;
                    int n14 = 0;
                    if ((n8 & 4) != 0) {
                        n11 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                        n12 = this.readShort(dataInputStream) * this.ySign;
                        n13 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                        n14 = this.readShort(dataInputStream) * this.ySign;
                        n9 += 4;
                        n10 = 1;
                    }
                    byte[] byArray = new byte[s3];
                    for (n6 = 0; n6 < s3; ++n6) {
                        byArray[n6] = dataInputStream.readByte();
                    }
                    n9 += (s3 + 1) / 2;
                    if (s3 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    if (n9 < n3) {
                        for (n5 = n9; n5 < n3; ++n5) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    metaRecord.addElement(n7);
                    metaRecord.addElement(n4);
                    metaRecord.addElement(n8);
                    if (n10 != 0) {
                        metaRecord.addElement(n11);
                        metaRecord.addElement(n12);
                        metaRecord.addElement(n13);
                        metaRecord.addElement(n14);
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 1313: {
                    int n10;
                    int n8;
                    int n4 = this.readShort(dataInputStream);
                    int n15 = 1;
                    byte[] byArray = new byte[n4];
                    for (n8 = 0; n8 < n4; ++n8) {
                        byArray[n8] = dataInputStream.readByte();
                    }
                    if (n4 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    n15 += (n4 + 1) / 2;
                    n8 = this.readShort(dataInputStream) * this.ySign;
                    int n9 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    if ((n15 += 2) < n3) {
                        for (n10 = n15; n10 < n3; ++n10) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n8);
                    this.records.add(metaRecord);
                    break;
                }
                case 763: {
                    int n4 = this.readShort(dataInputStream);
                    short s4 = this.readShort(dataInputStream);
                    short s5 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    int n10 = dataInputStream.readByte();
                    int n11 = dataInputStream.readByte();
                    int n12 = dataInputStream.readByte();
                    int n13 = dataInputStream.readByte() & 0xFF;
                    byte by = dataInputStream.readByte();
                    int n16 = dataInputStream.readByte();
                    byte by2 = dataInputStream.readByte();
                    int n6 = dataInputStream.readByte();
                    int n5 = 2 * (n3 - 9);
                    byte[] byArray = new byte[n5];
                    for (int i2 = 0; i2 < n5; ++i2) {
                        byArray[i2] = dataInputStream.readByte();
                    }
                    String string = new String(byArray);
                    metaRecord = new MetaRecord.StringRecord(string);
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    metaRecord.addElement(n4);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n13);
                    metaRecord.addElement(n11);
                    metaRecord.addElement(n12);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(s5);
                    this.records.add(metaRecord);
                    break;
                }
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readShort(dataInputStream);
                    short s6 = this.readShort(dataInputStream);
                    if (s6 < 0) {
                        s6 = -s6;
                        this.xSign = -1;
                    }
                    if (n4 < 0) {
                        n4 = -n4;
                        this.ySign = -1;
                    }
                    metaRecord.addElement((int)((float)s6 * this.scaleXY));
                    metaRecord.addElement(n4);
                    this.records.add(metaRecord);
                    if (this._bext && n2 == 524) {
                        this.vpW = s6;
                        this.vpH = n4;
                        if (!this.isotropic) {
                            this.scaleXY = (float)this.vpW / (float)this.vpH;
                        }
                        this.vpW = (int)((float)this.vpW * this.scaleXY);
                        this._bext = false;
                    }
                    if (this.isAldus) break;
                    this.width = this.vpW;
                    this.height = this.vpH;
                    break;
                }
                case 527: 
                case 529: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readShort(dataInputStream) * this.ySign;
                    int n17 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    metaRecord.addElement(n17);
                    metaRecord.addElement(n4);
                    this.records.add(metaRecord);
                    break;
                }
                case 1040: 
                case 1042: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readShort(dataInputStream);
                    short s7 = this.readShort(dataInputStream);
                    short s8 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    metaRecord.addElement(s8);
                    metaRecord.addElement(n4);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(s7);
                    this.records.add(metaRecord);
                    this.scaleX = this.scaleX * (float)s8 / (float)n8;
                    this.scaleY = this.scaleY * (float)n4 / (float)s7;
                    break;
                }
                case 764: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    metaRecord.addElement(this.readShort(dataInputStream));
                    int n4 = this.readInt(dataInputStream);
                    int n18 = n4 & 0xFF;
                    int n19 = (n4 & 0xFF00) >> 8;
                    int n8 = (n4 & 0xFF0000) >> 16;
                    int n9 = (n4 & 0x3000000) >> 24;
                    metaRecord.addElement(n18);
                    metaRecord.addElement(n19);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(this.readShort(dataInputStream));
                    this.records.add(metaRecord);
                    break;
                }
                case 762: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    metaRecord.addElement(this.readShort(dataInputStream));
                    int n4 = this.readInt(dataInputStream);
                    int n20 = this.readInt(dataInputStream);
                    if (n3 == 6) {
                        this.readShort(dataInputStream);
                    }
                    int n21 = n20 & 0xFF;
                    int n8 = (n20 & 0xFF00) >> 8;
                    int n9 = (n20 & 0xFF0000) >> 16;
                    int n10 = (n20 & 0x3000000) >> 24;
                    metaRecord.addElement(n21);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n4);
                    this.records.add(metaRecord);
                    break;
                }
                case 302: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readShort(dataInputStream);
                    if (n3 > 1) {
                        for (int i3 = 1; i3 < n3; ++i3) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord.addElement(n4);
                    this.records.add(metaRecord);
                    break;
                }
                case 513: 
                case 521: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readInt(dataInputStream);
                    int n22 = n4 & 0xFF;
                    int n23 = (n4 & 0xFF00) >> 8;
                    int n8 = (n4 & 0xFF0000) >> 16;
                    int n9 = (n4 & 0x3000000) >> 24;
                    metaRecord.addElement(n22);
                    metaRecord.addElement(n23);
                    metaRecord.addElement(n8);
                    this.records.add(metaRecord);
                    break;
                }
                case 531: 
                case 532: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readShort(dataInputStream) * this.ySign;
                    int n24 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    metaRecord.addElement(n24);
                    metaRecord.addElement(n4);
                    this.records.add(metaRecord);
                    break;
                }
                case 262: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readShort(dataInputStream);
                    if (n3 > 1) {
                        for (int i4 = 1; i4 < n3; ++i4) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord.addElement(n4);
                    this.records.add(metaRecord);
                    break;
                }
                case 1336: {
                    int n11;
                    int n10;
                    int n9;
                    int n8;
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readShort(dataInputStream);
                    int[] nArray = new int[n4];
                    int n25 = 0;
                    for (n8 = 0; n8 < n4; ++n8) {
                        nArray[n8] = this.readShort(dataInputStream);
                        n25 += nArray[n8];
                    }
                    metaRecord.addElement(n4);
                    for (n8 = 0; n8 < n4; ++n8) {
                        metaRecord.addElement(nArray[n8]);
                    }
                    n8 = n4 + 1;
                    for (n9 = 0; n9 < n4; ++n9) {
                        n10 = nArray[n9];
                        for (n11 = 0; n11 < n10; ++n11) {
                            metaRecord.addElement((int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY));
                            metaRecord.addElement(this.readShort(dataInputStream) * this.ySign);
                        }
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 804: 
                case 805: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readShort(dataInputStream);
                    metaRecord.addElement(n4);
                    for (int i5 = 0; i5 < n4; ++i5) {
                        metaRecord.addElement((int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY));
                        metaRecord.addElement(this.readShort(dataInputStream) * this.ySign);
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 1046: 
                case 1048: 
                case 1051: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readShort(dataInputStream) * this.ySign;
                    int n26 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n27 = this.readShort(dataInputStream) * this.ySign;
                    int n8 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n27);
                    metaRecord.addElement(n26);
                    metaRecord.addElement(n4);
                    this.records.add(metaRecord);
                    break;
                }
                case 1791: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n28 = this.readShort(dataInputStream) * this.ySign;
                    int n29 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n8 = this.readShort(dataInputStream) * this.ySign;
                    metaRecord.addElement(n4);
                    metaRecord.addElement(n28);
                    metaRecord.addElement(n29);
                    metaRecord.addElement(n8);
                    this.records.add(metaRecord);
                    break;
                }
                case 1564: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readShort(dataInputStream) * this.ySign;
                    int n30 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n31 = this.readShort(dataInputStream) * this.ySign;
                    int n8 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n9 = this.readShort(dataInputStream) * this.ySign;
                    int n10 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n31);
                    metaRecord.addElement(n30);
                    metaRecord.addElement(n4);
                    this.records.add(metaRecord);
                    break;
                }
                case 2071: 
                case 2074: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readShort(dataInputStream) * this.ySign;
                    int n32 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n33 = this.readShort(dataInputStream) * this.ySign;
                    int n8 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n9 = this.readShort(dataInputStream) * this.ySign;
                    int n10 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n11 = this.readShort(dataInputStream) * this.ySign;
                    int n12 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    metaRecord.addElement(n12);
                    metaRecord.addElement(n11);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n33);
                    metaRecord.addElement(n32);
                    metaRecord.addElement(n4);
                    this.records.add(metaRecord);
                    break;
                }
                case 1565: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readInt(dataInputStream);
                    int n34 = this.readShort(dataInputStream) * this.ySign;
                    int n35 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n8 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n9 = this.readShort(dataInputStream) * this.ySign;
                    metaRecord.addElement(n4);
                    metaRecord.addElement(n34);
                    metaRecord.addElement(n35);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n8);
                    this.records.add(metaRecord);
                    break;
                }
                case 258: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = this.readShort(dataInputStream);
                    metaRecord.addElement(n4);
                    if (n3 > 1) {
                        for (int i6 = 1; i6 < n3; ++i6) {
                            this.readShort(dataInputStream);
                        }
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 260: {
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    int n4 = n3 == 1 ? (int)this.readShort(dataInputStream) : this.readInt(dataInputStream);
                    metaRecord.addElement(n4);
                    this.records.add(metaRecord);
                    break;
                }
                case 2881: {
                    int n4 = dataInputStream.readInt() & 0xFF;
                    int n36 = this.readShort(dataInputStream) * this.ySign;
                    int n37 = this.readShort(dataInputStream) * this.xSign;
                    int n8 = this.readShort(dataInputStream) * this.ySign;
                    int n9 = this.readShort(dataInputStream) * this.xSign;
                    int n10 = this.readShort(dataInputStream) * this.ySign;
                    int n11 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n12 = this.readShort(dataInputStream) * this.ySign;
                    int n13 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n38 = 2 * n3 - 20;
                    byte[] byArray = new byte[n38];
                    for (int i7 = 0; i7 < n38; ++i7) {
                        byArray[i7] = dataInputStream.readByte();
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    metaRecord.addElement(n4);
                    metaRecord.addElement(n36);
                    metaRecord.addElement(n37);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(n11);
                    metaRecord.addElement(n12);
                    metaRecord.addElement(n13);
                    this.records.add(metaRecord);
                    break;
                }
                case 3907: {
                    int n6;
                    int n4 = dataInputStream.readInt() & 0xFF;
                    short s9 = this.readShort(dataInputStream);
                    int n39 = this.readShort(dataInputStream) * this.ySign;
                    int n8 = this.readShort(dataInputStream) * this.xSign;
                    int n9 = this.readShort(dataInputStream) * this.ySign;
                    int n10 = this.readShort(dataInputStream) * this.xSign;
                    int n11 = this.readShort(dataInputStream) * this.ySign;
                    int n12 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n13 = this.readShort(dataInputStream) * this.ySign;
                    int n40 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n16 = 2 * n3 - 22;
                    byte[] byArray = new byte[n16];
                    for (n6 = 0; n6 < n16; ++n6) {
                        byArray[n6] = dataInputStream.readByte();
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    metaRecord.addElement(n4);
                    metaRecord.addElement(n39);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(n11);
                    metaRecord.addElement(n12);
                    metaRecord.addElement(n13);
                    metaRecord.addElement(n40);
                    this.records.add(metaRecord);
                    break;
                }
                case 2368: {
                    int n16;
                    int n4 = dataInputStream.readInt() & 0xFF;
                    short s10 = this.readShort(dataInputStream);
                    short s11 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = this.readShort(dataInputStream);
                    int n10 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n11 = this.readShort(dataInputStream);
                    int n12 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n13 = 2 * n3 - 18;
                    if (n13 > 0) {
                        byte[] byArray = new byte[n13];
                        for (n16 = 0; n16 < n13; ++n16) {
                            byArray[n16] = dataInputStream.readByte();
                        }
                        metaRecord = new MetaRecord.ByteRecord(byArray);
                        metaRecord.numPoints = n3;
                        metaRecord.functionId = n2;
                    } else {
                        metaRecord.numPoints = n3;
                        metaRecord.functionId = n2;
                        for (int i8 = 0; i8 < n13; ++i8) {
                            dataInputStream.readByte();
                        }
                    }
                    metaRecord.addElement(n4);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(s10);
                    metaRecord.addElement(s11);
                    metaRecord.addElement(n11);
                    metaRecord.addElement(n12);
                    this.records.add(metaRecord);
                    break;
                }
                case 322: {
                    int n8;
                    int n4 = dataInputStream.readInt() & 0xFF;
                    int n41 = 2 * n3 - 4;
                    byte[] byArray = new byte[n41];
                    for (n8 = 0; n8 < n41; ++n8) {
                        byArray[n8] = dataInputStream.readByte();
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    metaRecord.addElement(n4);
                    this.records.add(metaRecord);
                    break;
                }
                default: {
                    int n4;
                    metaRecord.numPoints = n3;
                    metaRecord.functionId = n2;
                    for (n4 = 0; n4 < n3; ++n4) {
                        metaRecord.addElement(this.readShort(dataInputStream));
                    }
                    this.records.add(metaRecord);
                }
            }
            ++this.numRecords;
        }
        if (!this.isAldus) {
            this.right = (int)this.vpX;
            this.left = (int)(this.vpX + (float)this.vpW);
            this.top = (int)this.vpY;
            this.bottom = (int)(this.vpY + (float)this.vpH);
        }
        this.setReading(false);
        return true;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public MetaRecord getRecord(int n2) {
        return (MetaRecord)this.records.get(n2);
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public float getVpX() {
        return this.vpX;
    }

    public float getVpY() {
        return this.vpY;
    }

    public void setVpX(float f2) {
        this.vpX = f2;
    }

    public void setVpY(float f2) {
        this.vpY = f2;
    }
}

