/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.ToSVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.wmf.tosvg.WMFPainter;
import org.apache.batik.transcoder.wmf.tosvg.WMFRecordStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WMFTranscoder
extends ToSVGAbstractTranscoder {
    public static final String WMF_EXTENSION = ".wmf";
    public static final String SVG_EXTENSION = ".svg";

    public void transcode(TranscoderInput transcoderInput, TranscoderOutput transcoderOutput) throws TranscoderException {
        int n2;
        int n3;
        float f2;
        float f3;
        DataInputStream dataInputStream = this.getCompatibleInput(transcoderInput);
        WMFRecordStore wMFRecordStore = new WMFRecordStore();
        try {
            wMFRecordStore.read(dataInputStream);
        }
        catch (IOException iOException) {
            this.handler.fatalError(new TranscoderException(iOException));
            return;
        }
        float f4 = 1.0f;
        if (this.hints.containsKey(KEY_INPUT_WIDTH)) {
            f3 = ((Integer)this.hints.get(KEY_INPUT_WIDTH)).intValue();
            f2 = ((Integer)this.hints.get(KEY_INPUT_HEIGHT)).intValue();
        } else {
            f3 = wMFRecordStore.getWidthPixels();
            f2 = wMFRecordStore.getHeightPixels();
        }
        float f5 = f3;
        float f6 = f2;
        if (this.hints.containsKey(KEY_WIDTH)) {
            f5 = ((Float)this.hints.get(KEY_WIDTH)).floatValue();
            f4 = f5 / f3;
            f6 = f6 * f5 / f3;
        }
        int n4 = 0;
        int n5 = 0;
        if (this.hints.containsKey(KEY_XOFFSET)) {
            n4 = (Integer)this.hints.get(KEY_XOFFSET);
        }
        if (this.hints.containsKey(KEY_YOFFSET)) {
            n5 = (Integer)this.hints.get(KEY_YOFFSET);
        }
        float f7 = wMFRecordStore.getUnitsToPixels() * f4;
        int n6 = (int)(wMFRecordStore.getVpX() * f7);
        int n7 = (int)(wMFRecordStore.getVpY() * f7);
        if (this.hints.containsKey(KEY_INPUT_WIDTH)) {
            n3 = (int)((float)((Integer)this.hints.get(KEY_INPUT_WIDTH)).intValue() * f4);
            n2 = (int)((float)((Integer)this.hints.get(KEY_INPUT_HEIGHT)).intValue() * f4);
        } else {
            n3 = (int)((float)wMFRecordStore.getWidthUnits() * f7);
            n2 = (int)((float)wMFRecordStore.getHeightUnits() * f7);
        }
        WMFPainter wMFPainter = new WMFPainter(wMFRecordStore, n4, n5, f4);
        Document document = this.createDocument(transcoderOutput);
        this.svgGenerator = new SVGGraphics2D(document);
        this.svgGenerator.getGeneratorContext().setPrecision(4);
        wMFPainter.paint(this.svgGenerator);
        this.svgGenerator.setSVGCanvasSize(new Dimension(n3, n2));
        Element element = this.svgGenerator.getRoot();
        element.setAttributeNS(null, "viewBox", String.valueOf(n6) + ' ' + n7 + ' ' + n3 + ' ' + n2);
        this.writeSVGToOutput(this.svgGenerator, element, transcoderOutput);
    }

    private DataInputStream getCompatibleInput(TranscoderInput transcoderInput) throws TranscoderException {
        InputStream inputStream;
        if (transcoderInput == null) {
            this.handler.fatalError(new TranscoderException(String.valueOf(65280)));
        }
        if ((inputStream = transcoderInput.getInputStream()) != null) {
            return new DataInputStream(new BufferedInputStream(inputStream));
        }
        String string = transcoderInput.getURI();
        if (string != null) {
            try {
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
                return new DataInputStream(new BufferedInputStream(inputStream));
            }
            catch (MalformedURLException malformedURLException) {
                this.handler.fatalError(new TranscoderException(malformedURLException));
            }
            catch (IOException iOException) {
                this.handler.fatalError(new TranscoderException(iOException));
            }
        }
        this.handler.fatalError(new TranscoderException(String.valueOf(65281)));
        return null;
    }

    public static void main(String[] stringArray) throws TranscoderException {
        if (stringArray.length < 1) {
            System.out.println("Usage : WMFTranscoder.main <file 1> ... <file n>");
            System.exit(1);
        }
        WMFTranscoder wMFTranscoder = new WMFTranscoder();
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (!string.toLowerCase().endsWith(WMF_EXTENSION)) {
                System.err.println(stringArray[i2] + " does not have the " + WMF_EXTENSION + " extension. It is ignored");
                continue;
            }
            System.out.print("Processing : " + stringArray[i2] + "...");
            String string2 = string.substring(0, string.toLowerCase().indexOf(WMF_EXTENSION)) + SVG_EXTENSION;
            File file = new File(string);
            File file2 = new File(string2);
            try {
                TranscoderInput transcoderInput = new TranscoderInput(file.toURL().toString());
                TranscoderOutput transcoderOutput = new TranscoderOutput(new FileOutputStream(file2));
                wMFTranscoder.transcode(transcoderInput, transcoderOutput);
            }
            catch (MalformedURLException malformedURLException) {
                throw new TranscoderException(malformedURLException);
            }
            catch (IOException iOException) {
                throw new TranscoderException(iOException);
            }
            System.out.println(".... Done");
        }
        System.exit(0);
    }
}

