/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class DoublyIndexedTable {
    protected int initialCapacity;
    protected Entry[] table;
    protected int count;

    public DoublyIndexedTable() {
        this(16);
    }

    public DoublyIndexedTable(int n2) {
        this.initialCapacity = n2;
        this.table = new Entry[n2];
    }

    public DoublyIndexedTable(DoublyIndexedTable doublyIndexedTable) {
        this.initialCapacity = doublyIndexedTable.initialCapacity;
        this.table = new Entry[doublyIndexedTable.table.length];
        for (int i2 = 0; i2 < doublyIndexedTable.table.length; ++i2) {
            Entry entry = null;
            Entry entry2 = doublyIndexedTable.table[i2];
            while (entry2 != null) {
                entry = new Entry(entry2.hash, entry2.key1, entry2.key2, entry2.value, entry);
                entry2 = entry2.next;
            }
            this.table[i2] = entry;
        }
        this.count = doublyIndexedTable.count;
    }

    public int size() {
        return this.count;
    }

    public Object put(Object object, Object object2, Object object3) {
        Entry entry;
        int n2 = this.hashCode(object, object2) & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry2 = this.table[n3];
        while (entry2 != null) {
            if (entry2.hash == n2 && entry2.match(object, object2)) {
                Object object4 = entry2.value;
                entry2.value = object3;
                return object4;
            }
            entry2 = entry2.next;
        }
        int n4 = this.table.length;
        if (this.count++ >= n4 - (n4 >> 2)) {
            this.rehash();
            n3 = n2 % this.table.length;
        }
        this.table[n3] = entry = new Entry(n2, object, object2, object3, this.table[n3]);
        return null;
    }

    public Object get(Object object, Object object2) {
        int n2 = this.hashCode(object, object2) & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.match(object, object2)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object remove(Object object, Object object2) {
        int n2 = this.hashCode(object, object2) & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry = this.table[n3];
        if (entry == null) {
            return null;
        }
        if (entry.hash == n2 && entry.match(object, object2)) {
            this.table[n3] = entry.next;
            --this.count;
            return entry.value;
        }
        Entry entry2 = entry;
        entry = entry.next;
        while (entry != null) {
            if (entry.hash == n2 && entry.match(object, object2)) {
                entry2.next = entry.next;
                --this.count;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public Object[] getValuesArray() {
        Object[] objectArray = new Object[this.count];
        int n2 = 0;
        for (int i2 = 0; i2 < this.table.length; ++i2) {
            Entry entry = this.table[i2];
            while (entry != null) {
                objectArray[n2++] = entry.value;
                entry = entry.next;
            }
        }
        return objectArray;
    }

    public void clear() {
        this.table = new Entry[this.initialCapacity];
        this.count = 0;
    }

    public Iterator iterator() {
        return new TableIterator();
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        for (int i2 = entryArray.length - 1; i2 >= 0; --i2) {
            Entry entry = entryArray[i2];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = entry2.hash % this.table.length;
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
        }
    }

    protected int hashCode(Object object, Object object2) {
        int n2 = object == null ? 0 : object.hashCode();
        return n2 ^ (object2 == null ? 0 : object2.hashCode());
    }

    protected class TableIterator
    implements Iterator {
        private int nextIndex;
        private Entry nextEntry;
        private boolean finished;

        public TableIterator() {
            while (this.nextIndex < DoublyIndexedTable.this.table.length) {
                this.nextEntry = DoublyIndexedTable.this.table[this.nextIndex];
                if (this.nextEntry != null) break;
                ++this.nextIndex;
            }
            this.finished = this.nextEntry == null;
        }

        public boolean hasNext() {
            return !this.finished;
        }

        public Object next() {
            if (this.finished) {
                throw new NoSuchElementException();
            }
            Entry entry = this.nextEntry;
            this.findNext();
            return entry;
        }

        protected void findNext() {
            this.nextEntry = this.nextEntry.next;
            if (this.nextEntry == null) {
                ++this.nextIndex;
                while (this.nextIndex < DoublyIndexedTable.this.table.length) {
                    this.nextEntry = DoublyIndexedTable.this.table[this.nextIndex];
                    if (this.nextEntry != null) break;
                    ++this.nextIndex;
                }
            }
            this.finished = this.nextEntry == null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Entry {
        protected int hash;
        protected Object key1;
        protected Object key2;
        protected Object value;
        protected Entry next;

        public Entry(int n2, Object object, Object object2, Object object3, Entry entry) {
            this.hash = n2;
            this.key1 = object;
            this.key2 = object2;
            this.value = object3;
            this.next = entry;
        }

        public Object getKey1() {
            return this.key1;
        }

        public Object getKey2() {
            return this.key2;
        }

        public Object getValue() {
            return this.value;
        }

        protected boolean match(Object object, Object object2) {
            if (this.key1 != null ? !this.key1.equals(object) : object != null) {
                return false;
            }
            if (this.key2 != null) {
                return this.key2.equals(object2);
            }
            return object2 == null;
        }
    }
}

