/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.bcel.analyser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Select;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.Subroutine;

public class Subroutines {
    private Hashtable subroutines = new Hashtable();
    public final Subroutine TOPLEVEL;
    static final InstructionHandle[] empty = new InstructionHandle[0];

    public Subroutines(MethodGen mg) {
        InstructionHandle leader;
        InstructionHandle[] all = mg.getInstructionList().getInstructionHandles();
        CodeExceptionGen[] handlers = mg.getExceptionHandlers();
        this.TOPLEVEL = new SubroutineImpl();
        HashSet<InstructionHandle> sub_leaders = new HashSet<InstructionHandle>();
        for (int i2 = 0; i2 < all.length; ++i2) {
            Instruction inst = all[i2].getInstruction();
            if (!(inst instanceof JsrInstruction)) continue;
            sub_leaders.add(((JsrInstruction)inst).getTarget());
        }
        Iterator iter = sub_leaders.iterator();
        while (iter.hasNext()) {
            SubroutineImpl sr = new SubroutineImpl();
            InstructionHandle astore = (InstructionHandle)iter.next();
            sr.setLocalVariable(((ASTORE)astore.getInstruction()).getIndex());
            this.subroutines.put(astore, sr);
        }
        this.subroutines.put(all[0], this.TOPLEVEL);
        sub_leaders.add(all[0]);
        for (int i3 = 0; i3 < all.length; ++i3) {
            Instruction inst = all[i3].getInstruction();
            if (!(inst instanceof JsrInstruction)) continue;
            leader = ((JsrInstruction)inst).getTarget();
            ((SubroutineImpl)this.getSubroutine(leader)).addEnteringJsrInstruction(all[i3]);
        }
        HashSet<InstructionHandle> instructions_assigned = new HashSet<InstructionHandle>();
        iter = sub_leaders.iterator();
        while (iter.hasNext()) {
            HashSet<InstructionHandle> closure = new HashSet<InstructionHandle>();
            leader = (InstructionHandle)iter.next();
            ArrayList<InstructionHandle> Q2 = new ArrayList<InstructionHandle>();
            Q2.add(leader);
            while (!Q2.isEmpty()) {
                while (!Q2.isEmpty()) {
                    InstructionHandle u2 = (InstructionHandle)Q2.remove(Q2.size() - 1);
                    if (!closure.add(u2)) continue;
                    InstructionHandle[] successors = Subroutines.getSuccessors(u2);
                    for (int i4 = 0; i4 < successors.length; ++i4) {
                        Q2.add(successors[i4]);
                    }
                }
                for (int i5 = 0; i5 < handlers.length; ++i5) {
                    InstructionHandle handlerPC;
                    if (!closure.contains(handlers[i5].getStartPC()) || closure.contains(handlerPC = handlers[i5].getHandlerPC())) continue;
                    Q2.add(handlerPC);
                }
            }
            ((SubroutineImpl)(leader == all[0] ? this.getTopLevel() : this.getSubroutine(leader))).setInstructions(closure);
            Iterator itr = closure.iterator();
            while (itr.hasNext()) {
                InstructionHandle h2 = (InstructionHandle)itr.next();
                if (instructions_assigned.add(h2)) continue;
                throw new StructuralCodeConstraintException("Instruction '" + h2 + "' is part of more than one subroutine (or of the top level and a subroutine).");
            }
            if (leader == all[0]) continue;
            ((SubroutineImpl)this.getSubroutine(leader)).setLeavingRET();
        }
        this.noRecursiveCalls(this.getTopLevel(), new HashSet());
    }

    private void noRecursiveCalls(Subroutine sub, HashSet set) {
        Subroutine[] subs = sub.subSubs();
        for (int i2 = 0; i2 < subs.length; ++i2) {
            int index = ((RET)subs[i2].getLeavingRET().getInstruction()).getIndex();
            if (!set.add(new Integer(index))) {
                SubroutineImpl si = (SubroutineImpl)subs[i2];
                throw new StructuralCodeConstraintException("Subroutine with local variable '" + si.localVariable + "', JSRs '" + si.theJSRs + "', RET '" + si.theRET + "' is called by a subroutine which uses the same local variable index as itself; maybe even a recursive call? JustIce's clean definition of a subroutine forbids both.");
            }
            this.noRecursiveCalls(subs[i2], set);
            set.remove(new Integer(index));
        }
    }

    public Subroutine getSubroutine(InstructionHandle leader) {
        Subroutine ret = (Subroutine)this.subroutines.get(leader);
        if (ret == null) {
            throw new AssertionViolatedException("Subroutine requested for an InstructionHandle that is not a leader of a subroutine.");
        }
        if (ret == this.TOPLEVEL) {
            throw new AssertionViolatedException("TOPLEVEL special subroutine requested; use getTopLevel().");
        }
        return ret;
    }

    public Subroutine subroutineOf(InstructionHandle any) {
        Iterator i2 = this.subroutines.values().iterator();
        while (i2.hasNext()) {
            Subroutine s2 = (Subroutine)i2.next();
            if (!s2.contains(any)) continue;
            return s2;
        }
        System.err.println("DEBUG: Please verify '" + any + "' lies in dead code.");
        return null;
    }

    public Subroutine getTopLevel() {
        return this.TOPLEVEL;
    }

    private static InstructionHandle[] getSuccessors(InstructionHandle instruction) {
        Instruction inst = instruction.getInstruction();
        if (inst instanceof RET) {
            return empty;
        }
        if (inst instanceof ReturnInstruction) {
            return empty;
        }
        if (inst instanceof ATHROW) {
            return empty;
        }
        InstructionHandle[] single = new InstructionHandle[1];
        if (inst instanceof JsrInstruction) {
            single[0] = instruction.getNext();
            return single;
        }
        if (inst instanceof GotoInstruction) {
            single[0] = ((GotoInstruction)inst).getTarget();
            return single;
        }
        if (inst instanceof BranchInstruction) {
            if (inst instanceof Select) {
                InstructionHandle[] matchTargets = ((Select)inst).getTargets();
                InstructionHandle[] ret = new InstructionHandle[matchTargets.length + 1];
                ret[0] = ((Select)inst).getTarget();
                System.arraycopy(matchTargets, 0, ret, 1, matchTargets.length);
                return ret;
            }
            InstructionHandle[] pair = new InstructionHandle[]{instruction.getNext(), ((BranchInstruction)inst).getTarget()};
            return pair;
        }
        single[0] = instruction.getNext();
        return single;
    }

    public String toString() {
        return "---\n" + this.subroutines.toString() + "\n---\n";
    }

    private class SubroutineImpl
    implements Subroutine {
        private final int UNSET = -1;
        private int localVariable = -1;
        private Set instructions;
        private HashSet theJSRs = new HashSet();
        private InstructionHandle theRET;

        public boolean contains(InstructionHandle inst) {
            return this.instructions.contains(inst);
        }

        public String toString() {
            int i2;
            String ret = "Subroutine: Local variable is '" + this.localVariable + "', JSRs are '" + this.theJSRs + "', RET is '" + this.theRET + "', Instructions: '" + this.instructions.toString() + "'.";
            ret = ret + " Accessed local variable slots: '";
            int[] alv = this.getAccessedLocalsIndices();
            for (i2 = 0; i2 < alv.length; ++i2) {
                ret = ret + alv[i2] + " ";
            }
            ret = ret + "'.";
            ret = ret + " Recursively (via subsub...routines) accessed local variable slots: '";
            alv = this.getRecursivelyAccessedLocalsIndices();
            for (i2 = 0; i2 < alv.length; ++i2) {
                ret = ret + alv[i2] + " ";
            }
            ret = ret + "'.";
            return ret;
        }

        void setLeavingRET() {
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("setLeavingRET() called for top-level 'subroutine' or forgot to set local variable first.");
            }
            Iterator iter = this.instructions.iterator();
            InstructionHandle ret = null;
            while (iter.hasNext()) {
                InstructionHandle actual = (InstructionHandle)iter.next();
                if (!(actual.getInstruction() instanceof RET)) continue;
                if (ret != null) {
                    throw new StructuralCodeConstraintException("Subroutine with more then one RET detected: '" + ret + "' and '" + actual + "'.");
                }
                ret = actual;
            }
            if (ret == null) {
                throw new StructuralCodeConstraintException("Subroutine without a RET detected.");
            }
            if (((RET)ret.getInstruction()).getIndex() != this.localVariable) {
                throw new StructuralCodeConstraintException("Subroutine uses '" + ret + "' which does not match the correct local variable '" + this.localVariable + "'.");
            }
            this.theRET = ret;
        }

        public InstructionHandle[] getEnteringJsrInstructions() {
            if (this == Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            InstructionHandle[] jsrs = new InstructionHandle[this.theJSRs.size()];
            return this.theJSRs.toArray(jsrs);
        }

        public void addEnteringJsrInstruction(InstructionHandle jsrInst) {
            if (jsrInst == null || !(jsrInst.getInstruction() instanceof JsrInstruction)) {
                throw new AssertionViolatedException("Expecting JsrInstruction InstructionHandle.");
            }
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("Set the localVariable first!");
            }
            if (this.localVariable != ((ASTORE)((JsrInstruction)jsrInst.getInstruction()).getTarget().getInstruction()).getIndex()) {
                throw new AssertionViolatedException("Setting a wrong JsrInstruction.");
            }
            this.theJSRs.add(jsrInst);
        }

        public InstructionHandle getLeavingRET() {
            if (this == Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            return this.theRET;
        }

        public InstructionHandle[] getInstructions() {
            InstructionHandle[] ret = new InstructionHandle[this.instructions.size()];
            return this.instructions.toArray(ret);
        }

        public int[] getRecursivelyAccessedLocalsIndices() {
            HashSet<Integer> s2 = new HashSet<Integer>();
            int[] lvs = this.getAccessedLocalsIndices();
            for (int j2 = 0; j2 < lvs.length; ++j2) {
                s2.add(new Integer(lvs[j2]));
            }
            this._getRecursivelyAccessedLocalsIndicesHelper(s2, this.subSubs());
            int[] ret = new int[s2.size()];
            Iterator i2 = s2.iterator();
            int j3 = -1;
            while (i2.hasNext()) {
                ret[++j3] = (Integer)i2.next();
            }
            return ret;
        }

        private void _getRecursivelyAccessedLocalsIndicesHelper(HashSet s2, Subroutine[] subs) {
            for (int i2 = 0; i2 < subs.length; ++i2) {
                int[] lvs = subs[i2].getAccessedLocalsIndices();
                for (int j2 = 0; j2 < lvs.length; ++j2) {
                    s2.add(new Integer(lvs[j2]));
                }
                if (subs[i2].subSubs().length == 0) continue;
                this._getRecursivelyAccessedLocalsIndicesHelper(s2, subs[i2].subSubs());
            }
        }

        public int[] getAccessedLocalsIndices() {
            HashSet<Integer> acc = new HashSet<Integer>();
            if (this.theRET == null && this != Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("This subroutine object must be built up completely before calculating accessed locals.");
            }
            Iterator i2 = this.instructions.iterator();
            while (i2.hasNext()) {
                InstructionHandle ih = (InstructionHandle)i2.next();
                if (!(ih.getInstruction() instanceof LocalVariableInstruction) && !(ih.getInstruction() instanceof RET)) continue;
                int idx = ((IndexedInstruction)ih.getInstruction()).getIndex();
                acc.add(new Integer(idx));
                try {
                    int s2;
                    if (!(ih.getInstruction() instanceof LocalVariableInstruction) || (s2 = ((LocalVariableInstruction)ih.getInstruction()).getType(null).getSize()) != 2) continue;
                    acc.add(new Integer(idx + 1));
                }
                catch (RuntimeException re) {
                    throw new AssertionViolatedException("Oops. BCEL did not like NULL as a ConstantPoolGen object.");
                }
            }
            int[] ret = new int[acc.size()];
            i2 = acc.iterator();
            int j2 = -1;
            while (i2.hasNext()) {
                ret[++j2] = (Integer)i2.next();
            }
            return ret;
        }

        public Subroutine[] subSubs() {
            HashSet<Subroutine> h2 = new HashSet<Subroutine>();
            Iterator i2 = this.instructions.iterator();
            while (i2.hasNext()) {
                Instruction inst = ((InstructionHandle)i2.next()).getInstruction();
                if (!(inst instanceof JsrInstruction)) continue;
                InstructionHandle targ = ((JsrInstruction)inst).getTarget();
                h2.add(Subroutines.this.getSubroutine(targ));
            }
            Subroutine[] ret = new Subroutine[h2.size()];
            return h2.toArray(ret);
        }

        void setLocalVariable(int i2) {
            if (this.localVariable != -1) {
                throw new AssertionViolatedException("localVariable set twice.");
            }
            this.localVariable = i2;
        }

        void setInstructions(Set _instructions) {
            this.instructions = _instructions;
        }
    }
}

